/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.util;

import electroblob.wizardry.constants.Element;
import electroblob.wizardry.item.ItemWizardArmour;
import electroblob.wizardry.util.InventoryUtils;
import java.util.Arrays;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;

public final class WizardArmourUtils {
    private WizardArmourUtils() {
    }

    public static boolean isWearingFullSet(EntityLivingBase entity, @Nullable Element element, @Nullable ItemWizardArmour.ArmourClass armourClass) {
        ItemStack helmet = entity.func_184582_a(EntityEquipmentSlot.HEAD);
        if (!(helmet.func_77973_b() instanceof ItemWizardArmour)) {
            return false;
        }
        Element e = element == null ? ((ItemWizardArmour)helmet.func_77973_b()).element : element;
        ItemWizardArmour.ArmourClass ac = armourClass == null ? ((ItemWizardArmour)helmet.func_77973_b()).armourClass : armourClass;
        return Arrays.stream(InventoryUtils.ARMOUR_SLOTS).allMatch(s -> entity.func_184582_a(s).func_77973_b() instanceof ItemWizardArmour && ((ItemWizardArmour)entity.func_184582_a((EntityEquipmentSlot)s).func_77973_b()).element == e && ((ItemWizardArmour)entity.func_184582_a((EntityEquipmentSlot)s).func_77973_b()).armourClass == ac);
    }

    public static Element getFullSetElement(EntityLivingBase entity) {
        if (WizardArmourUtils.isWearingFullSet(entity, null, null)) {
            ItemStack helmet = entity.func_184582_a(EntityEquipmentSlot.HEAD);
            return ((ItemWizardArmour)helmet.func_77973_b()).element;
        }
        return Element.MAGIC;
    }

    public static Element getFullSetElementForClass(EntityLivingBase entity, ItemWizardArmour.ArmourClass armourClass) {
        if (WizardArmourUtils.isWearingFullSet(entity, null, armourClass)) {
            ItemStack helmet = entity.func_184582_a(EntityEquipmentSlot.HEAD);
            return ((ItemWizardArmour)helmet.func_77973_b()).element != null ? ((ItemWizardArmour)helmet.func_77973_b()).element : Element.MAGIC;
        }
        return Element.MAGIC;
    }

    public static Optional<Element> getFullSetElementForClassOptional(EntityLivingBase entity, ItemWizardArmour.ArmourClass armourClass) {
        if (WizardArmourUtils.isWearingFullSet(entity, null, armourClass)) {
            ItemStack helmet = entity.func_184582_a(EntityEquipmentSlot.HEAD);
            return Optional.of(((ItemWizardArmour)helmet.func_77973_b()).element != null ? ((ItemWizardArmour)helmet.func_77973_b()).element : Element.MAGIC);
        }
        return Optional.empty();
    }

    public static ItemWizardArmour.ArmourClass getArmourClass(EntityLivingBase entity) {
        if (WizardArmourUtils.isWearingFullSet(entity, null, null)) {
            ItemStack helmet = entity.func_184582_a(EntityEquipmentSlot.HEAD);
            return ((ItemWizardArmour)helmet.func_77973_b()).armourClass;
        }
        return ItemWizardArmour.ArmourClass.WIZARD;
    }
}

