/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.worldgen;

import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.fml.common.IWorldGenerator;

public abstract class WorldGenOreBase
implements IWorldGenerator {
    public abstract void generate(Random var1, int var2, int var3, World var4, IChunkGenerator var5, IChunkProvider var6);

    public void addOreSpawn(IBlockState state, World world, Random random, int blockXPos, int blockZPos, int maxX, int maxZ, int maxVeinSize, int chancesToSpawn, int minY, int maxY) {
        assert (maxY > minY) : "The maximum Y must be greater than the Minimum Y";
        assert (maxX > 0 && maxX <= 16) : "addOreSpawn: The Maximum X must be greater than 0 and less than 16";
        assert (minY > 0) : "addOreSpawn: The Minimum Y must be greater than 0";
        assert (maxY < 256 && maxY > 0) : "addOreSpawn: The Maximum Y must be less than 256 but greater than 0";
        assert (maxZ > 0 && maxZ <= 16) : "addOreSpawn: The Maximum Z must be greater than 0 and less than 16";
        int diffBtwnMinMaxY = maxY - minY;
        for (int x = 0; x < chancesToSpawn; ++x) {
            int posX = blockXPos + random.nextInt(maxX);
            int posY = minY + random.nextInt(diffBtwnMinMaxY);
            int posZ = blockZPos + random.nextInt(maxZ);
            new WorldGenMinable(state, maxVeinSize).func_180709_b(world, random, new BlockPos(posX, posY, posZ));
        }
    }
}

