/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.worldgen;

import com.google.common.collect.ImmutableMap;
import com.windanesz.ancientspellcraft.AncientSpellcraft;
import com.windanesz.ancientspellcraft.Settings;
import com.windanesz.ancientspellcraft.entity.living.EntitySkeletonMageMinion;
import com.windanesz.ancientspellcraft.integration.antiqueatlas.ASAntiqueAtlasIntegration;
import com.windanesz.ancientspellcraft.worldgen.WorldGenSurfaceStructure;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardryAdvancementTriggers;
import electroblob.wizardry.registry.WizardryBlocks;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.util.GeometryUtils;
import electroblob.wizardry.worldgen.MossifierTemplateProcessor;
import electroblob.wizardry.worldgen.MultiTemplateProcessor;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.template.ITemplateProcessor;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.apache.commons.lang3.ArrayUtils;

@Mod.EventBusSubscriber
public class WorldgenAncientVault
extends WorldGenSurfaceStructure {
    private static final String SKELETON_MAGE_DATA_BLOCK_TAG = "skeleton_mage";
    private final Map<BiomeDictionary.Type, IBlockState> specialWallBlocks = ImmutableMap.of((Object)BiomeDictionary.Type.MESA, (Object)Blocks.field_180395_cM.func_176223_P(), (Object)BiomeDictionary.Type.MOUNTAIN, (Object)Blocks.field_150417_aV.func_176223_P(), (Object)BiomeDictionary.Type.NETHER, (Object)Blocks.field_150385_bj.func_176223_P(), (Object)BiomeDictionary.Type.SANDY, (Object)Blocks.field_150322_A.func_176223_P());

    public String getStructureName() {
        return "ancient_vault";
    }

    public long getRandomSeedModifier() {
        return 32478681L;
    }

    public boolean canGenerate(Random random, World world, int chunkX, int chunkZ) {
        return ArrayUtils.contains((int[])Settings.worldgenSettings.ancientVaultDimensions, (int)world.field_73011_w.getDimension()) && Settings.worldgenSettings.ancientVaultRarity > 0 && random.nextInt(Settings.worldgenSettings.ancientVaultRarity) == 0;
    }

    public ResourceLocation getStructureFile(Random random) {
        return AncientSpellcraft.settings.ancientVaultFiles[0];
    }

    public void spawnStructure(Random random, World world, BlockPos origin, Template template, PlacementSettings settings, ResourceLocation structureFile) {
        Element element = Element.values()[1 + random.nextInt(Element.values().length - 1)];
        Biome biome = world.func_180494_b(origin);
        IBlockState biomeCover = biome.field_76752_A;
        float mossiness = WorldgenAncientVault.getBiomeMossiness(biome);
        IBlockState wallMaterial = this.specialWallBlocks.keySet().stream().filter(t -> BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)t)).findFirst().map(this.specialWallBlocks::get).orElse(Blocks.field_150347_e.func_176223_P());
        BlockPlanks.EnumType woodType = BlockUtils.getBiomeWoodVariant((Biome)biome);
        HashSet blocksPlaced = new HashSet();
        MultiTemplateProcessor processor = new MultiTemplateProcessor(true, new ITemplateProcessor[]{(w, p, i) -> i.field_186243_b.func_177230_c() == Blocks.field_150346_d ? new Template.BlockInfo(i.field_186242_a, biomeCover, i.field_186244_c) : i, new MossifierTemplateProcessor(mossiness, 0.04f, origin.func_177956_o() + 1), (w, p, i) -> i.field_186243_b.func_177230_c() == Blocks.field_150349_c ? new Template.BlockInfo(i.field_186242_a, biomeCover, i.field_186244_c) : i, (w, p, i) -> i.field_186243_b.func_177230_c() == WizardryBlocks.receptacle ? new Template.BlockInfo(i.field_186242_a, i.field_186243_b, this.setElement(i.field_186244_c, element)) : i});
        template.func_189960_a(world, origin, (ITemplateProcessor)processor, settings, 18);
        IBlockState origins = world.func_180495_p(origin);
        ASAntiqueAtlasIntegration.markMysteryStructure(world, origin.func_177958_n(), origin.func_177952_p());
        Map dataBlocks = template.func_186258_a(origin, settings);
        for (Map.Entry entry : dataBlocks.entrySet()) {
            Vec3d vec = GeometryUtils.getCentre((BlockPos)((BlockPos)entry.getKey()));
            if (((String)entry.getValue()).equals(SKELETON_MAGE_DATA_BLOCK_TAG)) {
                EntitySkeletonMageMinion skeleton = new EntitySkeletonMageMinion(world);
                skeleton.func_70012_b(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, 0.0f, 0.0f);
                skeleton.setLifetime(-1);
                skeleton.func_180482_a(world.func_175649_E(origin), null);
                if (element == Element.HEALING) {
                    skeleton.populateSpellList(Element.HEALING, Spells.ray_of_purification);
                }
                world.func_72838_d((Entity)skeleton);
                continue;
            }
            Wizardry.logger.info("Unrecognised data block value {} in structure {}", entry.getValue(), (Object)structureFile);
        }
    }

    NBTTagCompound setElement(NBTTagCompound compound, Element element) {
        compound.func_74768_a("Element", element.ordinal());
        return compound;
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.player instanceof EntityPlayerMP && event.player.field_70173_aa % 20 == 0) {
            WizardryAdvancementTriggers.visit_structure.trigger((EntityPlayerMP)event.player);
        }
    }

    private static float getBiomeMossiness(Biome biome) {
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DENSE)) {
            return 0.7f;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE)) {
            return 0.7f;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.WET)) {
            return 0.5f;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP)) {
            return 0.5f;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST)) {
            return 0.3f;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.LUSH)) {
            return 0.3f;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DRY)) {
            return 0.0f;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.COLD)) {
            return 0.0f;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DEAD)) {
            return 0.0f;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.WASTELAND)) {
            return 0.0f;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER)) {
            return 0.0f;
        }
        return 0.1f;
    }
}

