/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.immersivecables.client.util;

import de.sanandrew.mods.immersivecables.client.util.ae.ModelRegistryAE2;
import de.sanandrew.mods.immersivecables.client.util.rs.ModelRegistryRS;
import de.sanandrew.mods.immersivecables.util.ICConfiguration;
import de.sanandrew.mods.immersivecables.util.ItemBlockRegistry;
import de.sanandrew.mods.immersivecables.wire.Wires;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(modid="immersivecables", value={Side.CLIENT})
public final class ModelRegistry {
    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        ModelRegistry.registerModelBlockItems(ItemBlockRegistry.BLOCK_COIL, (Map<Integer, ModelResourceLocation>)new HashMap<Integer, ModelResourceLocation>(){
            {
                Arrays.stream(Wires.VALUES).forEach((? super T wire) -> this.put(wire.ordinal(), new ModelResourceLocation("immersivecables:coil_block_" + wire.func_176610_l(), "inventory")));
            }
        });
        Arrays.stream(Wires.VALUES).forEach(wire -> ModelLoader.setCustomModelResourceLocation((Item)ItemBlockRegistry.WIRE_COIL, (int)wire.ordinal(), (ModelResourceLocation)new ModelResourceLocation("immersivecables:wire_" + wire.func_176610_l(), "inventory")));
        if (ICConfiguration.isAe2Enabled()) {
            ModelRegistryAE2.registerModels();
        }
        if (ICConfiguration.isRsEnabled()) {
            ModelRegistryRS.registerModels();
        }
    }

    public static void registerModelBlockItems(Block block, Map<Integer, ModelResourceLocation> metaToLocation) {
        Item blockItem = Item.func_150898_a((Block)block);
        metaToLocation.forEach((meta, location) -> ModelLoader.setCustomModelResourceLocation((Item)blockItem, (int)meta, (ModelResourceLocation)location));
    }
}

