/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.client.utils;

import com.google.common.util.concurrent.ListenableFuture;
import com.zeitheron.hammercore.utils.color.Color;
import com.zeitheron.hammercore.utils.color.ColorHelper;
import com.zeitheron.hammercore.utils.math.vec.Vector3;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderUtil {
    public static double zLevel = 0.0;
    private static final Random rand = new Random();

    public static void glTask(Runnable task) {
        try {
            Minecraft.func_71410_x().func_152344_a(task).get();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    public static <T> T glTask(Callable<T> task) {
        try {
            return (T)Minecraft.func_71410_x().func_152343_a(task).get();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void glTaskAsync(Runnable task) {
        Minecraft.func_71410_x().func_152344_a(task);
    }

    public static <T> ListenableFuture<T> glTaskAsync(Callable<T> task) {
        return Minecraft.func_71410_x().func_152343_a(task);
    }

    public static void drawFullRectangleFit(double x, double y, double width, double height) {
        int w = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096);
        int h = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4097);
        float ws = 1.0f;
        float hs = 1.0f;
        if (w > h) {
            hs = (float)h / (float)w;
        }
        if (h > w) {
            ws = (float)w / (float)h;
        }
        double nw = width * (double)ws;
        double nh = height * (double)hs;
        RenderUtil.drawFullTexturedModalRect(x + (width - nw) / 2.0, y + (height - nh) / 2.0, nw, nh);
    }

    public static void drawTexturedModalRect(double x, double y, double texX, double texY, double width, double height) {
        float n = 0.00390625f;
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder vb = tess.func_178180_c();
        vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vb.func_181662_b(x, y + height, zLevel).func_187315_a(texX * (double)n, (texY + height) * (double)n).func_181675_d();
        vb.func_181662_b(x + width, y + height, zLevel).func_187315_a((texX + width) * (double)n, (texY + height) * (double)n).func_181675_d();
        vb.func_181662_b(x + width, y, zLevel).func_187315_a((texX + width) * (double)n, texY * (double)n).func_181675_d();
        vb.func_181662_b(x, y, zLevel).func_187315_a(texX * (double)n, texY * (double)n).func_181675_d();
        tess.func_78381_a();
    }

    public static void drawFullTexturedModalRect(double x, double y, double width, double height) {
        float n = 0.00390625f;
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder vb = tess.func_178180_c();
        vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vb.func_181662_b(x, y + height, zLevel).func_187315_a(0.0, 1.0).func_181675_d();
        vb.func_181662_b(x + width, y + height, zLevel).func_187315_a(1.0, 1.0).func_181675_d();
        vb.func_181662_b(x + width, y, zLevel).func_187315_a(1.0, 0.0).func_181675_d();
        vb.func_181662_b(x, y, zLevel).func_187315_a(0.0, 0.0).func_181675_d();
        tess.func_78381_a();
    }

    public static void drawColoredModalRect(double x, double y, double width, double height, int rgb) {
        float r = ColorHelper.getRed(rgb);
        float g = ColorHelper.getGreen(rgb);
        float b = ColorHelper.getBlue(rgb);
        float a = ColorHelper.getAlpha(rgb);
        float n = 0.00390625f;
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder vb = tess.func_178180_c();
        vb.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        vb.func_181662_b(x, y + height, zLevel).func_181666_a(r, g, b, a).func_181675_d();
        vb.func_181662_b(x + width, y + height, zLevel).func_181666_a(r, g, b, a).func_181675_d();
        vb.func_181662_b(x + width, y, zLevel).func_181666_a(r, g, b, a).func_181675_d();
        vb.func_181662_b(x, y, zLevel).func_181666_a(r, g, b, a).func_181675_d();
        tess.func_78381_a();
    }

    public static void drawTexturedModalRect(double x, double y, double texX, double texY, double width, double height, double zLevel) {
        float n = 0.00390625f;
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder vb = tess.func_178180_c();
        vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vb.func_181662_b(x, y + height, zLevel).func_187315_a(texX * (double)n, (texY + height) * (double)n).func_181675_d();
        vb.func_181662_b(x + width, y + height, zLevel).func_187315_a((texX + width) * (double)n, (texY + height) * (double)n).func_181675_d();
        vb.func_181662_b(x + width, y, zLevel).func_187315_a((texX + width) * (double)n, texY * (double)n).func_181675_d();
        vb.func_181662_b(x, y, zLevel).func_187315_a(texX * (double)n, texY * (double)n).func_181675_d();
        tess.func_78381_a();
    }

    public static void drawTexturedModalRect(double xCoord, double yCoord, TextureAtlasSprite textureSprite, double widthIn, double heightIn) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexbuffer.func_181662_b(xCoord, yCoord + heightIn, 0.0).func_187315_a((double)textureSprite.func_94209_e(), (double)textureSprite.func_94210_h()).func_181675_d();
        vertexbuffer.func_181662_b(xCoord + widthIn, yCoord + heightIn, 0.0).func_187315_a((double)textureSprite.func_94212_f(), (double)textureSprite.func_94210_h()).func_181675_d();
        vertexbuffer.func_181662_b(xCoord + widthIn, yCoord, 0.0).func_187315_a((double)textureSprite.func_94212_f(), (double)textureSprite.func_94206_g()).func_181675_d();
        vertexbuffer.func_181662_b(xCoord, yCoord, 0.0).func_187315_a((double)textureSprite.func_94209_e(), (double)textureSprite.func_94206_g()).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawGradientRect(double left, double top, double width, double height, int startColor, int endColor) {
        float f = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(startColor & 0xFF) / 255.0f;
        float f4 = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(endColor & 0xFF) / 255.0f;
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        vertexbuffer.func_181662_b(left + width, top, zLevel).func_181666_a(f1, f2, f3, f).func_181675_d();
        vertexbuffer.func_181662_b(left, top, zLevel).func_181666_a(f1, f2, f3, f).func_181675_d();
        vertexbuffer.func_181662_b(left, top + height, zLevel).func_181666_a(f5, f6, f7, f4).func_181675_d();
        vertexbuffer.func_181662_b(left + width, top + height, zLevel).func_181666_a(f5, f6, f7, f4).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }

    public static void drawGradientRect(double left, double top, double width, double height, int startColor, int endColor, double zLevel) {
        float f = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(startColor & 0xFF) / 255.0f;
        float f4 = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(endColor & 0xFF) / 255.0f;
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        vertexbuffer.func_181662_b(left + width, top, zLevel).func_181666_a(f1, f2, f3, f).func_181675_d();
        vertexbuffer.func_181662_b(left, top, zLevel).func_181666_a(f1, f2, f3, f).func_181675_d();
        vertexbuffer.func_181662_b(left, top + height, zLevel).func_181666_a(f5, f6, f7, f4).func_181675_d();
        vertexbuffer.func_181662_b(left + width, top + height, zLevel).func_181666_a(f5, f6, f7, f4).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }

    public static void drawTextRGBA(FontRenderer font, String s, int x, int y, int r, int g, int b, int a) {
        font.func_78276_b(s, x, y, Color.packARGB(r, g, b, a));
    }

    public static void drawLine(Vector3 start, Vector3 end, int color, float size) {
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        Color.glColourRGBA(color);
        GL11.glPushMatrix();
        GL11.glLineWidth((float)size);
        GL11.glBegin((int)1);
        GL11.glVertex3d((double)start.x, (double)start.y, (double)start.z);
        GL11.glVertex3d((double)end.x, (double)end.y, (double)end.z);
        GL11.glEnd();
        GL11.glPopMatrix();
        GlStateManager.func_179098_w();
        Color.glColourRGBA(-1);
    }

    public static void drawBrokenLine(int color, float size, Vector3 ... points) {
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        Color.glColourRGBA(color);
        GL11.glPushMatrix();
        GL11.glLineWidth((float)size);
        GL11.glBegin((int)1);
        for (Vector3 point : points) {
            GL11.glVertex3d((double)point.x, (double)point.y, (double)point.z);
        }
        GL11.glEnd();
        GL11.glPopMatrix();
        GlStateManager.func_179098_w();
        Color.glColourRGBA(-1);
    }

    public static void renderColorfulLightRayEffects(double x, double y, double z, Function<Integer, Integer> rgba, long seed, float progress, int dstJump, int countFancy, int countNormal) {
        RenderUtil.renderColorfulLightRayEffects(x, y, z, rgba, seed, progress, dstJump, 1.0f, countFancy, countNormal);
    }

    public static void renderLightRayEffects(double x, double y, double z, int rgba, long seed, float progress, int dstJump, int countFancy, int countNormal) {
        RenderUtil.renderLightRayEffects(x, y, z, rgba, seed, progress, dstJump, 1.0f, countFancy, countNormal);
    }

    public static void setGlClearColorFromInt(int colorValue, int opacity) {
        int i = (colorValue & 0xFF0000) >> 16;
        int j = (colorValue & 0xFF00) >> 8;
        int k = colorValue & 0xFF;
        GlStateManager.func_179082_a((float)((float)i / 255.0f), (float)((float)j / 255.0f), (float)((float)k / 255.0f), (float)((float)opacity / 255.0f));
    }

    public static void renderLightRayEffects(double x, double y, double z, int rgba, long seed, float progress, int dstJump, float scale, int countFancy, int countNormal) {
        rand.setSeed(seed);
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        int fc = Minecraft.func_71410_x().field_71474_y.field_74347_j ? countFancy : countNormal;
        Tessellator tes = Tessellator.func_178181_a();
        BufferBuilder vb = tes.func_178180_c();
        float r = ColorHelper.getRed(rgba);
        float g = ColorHelper.getGreen(rgba);
        float b = ColorHelper.getBlue(rgba);
        float a = ColorHelper.getAlpha(rgba);
        RenderHelper.func_74518_a();
        GL11.glDisable((int)3553);
        GL11.glShadeModel((int)7425);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        GL11.glDisable((int)3008);
        GL11.glDepthMask((boolean)false);
        GL11.glPushMatrix();
        for (int i = 0; i < fc; ++i) {
            GL11.glRotatef((float)(rand.nextFloat() * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(rand.nextFloat() * 360.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(rand.nextFloat() * 360.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)(rand.nextFloat() * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(rand.nextFloat() * 360.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(rand.nextFloat() * 360.0f + progress * 360.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            vb.func_181668_a(6, DefaultVertexFormats.field_181706_f);
            float fa = rand.nextFloat() * 20.0f + 5.0f + a * 10.0f;
            float f4 = rand.nextFloat() * 2.0f + 1.0f + a * 2.0f;
            vb.func_181662_b(0.0, 0.0, 0.0).func_181666_a(r, g, b, (float)((int)(255.0f * a))).func_181675_d();
            vb.func_181662_b(-0.7 * (double)(f4 /= 30.0f / (Math.min((float)dstJump, 10.0f * scale) / 10.0f)), (double)(fa /= 30.0f / (Math.min((float)dstJump, 10.0f * scale) / 10.0f)), (double)(-0.5f * f4)).func_181666_a(r, g, b, 0.0f).func_181675_d();
            vb.func_181662_b(0.7 * (double)f4, (double)fa, (double)(-0.5f * f4)).func_181666_a(r, g, b, 0.0f).func_181675_d();
            vb.func_181662_b(0.0, (double)fa, (double)(1.0f * f4)).func_181666_a(r, g, b, 0.0f).func_181675_d();
            vb.func_181662_b(-0.7 * (double)f4, (double)fa, (double)(-0.5f * f4)).func_181666_a(r, g, b, 0.0f).func_181675_d();
            tes.func_78381_a();
        }
        GL11.glPopMatrix();
        GL11.glDepthMask((boolean)true);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glShadeModel((int)7424);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3008);
        RenderHelper.func_74519_b();
        GL11.glPopMatrix();
    }

    public static void renderColorfulLightRayEffects(double x, double y, double z, Function<Integer, Integer> rgba, long seed, float progress, int dstJump, float scale, int countFancy, int countNormal) {
        rand.setSeed(seed);
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        int fc = Minecraft.func_71410_x().field_71474_y.field_74347_j ? countFancy : countNormal;
        Tessellator tes = Tessellator.func_178181_a();
        BufferBuilder vb = tes.func_178180_c();
        RenderHelper.func_74518_a();
        GL11.glDisable((int)3553);
        GL11.glShadeModel((int)7425);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        GL11.glDisable((int)3008);
        GL11.glDepthMask((boolean)false);
        GL11.glPushMatrix();
        for (int i = 0; i < fc; ++i) {
            int irgba = rgba.apply(i);
            float r = ColorHelper.getRed(irgba);
            float g = ColorHelper.getGreen(irgba);
            float b = ColorHelper.getBlue(irgba);
            float a = ColorHelper.getAlpha(irgba);
            GL11.glRotatef((float)(rand.nextFloat() * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(rand.nextFloat() * 360.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(rand.nextFloat() * 360.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)(rand.nextFloat() * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(rand.nextFloat() * 360.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(rand.nextFloat() * 360.0f + progress * 360.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            vb.func_181668_a(6, DefaultVertexFormats.field_181706_f);
            float fa = rand.nextFloat() * 20.0f + 5.0f + a * 10.0f;
            float f4 = rand.nextFloat() * 2.0f + 1.0f + a * 2.0f;
            vb.func_181662_b(0.0, 0.0, 0.0).func_181666_a(r, g, b, (float)((int)(255.0f * a))).func_181675_d();
            vb.func_181662_b(-0.7 * (double)(f4 /= 30.0f / (Math.min((float)dstJump, 10.0f * scale) / 10.0f)), (double)(fa /= 30.0f / (Math.min((float)dstJump, 10.0f * scale) / 10.0f)), (double)(-0.5f * f4)).func_181666_a(r, g, b, 0.0f).func_181675_d();
            vb.func_181662_b(0.7 * (double)f4, (double)fa, (double)(-0.5f * f4)).func_181666_a(r, g, b, 0.0f).func_181675_d();
            vb.func_181662_b(0.0, (double)fa, (double)(1.0f * f4)).func_181666_a(r, g, b, 0.0f).func_181675_d();
            vb.func_181662_b(-0.7 * (double)f4, (double)fa, (double)(-0.5f * f4)).func_181666_a(r, g, b, 0.0f).func_181675_d();
            tes.func_78381_a();
        }
        GL11.glPopMatrix();
        GL11.glDepthMask((boolean)true);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)3042);
        GL11.glShadeModel((int)7424);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3008);
        RenderHelper.func_74519_b();
        GL11.glPopMatrix();
    }

    public static void drawHorizontalGradientRect(float left, float top, float width, float height, int startColor, int endColor) {
        float f = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(startColor & 0xFF) / 255.0f;
        float f4 = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(endColor & 0xFF) / 255.0f;
        float right = left + width;
        float bottom = top + height;
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        bufferbuilder.func_181662_b((double)right, (double)top, 0.0).func_181666_a(f1, f2, f3, f).func_181675_d();
        bufferbuilder.func_181662_b((double)left, (double)top, 0.0).func_181666_a(f1, f2, f3, f).func_181675_d();
        bufferbuilder.func_181662_b((double)left, (double)bottom, 0.0).func_181666_a(f5, f6, f7, f4).func_181675_d();
        bufferbuilder.func_181662_b((double)right, (double)bottom, 0.0).func_181666_a(f5, f6, f7, f4).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }

    public static void drawVerticalGradientRect(float left, float top, float width, float height, int startColor, int endColor) {
        float f = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(startColor & 0xFF) / 255.0f;
        float f4 = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(endColor & 0xFF) / 255.0f;
        float right = left + width;
        float bottom = top + height;
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        bufferbuilder.func_181662_b((double)right, (double)top, 0.0).func_181666_a(f5, f6, f7, f4).func_181675_d();
        bufferbuilder.func_181662_b((double)left, (double)top, 0.0).func_181666_a(f1, f2, f3, f).func_181675_d();
        bufferbuilder.func_181662_b((double)left, (double)bottom, 0.0).func_181666_a(f1, f2, f3, f).func_181675_d();
        bufferbuilder.func_181662_b((double)right, (double)bottom, 0.0).func_181666_a(f5, f6, f7, f4).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }

    public static class PlayerRenderUtil {
        public static void rotateIfSneaking(EntityPlayer player) {
            if (player.func_70093_af()) {
                PlayerRenderUtil.applySneakingRotation();
            }
        }

        public static void applySneakingRotation() {
            GlStateManager.func_179109_b((float)0.0f, (float)0.2f, (float)0.0f);
            GlStateManager.func_179114_b((float)28.647888f, (float)1.0f, (float)0.0f, (float)0.0f);
        }

        public static void translateToHeadLevel(EntityPlayer player) {
            GlStateManager.func_179109_b((float)0.0f, (float)(-player.getDefaultEyeHeight()), (float)0.0f);
            if (player.func_70093_af()) {
                GlStateManager.func_179109_b((float)(0.25f * MathHelper.func_76126_a((float)(player.field_70125_A * (float)Math.PI / 180.0f))), (float)(0.25f * MathHelper.func_76134_b((float)(player.field_70125_A * (float)Math.PI / 180.0f))), (float)0.0f);
            }
        }

        public static void translateToFace() {
            GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179109_b((float)0.0f, (float)-4.35f, (float)-1.27f);
        }

        public static void defaultTransforms() {
            GlStateManager.func_179137_b((double)0.0, (double)3.0, (double)1.0);
            GlStateManager.func_179139_a((double)0.55, (double)0.55, (double)0.55);
        }

        public static void translateToChest() {
            GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179109_b((float)0.0f, (float)-3.2f, (float)-0.85f);
        }
    }
}

