/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.lib.nashorn;

import com.zeitheron.hammercore.lib.nashorn.JSCallbackInfo;
import com.zeitheron.hammercore.lib.nashorn.JSSource;
import com.zeitheron.hammercore.utils.java.itf.IArgumentFunction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import jdk.nashorn.api.scripting.ScriptObjectMirror;

public class JSScript {
    private final JSSource sourceUnmodified;
    protected final Invocable root;
    protected final ScriptEngine engine;

    public JSScript(JSSource source) throws ScriptException {
        this.sourceUnmodified = source;
        this.engine = new ScriptEngineManager(null).getEngineByName("nashorn");
        this.engine.eval(this.handlePreprocessing(this.getSource()).read());
        this.root = (Invocable)((Object)this.engine);
    }

    public IArgumentFunction getFunction(String name) {
        ScriptObjectMirror mirror;
        Object o = this.engine.get(name);
        if (o instanceof ScriptObjectMirror && (mirror = (ScriptObjectMirror)o).isFunction()) {
            return args -> JSScript.toJava(mirror.call((Object)mirror, args));
        }
        return null;
    }

    public JSCallbackInfo callFunction(String name, Object ... arguments) {
        Object o = this.engine.get(name);
        if (o instanceof ScriptObjectMirror) {
            ScriptObjectMirror mirror = (ScriptObjectMirror)o;
            if (!mirror.isFunction()) {
                return new JSCallbackInfo(false, false, new NoSuchMethodException(name));
            }
            try {
                return new JSCallbackInfo(JSScript.toJava(mirror.call((Object)mirror, arguments)));
            }
            catch (Throwable e) {
                return new JSCallbackInfo(true, false, e);
            }
        }
        return new JSCallbackInfo(false, false, new NoSuchMethodException(name));
    }

    public static Object toJava(Object jsObj) {
        if (jsObj instanceof ScriptObjectMirror) {
            ScriptObjectMirror js = (ScriptObjectMirror)jsObj;
            if (js.isFunction()) {
                return args -> JSScript.toJava(js.call((Object)js, args));
            }
            if (js.isArray()) {
                ArrayList<Object> list = new ArrayList<Object>();
                for (Map.Entry entry : js.entrySet()) {
                    list.add(JSScript.toJava(entry.getValue()));
                }
                return list;
            }
            HashMap map = new HashMap();
            for (Map.Entry entry : js.entrySet()) {
                map.put(entry.getKey(), JSScript.toJava(entry.getValue()));
            }
            return map;
        }
        return jsObj;
    }

    protected JSSource handlePreprocessing(JSSource src) {
        return src;
    }

    public final JSSource getSource() {
        return this.sourceUnmodified.copy();
    }
}

