/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.lib.nashorn;

import com.google.common.base.Strings;
import com.zeitheron.hammercore.lib.nashorn.JSImporter;
import com.zeitheron.hammercore.lib.zlib.io.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Scanner;
import java.util.function.BiPredicate;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public interface JSSource {
    public String read();

    default public boolean exists() {
        return !Strings.isNullOrEmpty((String)this.read());
    }

    default public JSSource copy() {
        final JSSource root = this;
        return new JSSource(){

            @Override
            public String read() {
                return root.read();
            }

            @Override
            public boolean exists() {
                return root.exists();
            }
        };
    }

    default public JSSource processImports() {
        final JSSource main = this;
        return new JSSource(){

            @Override
            public String read() {
                StringBuilder ns = new StringBuilder();
                String script = main.read();
                try (Scanner scan = new Scanner(script);){
                    while (scan.hasNextLine()) {
                        String ln = scan.nextLine();
                        String trimmed = ln.trim();
                        if (trimmed.startsWith("import ")) {
                            ln = trimmed.endsWith(";") ? trimmed.substring(7, trimmed.length() - 1) : trimmed.substring(7);
                            String simpleName = ln.substring(ln.lastIndexOf(46) + 1);
                            ln = "var " + simpleName + " = Java.type(\"" + ln + "\");";
                        }
                        ns.append(ln).append(scan.hasNextLine() ? "\n" : "");
                    }
                }
                return ns.toString();
            }

            @Override
            public boolean exists() {
                return main.exists();
            }
        };
    }

    default public JSSource addClassPointer(final Class<?> type, final String reference) {
        final JSSource main = this;
        return new JSSource(){

            @Override
            public String read() {
                return "var " + reference + " = Java.type(\"" + type.getCanonicalName() + "\");" + main.read();
            }

            @Override
            public boolean exists() {
                return main.exists();
            }
        };
    }

    default public JSSource inheritClassMethods(Class<?> type) {
        return this.inheritClassMethods(type, JSImporter.alwaysTrue);
    }

    default public JSSource inheritClassMethods(final Class<?> type, final BiPredicate<String, Method> allow) {
        final JSSource main = this;
        return new JSSource(){

            @Override
            public String read() {
                return JSImporter.createJSWrap(type, allow) + main.read();
            }

            @Override
            public boolean exists() {
                return main.exists();
            }
        };
    }

    public static JSSource fromLocalResource(Class<?> from, String path) {
        String fp = path.startsWith("/") ? path : "/" + path;
        return () -> {
            byte[] data = new byte[]{};
            try (InputStream in = from.getResourceAsStream(fp);){
                if (in != null) {
                    data = IOUtils.pipeOut(in);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return data.length == 0 ? null : new String(data);
        };
    }

    @SideOnly(value=Side.CLIENT)
    public static JSSource fromResourceManager(IResourceManager manager, ResourceLocation path) {
        return () -> {
            byte[] data = new byte[]{};
            try (IResource res = manager.func_110536_a(path);){
                data = IOUtils.pipeOut(res.func_110527_b());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return data.length == 0 ? null : new String(data);
        };
    }
}

