/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.mospells.spell;

import com.bobmowzie.mowziesmobs.server.entity.effects.EntityBoulder;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityRing;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import com.windanesz.mospells.MoSpells;
import com.windanesz.mospells.registry.MSItems;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.util.SpellModifiers;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.block.BlockFence;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class LesserGeomancy
extends SpellRay {
    private static final Field travelling = ObfuscationReflectionHelper.findField(EntityBoulder.class, (String)"travelling");
    private static final Field ridingEntities = ObfuscationReflectionHelper.findField(EntityBoulder.class, (String)"ridingEntities");

    public LesserGeomancy() {
        super("mospells", "lesser_geomancy", SpellActions.POINT, false);
        this.soundValues(1.0f, 1.1f, 0.2f);
    }

    protected boolean onEntityHit(World world, Entity target, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (target instanceof EntityBoulder) {
            return LesserGeomancy.spellHitBoulder((EntityBoulder)target, caster, 0);
        }
        return false;
    }

    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        return LesserGeomancy.spawnBoulder(world, caster, pos, 0);
    }

    protected boolean onMiss(World world, EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    public static boolean isBlockDiggable(IBlockState blockState) {
        Material mat = blockState.func_185904_a();
        if (mat != Material.field_151577_b && mat != Material.field_151578_c && mat != Material.field_151576_e && mat != Material.field_151571_B && mat != Material.field_151595_p) {
            return false;
        }
        return blockState != Blocks.field_150407_cf && blockState.func_177230_c() != Blocks.field_189878_dg && !(blockState.func_177230_c() instanceof BlockFence) && blockState.func_177230_c() != Blocks.field_150474_ac && blockState.func_177230_c() != Blocks.field_189880_di && blockState.func_177230_c() != Blocks.field_150381_bn && blockState.func_177230_c() != Blocks.field_150378_br && blockState.func_177230_c() != Blocks.field_150477_bB && blockState.func_177230_c() != Blocks.field_180399_cE;
    }

    public static boolean spawnBoulder(World world, EntityLivingBase caster, int size) {
        return LesserGeomancy.spawnBoulder(world, caster, new BlockPos(caster.field_70165_t, caster.field_70163_u - 1.0, caster.field_70161_v), size);
    }

    public static boolean spawnBoulder(World world, EntityLivingBase caster, BlockPos pos, int size) {
        if (!caster.field_70122_E) {
            return false;
        }
        IBlockState spawnBoulderBlock = world.func_180495_p(pos);
        if (!LesserGeomancy.isBlockDiggable(spawnBoulderBlock)) {
            return false;
        }
        EntityBoulder boulder = new EntityBoulder(caster.field_70170_p, caster, size, spawnBoulderBlock);
        boulder.func_70107_b((double)((float)pos.func_177958_n() + 0.5f), (double)(pos.func_177956_o() + 2), (double)((float)pos.func_177952_p() + 0.5f));
        if (!world.field_72995_K && boulder.checkCanSpawn()) {
            world.func_72838_d((Entity)boulder);
        }
        return true;
    }

    public static boolean spellHitBoulder(EntityBoulder boulder, EntityLivingBase entityIn, int maxSize) {
        if (boulder.field_70173_aa < 10) {
            return false;
        }
        float speed = 1.5f;
        if (entityIn instanceof EntityPlayer) {
            boolean riding = false;
            EntityPlayer player = (EntityPlayer)entityIn;
            if (ItemArtefact.isArtefactActive((EntityPlayer)player, (Item)MSItems.amulet_earth)) {
                maxSize = 3;
            }
            if (boulder.boulderSize > maxSize) {
                return false;
            }
            try {
                boulder.setDeathTime(60);
                travelling.set(boulder, true);
                if (ridingEntities.get(boulder) instanceof List) {
                    riding = ((List)ridingEntities.get(boulder)).contains(player);
                }
            }
            catch (IllegalAccessException e) {
                MoSpells.logger.error("Error during reflective access of EntityBoulder properties: ", (Throwable)e);
                return false;
            }
            if (riding) {
                Vec3d lateralLookVec = Vec3d.func_189986_a((float)0.0f, (float)player.field_70177_z).func_72432_b();
                boulder.field_70159_w = (double)speed * 0.5 * lateralLookVec.field_72450_a;
                boulder.field_70179_y = (double)speed * 0.5 * lateralLookVec.field_72449_c;
            } else {
                boulder.field_70159_w = (double)speed * 0.5 * player.func_70040_Z().field_72450_a;
                boulder.field_70181_x = (double)speed * 0.5 * player.func_70040_Z().field_72448_b;
                boulder.field_70179_y = (double)speed * 0.5 * player.func_70040_Z().field_72449_c;
            }
            if (boulder.boulderSize == 0) {
                boulder.func_184185_a(MMSounds.EFFECT_GEOMANCY_HIT_SMALL, 1.5f, 1.3f);
                boulder.func_184185_a(MMSounds.EFFECT_GEOMANCY_MAGIC_SMALL, 1.5f, 0.9f);
            } else if (boulder.boulderSize == 1) {
                boulder.func_184185_a(MMSounds.EFFECT_GEOMANCY_HIT_SMALL, 1.5f, 0.9f);
                boulder.func_184185_a(MMSounds.EFFECT_GEOMANCY_MAGIC_SMALL, 1.5f, 0.5f);
            } else if (boulder.boulderSize == 2) {
                boulder.func_184185_a(MMSounds.EFFECT_GEOMANCY_HIT_SMALL, 1.5f, 0.5f);
                boulder.func_184185_a(MMSounds.EFFECT_GEOMANCY_MAGIC_BIG, 1.5f, 1.3f);
            } else if (boulder.boulderSize == 3) {
                boulder.func_184185_a(MMSounds.EFFECT_GEOMANCY_HIT_MEDIUM_1, 1.5f, 1.0f);
                boulder.func_184185_a(MMSounds.EFFECT_GEOMANCY_MAGIC_BIG, 1.5f, 0.9f);
            }
            Vec3d ringOffset = new Vec3d(boulder.field_70159_w, boulder.field_70181_x, boulder.field_70179_y).func_72432_b().func_186678_a(-1.0);
            EntityRing ring = new EntityRing(entityIn.field_70170_p, (float)boulder.field_70165_t + (float)ringOffset.field_72450_a, (float)boulder.field_70163_u + 0.5f + (float)ringOffset.field_72448_b, (float)boulder.field_70161_v + (float)ringOffset.field_72449_c, ringOffset.func_72432_b(), 5, 0.83f, 1.0f, 0.39f, 1.0f, 1.5f, false);
            entityIn.field_70170_p.func_72838_d((Entity)ring);
        }
        return true;
    }

    public boolean applicableForItem(Item item) {
        return item == MSItems.mospells_spell_book || item == MSItems.mospells_scroll;
    }
}

