/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.mospells.spell;

import com.bobmowzie.mowziesmobs.client.particle.MMParticle;
import com.bobmowzie.mowziesmobs.client.particle.ParticleFactory;
import com.bobmowzie.mowziesmobs.server.entity.LeaderSunstrikeImmune;
import com.windanesz.mospells.registry.MSItems;
import com.windanesz.mospells.registry.MSSpells;
import com.windanesz.mospells.util.Utils;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.AllyDesignationSystem;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class SolarFlare
extends Spell {
    public static final String KNOCKBACK = "knockback";

    public SolarFlare() {
        super("mospells", "solar_flare", SpellActions.THRUST, true);
        this.addProperties(new String[]{"damage", "blast_radius", "burn_duration", KNOCKBACK});
    }

    public boolean cast(World world, EntityLiving caster, EnumHand hand, int ticksInUse, EntityLivingBase target, SpellModifiers modifiers) {
        return SolarFlare.createSolarFlare(world, (EntityLivingBase)caster, hand, ticksInUse, modifiers);
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        return SolarFlare.createSolarFlare(world, (EntityLivingBase)caster, hand, ticksInUse, modifiers);
    }

    public static boolean createSolarFlare(World world, EntityLivingBase caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        if (ticksInUse == 1) {
            world.func_184133_a(null, caster.func_180425_c(), new SoundEvent(new ResourceLocation("ebwizardry:spell.fire_breath.start")), WizardrySounds.SPELLS, 1.0f, 1.0f);
        }
        float radius = MSSpells.solar_flare.getProperty("blast_radius").floatValue() * modifiers.get(WizardryItems.blast_upgrade);
        if (world.field_72995_K && ticksInUse < 6) {
            int particleCount = 3 * MSSpells.solar_flare.getProperty("blast_radius").intValue();
            while (--particleCount != 0) {
                double yaw = (double)(world.field_73012_v.nextFloat() * 2.0f) * Math.PI;
                double pitch = (double)(world.field_73012_v.nextFloat() * 2.0f) * Math.PI;
                double ox = (double)radius * Math.sin(yaw) * Math.sin(pitch);
                double oy = (double)radius * Math.cos(pitch);
                double oz = (double)radius * Math.cos(yaw) * Math.sin(pitch);
                double offsetX = -0.3 * Math.sin((double)caster.field_70177_z * Math.PI / 180.0);
                double offsetZ = -0.3 * Math.cos((double)caster.field_70177_z * Math.PI / 180.0);
                double offsetY = 1.0;
                MMParticle.ORB.spawn(world, caster.field_70165_t + ox + offsetX, caster.field_70163_u + offsetY + oy, caster.field_70161_v + oz + offsetZ, ParticleFactory.ParticleArgs.get().withData(new Object[]{caster.field_70165_t + offsetX, caster.field_70163_u + offsetY, caster.field_70161_v + offsetZ, 6}));
            }
        }
        if (ticksInUse == 10 && world.field_72995_K) {
            for (int i = 0; i < 30; ++i) {
                float velocity = 0.25f;
                float yaw = (float)i * 0.20943952f;
                float vy = world.field_73012_v.nextFloat() * 0.1f - 0.05f;
                float vx = 0.25f * MathHelper.func_76134_b((float)yaw);
                float vz = 0.25f * MathHelper.func_76126_a((float)yaw);
                world.func_175688_a(EnumParticleTypes.FLAME, caster.field_70165_t, caster.field_70163_u + 1.0, caster.field_70161_v, (double)vx, (double)vy, (double)vz, new int[0]);
            }
        }
        float damage = MSSpells.solar_flare.getProperty("damage").floatValue() * modifiers.get("potency");
        float knockback = MSSpells.solar_flare.getProperty(KNOCKBACK).floatValue() * modifiers.get("potency");
        if (ticksInUse == 8 && world.field_72995_K) {
            int i = 0;
            while ((float)i < 40.0f * modifiers.get(WizardryItems.blast_upgrade)) {
                double particleX = caster.field_70165_t - 1.0 + 2.0 * world.field_73012_v.nextDouble();
                double particleZ = caster.field_70161_v - 1.0 + 2.0 * world.field_73012_v.nextDouble();
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.MAGIC_FIRE).scale(1.1f).pos(particleX, (double)(caster.func_180425_c().func_177956_o() + 1), particleZ).vel(particleX - caster.field_70165_t, 0.0, particleZ - caster.field_70161_v).spawn(world);
                particleX = caster.field_70165_t - 1.0 + 2.0 * world.field_73012_v.nextDouble();
                particleZ = caster.field_70161_v - 1.0 + 2.0 * world.field_73012_v.nextDouble();
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE).pos(particleX, (double)(caster.func_180425_c().func_177956_o() + 1), particleZ).vel(particleX - caster.field_70165_t, 0.0, particleZ - caster.field_70161_v).time(30).clr(15251968).spawn(world);
                particleX = caster.field_70165_t - 1.0 + 2.0 * world.field_73012_v.nextDouble();
                particleZ = caster.field_70161_v - 1.0 + 2.0 * world.field_73012_v.nextDouble();
                IBlockState block = world.func_180495_p(new BlockPos(caster.field_70165_t, (double)caster.func_180425_c().func_177956_o() - 0.5 + 1.0, caster.field_70161_v));
                if (block != null) {
                    world.func_175688_a(EnumParticleTypes.BLOCK_DUST, particleX, (double)(caster.func_180425_c().func_177956_o() + 1), particleZ, particleX - caster.field_70165_t, 0.0, particleZ - caster.field_70161_v, new int[]{Block.func_176210_f((IBlockState)block)});
                }
                ++i;
            }
        }
        if (ticksInUse == 12) {
            world.func_184133_a(null, caster.func_180425_c(), SoundEvents.field_187539_bB, WizardrySounds.SPELLS, 1.0f, 1.0f);
            List hit = EntityUtils.getEntitiesWithinRadius((double)radius, (double)caster.field_70165_t, (double)caster.field_70163_u, (double)caster.field_70161_v, (World)world, EntityLivingBase.class);
            for (EntityLivingBase entityHit : hit) {
                if (entityHit instanceof LeaderSunstrikeImmune || entityHit == caster || AllyDesignationSystem.isAllied((EntityLivingBase)caster, (EntityLivingBase)entityHit)) continue;
                entityHit.func_70097_a(MagicDamage.causeDirectMagicDamage((Entity)caster, (MagicDamage.DamageType)MagicDamage.DamageType.FIRE), damage);
                entityHit.func_70015_d(2);
                double angle = Utils.getAngleBetweenEntities((Entity)caster, (Entity)entityHit);
                entityHit.field_70159_w = (double)knockback * Math.cos(Math.toRadians(angle - 90.0));
                entityHit.field_70179_y = (double)knockback * Math.sin(Math.toRadians(angle - 90.0));
            }
        }
        return true;
    }

    public boolean canBeCastBy(EntityLiving npc, boolean override) {
        return true;
    }

    public boolean applicableForItem(Item item) {
        return item == MSItems.mospells_spell_book || item == MSItems.mospells_scroll;
    }
}

