/*
 * Decompiled with CFR 0.152.
 */
package teamrtg.passableleaves;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import teamrtg.passableleaves.PassableLeaves;

final class NetworkDispatcher {
    static final NetworkDispatcher INSTANCE = new NetworkDispatcher();
    private final SimpleNetworkWrapper dispatcher = NetworkRegistry.INSTANCE.newSimpleChannel("passableleaves");

    private NetworkDispatcher() {
    }

    void sendConfigSyncMessageToAll() {
        PassableLeaves.LOGGER.debug("Sending a config sync packet to all clients");
        this.dispatcher.sendToAll((IMessage)new SyncConfigMessage());
    }

    void sendConfigSyncMessageToPlayer(EntityPlayerMP player) {
        PassableLeaves.LOGGER.debug("Sending a config sync packet to {}", (Object)player.func_70005_c_());
        this.dispatcher.sendTo((IMessage)new SyncConfigMessage(), player);
    }

    static void init() {
        NetworkDispatcher.INSTANCE.dispatcher.registerMessage(SyncConfigMessage.class, SyncConfigMessage.class, 0, Side.CLIENT);
    }

    public static final class SyncConfigMessage
    implements IMessage,
    IMessageHandler<SyncConfigMessage, IMessage> {
        public boolean isLocalServer = false;
        public float fallDamageReduction = PassableLeaves.PLConfig.getFallDamageReduction();
        public int fallDamageThreshold = PassableLeaves.PLConfig.getFallDamageThreshold();
        public double speedReductionHorizontal = PassableLeaves.PLConfig.getSpeedReductionHorizontal();
        public double speedReductionVertical = PassableLeaves.PLConfig.getSpeedReductionVertical();

        public void toBytes(ByteBuf buf) {
            buf.writeBoolean(FMLCommonHandler.instance().getMinecraftServerInstance().func_71264_H());
            buf.writeFloat(PassableLeaves.PLConfig.getFallDamageReduction());
            buf.writeInt(PassableLeaves.PLConfig.getFallDamageThreshold());
            buf.writeDouble(PassableLeaves.PLConfig.getSpeedReductionHorizontal());
            buf.writeDouble(PassableLeaves.PLConfig.getSpeedReductionVertical());
        }

        public void fromBytes(ByteBuf buf) {
            this.isLocalServer = buf.readBoolean();
            this.fallDamageReduction = buf.readFloat();
            this.fallDamageThreshold = buf.readInt();
            this.speedReductionHorizontal = buf.readDouble();
            this.speedReductionVertical = buf.readDouble();
        }

        public IMessage onMessage(SyncConfigMessage message, MessageContext ctx) {
            PassableLeaves.LOGGER.debug("Received a config sync packet from the server, updating settings");
            PassableLeaves.LOCAL_SERVER = message.isLocalServer;
            PassableLeaves.fallDamageReduction = message.fallDamageReduction;
            PassableLeaves.fallDamageThreshold = message.fallDamageThreshold;
            PassableLeaves.speedReductionHorizontal = message.speedReductionHorizontal;
            PassableLeaves.speedReductionVertical = message.speedReductionVertical;
            return null;
        }
    }
}

