/*
 * Decompiled with CFR 0.152.
 */
package teamrtg.passableleaves;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.NumberInvalidException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.IModGuiFactory;
import net.minecraftforge.fml.client.config.GuiConfig;
import net.minecraftforge.fml.client.config.IConfigElement;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.server.command.CommandTreeBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import teamrtg.passableleaves.NetworkDispatcher;

@Mod(modid="passableleaves", name="Passable Leaves", version="2.0.0", dependencies="required-after:passableleavescore@[1.0.0,)", guiFactory="teamrtg.passableleaves.PassableLeaves$PLGuiConfigFactory", acceptedMinecraftVersions="[1.12.2]")
public class PassableLeaves {
    static final String MOD_ID = "passableleaves";
    static final String MOD_NAME = "Passable Leaves";
    static final String MOD_VERSION = "2.0.0";
    static final Logger LOGGER = LogManager.getLogger((String)"passableleaves");
    static boolean LOCAL_SERVER = true;
    @Mod.Instance(value="passableleaves")
    private static PassableLeaves instance;
    @SidedProxy
    private static CommonProxy proxy;
    static float fallDamageReduction;
    static int fallDamageThreshold;
    static double speedReductionHorizontal;
    static double speedReductionVertical;
    private static final DamageSource DAMAGESOURCE_FALLINTOLEAVES;

    @Mod.EventHandler
    public void initPre(FMLPreInitializationEvent event) {
        proxy.preInit(event);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init(event);
    }

    @Mod.EventHandler
    public void initPost(FMLPostInitializationEvent event) {
        proxy.postInit(event);
    }

    @Mod.EventHandler
    public void addcommand(FMLServerStartingEvent event) {
        proxy.addCommand(event);
    }

    public static void onEntityCollidedWithLeaves(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (entity instanceof EntityLivingBase) {
            EntityLivingBase livingEntity = (EntityLivingBase)entity;
            if (livingEntity.field_70143_R > 3.0f) {
                entity.func_184185_a(SoundEvents.field_187571_bR, SoundType.field_185850_c.func_185843_a() * 0.6f, SoundType.field_185850_c.func_185847_b() * 0.65f);
            } else if (world.func_82737_E() % 6L == 0L && (entity.field_70165_t != entity.field_70169_q || entity.field_70163_u != entity.field_70167_r || entity.field_70161_v != entity.field_70166_s)) {
                entity.func_184185_a(SoundEvents.field_187575_bT, SoundType.field_185850_c.func_185843_a() * 0.5f, SoundType.field_185850_c.func_185847_b() * 0.45f);
            }
            if (!livingEntity.field_70703_bu) {
                entity.field_70159_w *= speedReductionHorizontal;
                entity.field_70181_x *= speedReductionVertical;
                entity.field_70179_y *= speedReductionHorizontal;
            }
            if (livingEntity.field_70143_R > (float)fallDamageThreshold) {
                livingEntity.field_70143_R -= (float)fallDamageThreshold;
                PotionEffect pe = livingEntity.func_70660_b(MobEffects.field_76430_j);
                int amount = MathHelper.func_76123_f((float)(livingEntity.field_70143_R * fallDamageReduction * (pe == null ? 1.0f : 0.9f)));
                livingEntity.func_70097_a(DAMAGESOURCE_FALLINTOLEAVES, (float)amount);
            }
            if (livingEntity.field_70143_R > 1.0f) {
                livingEntity.field_70143_R = 1.0f;
            }
            if (entity.func_184207_aI()) {
                for (Entity ent : entity.func_184188_bt()) {
                    PassableLeaves.onEntityCollidedWithLeaves(world, pos, state, ent);
                }
            }
        }
    }

    static {
        DAMAGESOURCE_FALLINTOLEAVES = new DamageSource("fallintoleaves"){

            public ITextComponent func_151519_b(EntityLivingBase entity) {
                return new TextComponentTranslation("passableleaves.death.fallintoleaves", new Object[]{entity.func_145748_c_()});
            }
        };
    }

    public static final class ConfigSyncHandler {
        ConfigSyncHandler() {
        }

        @SubscribeEvent
        @SideOnly(value=Side.SERVER)
        public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            EntityPlayerMP player;
            MinecraftServer listener;
            if (event.player instanceof EntityPlayerMP && (listener = (player = (EntityPlayerMP)event.player).func_184102_h()) != null) {
                listener.func_152344_a(() -> NetworkDispatcher.INSTANCE.sendConfigSyncMessageToPlayer(player));
            }
        }

        @SubscribeEvent
        @SideOnly(value=Side.CLIENT)
        public void onClientDisconnect(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
            LOCAL_SERVER = true;
            PLConfig.sync();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static final class PLGuiConfigFactory
    implements IModGuiFactory {
        public void initialize(Minecraft mc) {
        }

        public boolean hasConfigGui() {
            return true;
        }

        public GuiScreen createConfigGui(GuiScreen parentScreen) {
            return new PLGuiConfig(parentScreen);
        }

        public Set<IModGuiFactory.RuntimeOptionCategoryElement> runtimeGuiCategories() {
            return null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static final class PLGuiConfig
    extends GuiConfig {
        PLGuiConfig(GuiScreen parent) {
            super(parent, PLGuiConfig.getConfigElements(), PassableLeaves.MOD_ID, false, false, I18n.func_135052_a((String)"passableleaves.config.maintitle", (Object[])new Object[0]));
            this.titleLine2 = I18n.func_135052_a((String)"passableleaves.config.maintitle2", (Object[])new Object[0]);
        }

        private static List<IConfigElement> getConfigElements() {
            ArrayList ret = Lists.newArrayList();
            PLConfig.config.getCategory(PassableLeaves.MOD_ID).values().forEach(e -> {
                e.setComment(I18n.func_135052_a((String)(e.getLanguageKey() + ".comment"), (Object[])new Object[]{Character.valueOf('\n'), Character.valueOf('\n'), Character.valueOf('\n')}));
                ret.add(new ConfigElement(e));
            });
            return ret;
        }

        public void func_146281_b() {
            super.func_146281_b();
            PLConfig.sync();
        }
    }

    static final class PLConfig {
        private static File configFile;
        private static Configuration config;
        private static Property fallDamageThreshold;
        private static Property fallDamageReduction;
        private static Property speedReductionHorizontal;
        private static Property speedReductionVertical;

        private PLConfig() {
        }

        private static void init(FMLPreInitializationEvent event) {
            if (configFile == null) {
                configFile = event.getSuggestedConfigurationFile();
            }
            if (config == null) {
                config = new Configuration(configFile);
            }
            config.setCategoryComment(PassableLeaves.MOD_ID, "These settings get overridden when connected to a remote server.");
            fallDamageReduction = config.get(PassableLeaves.MOD_ID, "Fall Damage Reduction", 50, "The percentage of normal damage taken when taking damage from falling into leaves." + Configuration.NEW_LINE + "The damage will be reduced by a further 10% with the Jump Boost potion effect.", 0, 100).setLanguageKey("passableleaves.config.fallDamageReduction");
            fallDamageThreshold = config.get(PassableLeaves.MOD_ID, "Fall Damage Threshold", 20, "When falling into leaves, the (block) distance a player or mob has to fall before taking damage.", 5, 255).setLanguageKey("passableleaves.config.fallDamageThreshold");
            speedReductionHorizontal = config.get(PassableLeaves.MOD_ID, "Speed Reduction - Horizontal", 90, "The reduced horizontal speed when passing through leaves. (% of normal)", 0, 100).setLanguageKey("passableleaves.config.speedReductionHorizontal");
            speedReductionVertical = config.get(PassableLeaves.MOD_ID, "Speed Reduction - Vertical", 90, "The reduced vertical speed when passing through leaves. (% of normal)", 0, 100).setLanguageKey("passableleaves.config.speedReductionVertical");
            if (config.hasChanged()) {
                config.save();
            }
        }

        private static void sync() {
            if (config.hasChanged()) {
                LOGGER.debug("Saving config");
                config.save();
            }
            if (LOCAL_SERVER) {
                LOGGER.debug("Syncing config settings on client");
                fallDamageReduction = PLConfig.getFallDamageReduction();
                fallDamageThreshold = PLConfig.getFallDamageThreshold();
                speedReductionHorizontal = PLConfig.getSpeedReductionHorizontal();
                speedReductionVertical = PLConfig.getSpeedReductionVertical();
            }
        }

        static float getFallDamageReduction() {
            return (float)fallDamageReduction.getInt() / 100.0f;
        }

        static int getFallDamageThreshold() {
            return fallDamageThreshold.getInt();
        }

        static double getSpeedReductionHorizontal() {
            return speedReductionHorizontal.getDouble() / 100.0;
        }

        static double getSpeedReductionVertical() {
            return speedReductionVertical.getDouble() / 100.0;
        }
    }

    @ParametersAreNonnullByDefault
    @MethodsReturnNonnullByDefault
    static final class PLCommandTree
    extends CommandTreeBase {
        private static final int ACCESS_ALL = 0;
        private static final int ACCESS_OPS = 2;
        private static final int ACCESS_ADMIN = 4;
        private static final String LANG_KEY_BASE = "passableleaves.command";
        private static final String LANG_KEY_PREFIX_ERROR = "passableleaves.command.prefix.error";
        private static final String LANG_KEY_SETTINGS_HEADER = "passableleaves.command.setting.header";
        private static final String LANG_KEY_CURRENT_SETTING = "passableleaves.command.setting.current";
        private static final String LANG_KEY_VALUE_INVALID = "passableleaves.command.setting.invalid";
        private static final String LANG_KEY_VALUE_OUTOFRANGE = "passableleaves.command.setting.valueOutOfRange";
        private static final String LANG_KEY_ADDENDUM_STATUS = "passableleaves.command.addendum.status";
        private static final String LANG_KEY_ADDENDUM_SAVE = "passableleaves.command.addendum.save";
        private static final Style STYLE_ERROR = new Style().func_150228_d(Boolean.valueOf(true)).func_150238_a(TextFormatting.DARK_RED);
        private static final Style STYLE_DKGREEN = new Style().func_150238_a(TextFormatting.DARK_GREEN);
        private static final Style STYLE_GOLD = new Style().func_150238_a(TextFormatting.GOLD);
        private static final Style STYLE_DKAQUA = new Style().func_150238_a(TextFormatting.DARK_AQUA);
        private static final Style STYLE_AQUA = new Style().func_150238_a(TextFormatting.AQUA);
        private static final Style STYLE_GRAY = new Style().func_150238_a(TextFormatting.GRAY);
        private static final String CMD_ROOT = "passableleaves";

        PLCommandTree() {
            this.addSubcommand((ICommand)new CommandStatus(this.func_71517_b()));
            this.addSubcommand((ICommand)new CommandSave(this.func_71517_b()));
            this.addSubcommand((ICommand)new CommandTreeDamage(this.func_71517_b()));
            this.addSubcommand((ICommand)new CommandTreeSpeed(this.func_71517_b()));
        }

        public int func_82362_a() {
            return 0;
        }

        public String func_71517_b() {
            return "passableleaves";
        }

        public String func_71518_a(ICommandSender sender) {
            TextComponentString ret = new TextComponentString("");
            this.getSubCommands().forEach(arg_0 -> PLCommandTree.lambda$getUsage$1((ITextComponent)ret, sender, arg_0));
            return ret.func_150254_d();
        }

        private static String getUsageForBasicCommand(ICommand cmd, String parent, String addendum) {
            return new TextComponentString("    /").func_150257_a(new TextComponentString(parent + " " + cmd.func_71517_b()).func_150255_a(STYLE_DKAQUA)).func_150258_a(" ").func_150257_a(new TextComponentTranslation(addendum, new Object[0]).func_150255_a(STYLE_AQUA)).func_150254_d();
        }

        private static String getUsageForPropCommand(ICommand cmd, String parent, Property cfgProp) {
            return new TextComponentString("    /").func_150257_a(new TextComponentString(parent + " " + cmd.func_71517_b()).func_150255_a(STYLE_DKAQUA)).func_150258_a(" <").func_150257_a(new TextComponentString(cfgProp.getMinValue()).func_150255_a(STYLE_GRAY)).func_150258_a(" - ").func_150257_a(new TextComponentString(cfgProp.getMaxValue()).func_150255_a(STYLE_GRAY)).func_150258_a(">").func_150254_d();
        }

        private static void executor(ICommand cmd, ICommandSender sender, String[] args, Property cfgProp) {
            int value;
            if (args.length == 0) {
                sender.func_145747_a(new TextComponentString("  ").func_150257_a(new TextComponentTranslation(cfgProp.getLanguageKey(), new Object[0]).func_150255_a(STYLE_DKAQUA)).func_150258_a(" ").func_150257_a((ITextComponent)new TextComponentTranslation(LANG_KEY_CURRENT_SETTING, new Object[0])).func_150258_a(" ").func_150257_a(new TextComponentString(cfgProp.getString()).func_150255_a(STYLE_AQUA)));
                return;
            }
            try {
                value = CommandBase.func_175755_a((String)args[0]);
            }
            catch (NumberInvalidException e) {
                sender.func_145747_a(new TextComponentString("  ").func_150257_a(new TextComponentTranslation(LANG_KEY_PREFIX_ERROR, new Object[0]).func_150255_a(STYLE_ERROR)).func_150258_a(": ").func_150257_a((ITextComponent)new TextComponentTranslation(LANG_KEY_VALUE_INVALID, new Object[0])).func_150258_a(": ").func_150257_a(new TextComponentString(e.func_74844_a().length > 0 ? e.func_74844_a()[0].toString() : "[NULL]").func_150255_a(STYLE_GOLD)));
                sender.func_145747_a((ITextComponent)new TextComponentString(cmd.func_71518_a(sender)));
                return;
            }
            if (value < Integer.valueOf(cfgProp.getMinValue()) || value > Integer.valueOf(cfgProp.getMaxValue())) {
                sender.func_145747_a(new TextComponentString("  ").func_150257_a(new TextComponentTranslation(LANG_KEY_PREFIX_ERROR, new Object[0]).func_150255_a(STYLE_ERROR)).func_150258_a(": ").func_150257_a((ITextComponent)new TextComponentTranslation(LANG_KEY_VALUE_OUTOFRANGE, new Object[0])).func_150258_a(": ").func_150257_a(new TextComponentString(String.valueOf(value)).func_150255_a(STYLE_GOLD)));
                sender.func_145747_a((ITextComponent)new TextComponentString(cmd.func_71518_a(sender)));
                return;
            }
            sender.func_145747_a(new TextComponentString("  ").func_150258_a("Setting ").func_150257_a(new TextComponentTranslation(cfgProp.getLanguageKey(), new Object[0]).func_150255_a(STYLE_DKAQUA)).func_150258_a(" to: ").func_150257_a(new TextComponentString(cfgProp.setValue(value).getString()).func_150255_a(STYLE_AQUA)));
            NetworkDispatcher.INSTANCE.sendConfigSyncMessageToAll();
        }

        private static /* synthetic */ void lambda$getUsage$1(ITextComponent ret, ICommandSender sender, ICommand cmd) {
            if (cmd instanceof CommandTreeBase) {
                ((CommandTreeBase)cmd).getSubCommands().forEach(rcmd -> ret.func_150258_a("\n").func_150258_a(rcmd.func_71518_a(sender)));
            } else {
                ret.func_150258_a("\n").func_150258_a(cmd.func_71518_a(sender));
            }
        }

        static final class CommandTreeSpeed
        extends CommandTreeBase {
            private static final String NAME = "speed";
            private final String parentName;

            CommandTreeSpeed(String parentName) {
                this.parentName = parentName;
                this.addSubcommand((ICommand)new CommandSpeedHorizontal(this.parentName + " " + this.func_71517_b()));
                this.addSubcommand((ICommand)new CommandSpeedVertical(this.parentName + " " + this.func_71517_b()));
            }

            public int func_82362_a() {
                return 2;
            }

            public String func_71517_b() {
                return NAME;
            }

            public String func_71518_a(ICommandSender sender) {
                return PLCommandTree.getUsageForBasicCommand((ICommand)this, this.parentName, "[horizontal|vertical]");
            }

            static final class CommandSpeedVertical
            extends CommandBase {
                private static final String NAME = "vertical";
                private final String parentName;
                private final Property cfgProp = PLConfig.access$1000();

                CommandSpeedVertical(String parentName) {
                    this.parentName = parentName;
                }

                public int func_82362_a() {
                    return 2;
                }

                public String func_71517_b() {
                    return NAME;
                }

                public String func_71518_a(ICommandSender sender) {
                    return PLCommandTree.getUsageForPropCommand((ICommand)this, this.parentName, this.cfgProp);
                }

                public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) {
                    PLCommandTree.executor((ICommand)this, sender, args, this.cfgProp);
                }
            }

            static final class CommandSpeedHorizontal
            extends CommandBase {
                private static final String NAME = "horizontal";
                private final String parentName;
                private final Property cfgProp = PLConfig.access$900();

                CommandSpeedHorizontal(String parentName) {
                    this.parentName = parentName;
                }

                public int func_82362_a() {
                    return 2;
                }

                public String func_71517_b() {
                    return NAME;
                }

                public String func_71518_a(ICommandSender sender) {
                    return PLCommandTree.getUsageForPropCommand((ICommand)this, this.parentName, this.cfgProp);
                }

                public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) {
                    PLCommandTree.executor((ICommand)this, sender, args, this.cfgProp);
                }
            }
        }

        static final class CommandTreeDamage
        extends CommandTreeBase {
            private static final String NAME = "damage";
            private final String parentName;

            CommandTreeDamage(String parentName) {
                this.parentName = parentName;
                this.addSubcommand((ICommand)new CommandFallDamageReduction(this.parentName + " " + this.func_71517_b()));
                this.addSubcommand((ICommand)new CommandFallDamageThreshold(this.parentName + " " + this.func_71517_b()));
            }

            public int func_82362_a() {
                return 2;
            }

            public String func_71517_b() {
                return NAME;
            }

            public String func_71518_a(ICommandSender sender) {
                return PLCommandTree.getUsageForBasicCommand((ICommand)this, this.parentName, "[reduction|threshold]");
            }

            static final class CommandFallDamageThreshold
            extends CommandBase {
                private static final String NAME = "threshold";
                private final String parentName;
                private final Property cfgProp = PLConfig.access$800();

                CommandFallDamageThreshold(String parentName) {
                    this.parentName = parentName;
                }

                public int func_82362_a() {
                    return 2;
                }

                public String func_71517_b() {
                    return NAME;
                }

                public String func_71518_a(ICommandSender sender) {
                    return PLCommandTree.getUsageForPropCommand((ICommand)this, this.parentName, this.cfgProp);
                }

                public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) {
                    PLCommandTree.executor((ICommand)this, sender, args, this.cfgProp);
                }
            }

            static final class CommandFallDamageReduction
            extends CommandBase {
                private static final String NAME = "reduction";
                private final String parentName;
                private final Property cfgProp = PLConfig.access$600();

                CommandFallDamageReduction(String parentName) {
                    this.parentName = parentName;
                }

                public int func_82362_a() {
                    return 2;
                }

                public String func_71517_b() {
                    return NAME;
                }

                public String func_71518_a(ICommandSender sender) {
                    return PLCommandTree.getUsageForPropCommand((ICommand)this, this.parentName, this.cfgProp);
                }

                public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) {
                    PLCommandTree.executor((ICommand)this, sender, args, this.cfgProp);
                }
            }
        }

        static final class CommandSave
        extends CommandBase {
            private static final String NAME = "save";
            private final String parentName;

            CommandSave(String parentName) {
                this.parentName = parentName;
            }

            public int func_82362_a() {
                return 4;
            }

            public String func_71517_b() {
                return NAME;
            }

            public String func_71518_a(ICommandSender sender) {
                return PLCommandTree.getUsageForBasicCommand((ICommand)this, this.parentName, PLCommandTree.LANG_KEY_ADDENDUM_SAVE);
            }

            public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) {
                sender.func_145747_a(new TextComponentString("  ").func_150258_a("Saving current settings to PassableLeaves config.").func_150255_a(STYLE_DKGREEN));
                PLConfig.sync();
            }
        }

        static final class CommandStatus
        extends CommandBase {
            private static final String NAME = "status";
            private final String parentName;

            CommandStatus(String parentName) {
                this.parentName = parentName;
            }

            public int func_82362_a() {
                return 0;
            }

            public String func_71517_b() {
                return NAME;
            }

            public String func_71518_a(ICommandSender sender) {
                return PLCommandTree.getUsageForBasicCommand((ICommand)this, this.parentName, PLCommandTree.LANG_KEY_ADDENDUM_STATUS);
            }

            public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) {
                sender.func_145747_a(new TextComponentString("  ").func_150257_a(new TextComponentTranslation(PLCommandTree.LANG_KEY_SETTINGS_HEADER, new Object[0]).func_150255_a(STYLE_DKGREEN)).func_150258_a(":"));
                sender.func_145747_a(new TextComponentString("    ").func_150257_a(new TextComponentTranslation(PLConfig.fallDamageReduction.getLanguageKey(), new Object[0]).func_150255_a(STYLE_DKAQUA)).func_150258_a(" : ").func_150257_a(new TextComponentString(PLConfig.fallDamageReduction.getString()).func_150255_a(STYLE_AQUA)));
                sender.func_145747_a(new TextComponentString("    ").func_150257_a(new TextComponentTranslation(PLConfig.fallDamageThreshold.getLanguageKey(), new Object[0]).func_150255_a(STYLE_DKAQUA)).func_150258_a(" : ").func_150257_a(new TextComponentString(PLConfig.fallDamageThreshold.getString()).func_150255_a(STYLE_AQUA)));
                sender.func_145747_a(new TextComponentString("    ").func_150257_a(new TextComponentTranslation(PLConfig.speedReductionHorizontal.getLanguageKey(), new Object[0]).func_150255_a(STYLE_DKAQUA)).func_150258_a(" : ").func_150257_a(new TextComponentString(PLConfig.speedReductionHorizontal.getString()).func_150255_a(STYLE_AQUA)));
                sender.func_145747_a(new TextComponentString("    ").func_150257_a(new TextComponentTranslation(PLConfig.speedReductionVertical.getLanguageKey(), new Object[0]).func_150255_a(STYLE_DKAQUA)).func_150258_a(" : ").func_150257_a(new TextComponentString(PLConfig.speedReductionVertical.getString()).func_150255_a(STYLE_AQUA)));
            }
        }
    }

    public static final class ServerProxy
    extends CommonProxy {
        @Override
        public void preInit(FMLPreInitializationEvent event) {
            super.preInit(event);
        }

        @Override
        public void init(FMLInitializationEvent event) {
            super.init(event);
        }

        @Override
        public void postInit(FMLPostInitializationEvent event) {
            super.postInit(event);
        }

        @Override
        public void addCommand(FMLServerStartingEvent event) {
            super.addCommand(event);
        }
    }

    public static final class ClientProxy
    extends CommonProxy {
        @Override
        public void preInit(FMLPreInitializationEvent event) {
            super.preInit(event);
        }

        @Override
        public void init(FMLInitializationEvent event) {
            super.init(event);
        }

        @Override
        public void postInit(FMLPostInitializationEvent event) {
            super.postInit(event);
        }

        @Override
        public void addCommand(FMLServerStartingEvent event) {
            super.addCommand(event);
        }
    }

    private static abstract class CommonProxy {
        private CommonProxy() {
        }

        void preInit(FMLPreInitializationEvent event) {
            LOGGER.debug("Initialising configuration");
            PLConfig.init(event);
            LOGGER.debug("Registering network messages");
            NetworkDispatcher.init();
            LOGGER.debug("Registering a new ConfigSyncHandler");
            MinecraftForge.EVENT_BUS.register((Object)new ConfigSyncHandler());
        }

        void init(FMLInitializationEvent event) {
        }

        void postInit(FMLPostInitializationEvent event) {
            PLConfig.sync();
        }

        void addCommand(FMLServerStartingEvent event) {
            LOGGER.debug("Registering /passableleaves command");
            event.registerServerCommand((ICommand)new PLCommandTree());
        }
    }
}

