/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.netherex.block;

import java.util.Random;
import logictechcorp.libraryex.block.BlockMod;
import logictechcorp.libraryex.block.property.BlockProperties;
import logictechcorp.netherex.NetherEx;
import logictechcorp.netherex.init.NetherExBlocks;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockEnokiMushroomCap
extends BlockMod {
    private static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)5);

    public BlockEnokiMushroomCap() {
        super(NetherEx.getResource("enoki_mushroom_cap"), new BlockProperties(Material.field_151585_k, MapColor.field_151666_j).sound(SoundType.field_185848_a).hardness(0.4f).tickRandomly());
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random random) {
        if (!this.canSurvive(world, pos)) {
            world.func_175655_b(pos, true);
        } else {
            int age;
            BlockPos blockPos = pos.func_177977_b();
            if (world.func_175623_d(blockPos) && blockPos.func_177956_o() > 0 && (age = ((Integer)state.func_177229_b((IProperty)AGE)).intValue()) < 5 && random.nextInt(1) == 0) {
                boolean canGrow = false;
                boolean nearNetherrack = false;
                Block block = world.func_180495_p(pos.func_177984_a()).func_177230_c();
                if (block == NetherExBlocks.LIVELY_NETHERRACK) {
                    canGrow = true;
                } else if (block == NetherExBlocks.ENOKI_MUSHROOM_STEM) {
                    int growthChance = 1;
                    for (int i = 0; i < 4; ++i) {
                        Block checkBlock = world.func_180495_p(pos.func_177981_b(growthChance + 1)).func_177230_c();
                        if (checkBlock != NetherExBlocks.ENOKI_MUSHROOM_STEM) {
                            if (checkBlock != Blocks.field_150424_aL && checkBlock != NetherExBlocks.LIVELY_NETHERRACK) break;
                            nearNetherrack = true;
                            break;
                        }
                        ++growthChance;
                    }
                    int randomGrowthChance = 4;
                    if (nearNetherrack) {
                        ++randomGrowthChance;
                    }
                    if (growthChance < 2 || random.nextInt(randomGrowthChance) >= growthChance) {
                        canGrow = true;
                    }
                } else if (block == Blocks.field_150350_a) {
                    canGrow = true;
                }
                if (canGrow && BlockEnokiMushroomCap.areAllNeighborsEmpty(world, blockPos, null) && world.func_175623_d(pos.func_177979_c(2))) {
                    world.func_180501_a(pos, NetherExBlocks.ENOKI_MUSHROOM_STEM.func_176223_P(), 2);
                    this.placeGrownCap(world, blockPos, age);
                } else if (age < 4) {
                    int growths = random.nextInt(4);
                    boolean grew = false;
                    if (nearNetherrack) {
                        ++growths;
                    }
                    for (int i = 0; i < growths; ++i) {
                        EnumFacing facing = EnumFacing.Plane.HORIZONTAL.func_179518_a(random);
                        BlockPos offsetPos = pos.func_177972_a(facing);
                        if (!world.func_175623_d(offsetPos) || !world.func_175623_d(offsetPos.func_177984_a()) || !BlockEnokiMushroomCap.areAllNeighborsEmpty(world, offsetPos, facing.func_176734_d())) continue;
                        this.placeGrownCap(world, offsetPos, age + 1);
                        grew = true;
                    }
                    if (grew) {
                        world.func_180501_a(pos, NetherExBlocks.ENOKI_MUSHROOM_STEM.func_176223_P(), 2);
                    } else {
                        this.placeDeadCap(world, pos);
                    }
                } else if (age == 4) {
                    this.placeDeadCap(world, pos);
                }
            }
        }
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return super.func_176196_c(world, pos) && this.canSurvive(world, pos);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!this.canSurvive(world, pos)) {
            world.func_175684_a(pos, (Block)this, 1);
        }
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack stack) {
        super.func_180657_a(world, player, pos, state, te, stack);
        BlockEnokiMushroomCap.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack(Item.func_150898_a((Block)this)));
    }

    public Item func_180660_a(IBlockState state, Random random, int fortune) {
        return Items.field_190931_a;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)AGE);
    }

    public boolean canSurvive(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos.func_177984_a());
        if (state.func_177230_c() != NetherExBlocks.ENOKI_MUSHROOM_STEM && state.func_177230_c() != NetherExBlocks.LIVELY_NETHERRACK) {
            if (state.func_185904_a() == Material.field_151579_a) {
                int blocks = 0;
                for (EnumFacing facing : EnumFacing.Plane.HORIZONTAL) {
                    IBlockState stateSide = world.func_180495_p(pos.func_177972_a(facing));
                    Block blockSide = stateSide.func_177230_c();
                    if (blockSide == NetherExBlocks.ENOKI_MUSHROOM_STEM) {
                        ++blocks;
                        continue;
                    }
                    if (stateSide.func_185904_a() == Material.field_151579_a) continue;
                    return false;
                }
                return blocks == 1;
            }
            return false;
        }
        return true;
    }

    private static boolean areAllNeighborsEmpty(World world, BlockPos pos, EnumFacing facing) {
        for (EnumFacing enumFacing : EnumFacing.Plane.HORIZONTAL) {
            if (enumFacing == facing || world.func_175623_d(pos.func_177972_a(enumFacing))) continue;
            return false;
        }
        return true;
    }

    public static void generatePlant(World world, BlockPos pos, Random random, int x) {
        BlockPos newPos = !world.func_175623_d(pos) ? pos.func_177977_b() : pos;
        world.func_180501_a(newPos, NetherExBlocks.ENOKI_MUSHROOM_STEM.func_176223_P(), 2);
        BlockEnokiMushroomCap.growTreeRecursive(world, newPos, random, newPos, x, 0);
    }

    private static void growTreeRecursive(World world, BlockPos pos, Random random, BlockPos pos1, int x, int z) {
        int height = random.nextInt(4) + 1;
        if (z == 0) {
            ++height;
        }
        for (int j = 0; j < height; ++j) {
            BlockPos blockPos = pos.func_177979_c(j + 1);
            if (!BlockEnokiMushroomCap.areAllNeighborsEmpty(world, blockPos, null)) {
                return;
            }
            world.func_180501_a(blockPos, NetherExBlocks.ENOKI_MUSHROOM_STEM.func_176223_P(), 2);
        }
        boolean grew = false;
        if (z < 4) {
            int growthChances = random.nextInt(4);
            if (z == 0) {
                ++growthChances;
            }
            for (int i = 0; i < growthChances; ++i) {
                EnumFacing facing = EnumFacing.Plane.HORIZONTAL.func_179518_a(random);
                BlockPos blockPos = pos.func_177979_c(height).func_177972_a(facing);
                if (Math.abs(blockPos.func_177958_n() - pos1.func_177958_n()) >= x || Math.abs(blockPos.func_177952_p() - pos1.func_177952_p()) >= x || !world.func_175623_d(blockPos) || !world.func_175623_d(blockPos.func_177984_a()) || !BlockEnokiMushroomCap.areAllNeighborsEmpty(world, blockPos, facing.func_176734_d())) continue;
                grew = true;
                world.func_180501_a(blockPos, NetherExBlocks.ENOKI_MUSHROOM_STEM.func_176223_P(), 2);
                BlockEnokiMushroomCap.growTreeRecursive(world, blockPos, random, pos1, x, z + 1);
            }
        }
        if (!grew) {
            world.func_180501_a(pos.func_177979_c(height), NetherExBlocks.ENOKI_MUSHROOM_CAP.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(5)), 2);
        }
    }

    private void placeGrownCap(World world, BlockPos pos, int age) {
        world.func_180501_a(pos, this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(age)), 2);
        world.func_175718_b(1033, pos, 0);
    }

    private void placeDeadCap(World world, BlockPos pos) {
        world.func_180501_a(pos, this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(5)), 2);
        world.func_175718_b(1034, pos, 0);
    }
}

