/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.netherex.block;

import java.util.List;
import logictechcorp.libraryex.block.BlockMod;
import logictechcorp.libraryex.block.property.BlockProperties;
import logictechcorp.netherex.NetherEx;
import logictechcorp.netherex.init.NetherExBlocks;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPane;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockSoulGlassPane
extends BlockMod {
    public static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    public static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    public static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    public static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");
    private static final AxisAlignedBB[] AABB_BY_INDEX = new AxisAlignedBB[]{new AxisAlignedBB(0.4375, 0.0, 0.4375, 0.5625, 1.0, 0.5625), new AxisAlignedBB(0.4375, 0.0, 0.4375, 0.5625, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.4375, 0.5625, 1.0, 0.5625), new AxisAlignedBB(0.0, 0.0, 0.4375, 0.5625, 1.0, 1.0), new AxisAlignedBB(0.4375, 0.0, 0.0, 0.5625, 1.0, 0.5625), new AxisAlignedBB(0.4375, 0.0, 0.0, 0.5625, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 0.5625, 1.0, 0.5625), new AxisAlignedBB(0.0, 0.0, 0.0, 0.5625, 1.0, 1.0), new AxisAlignedBB(0.4375, 0.0, 0.4375, 1.0, 1.0, 0.5625), new AxisAlignedBB(0.4375, 0.0, 0.4375, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.4375, 1.0, 1.0, 0.5625), new AxisAlignedBB(0.0, 0.0, 0.4375, 1.0, 1.0, 1.0), new AxisAlignedBB(0.4375, 0.0, 0.0, 1.0, 1.0, 0.5625), new AxisAlignedBB(0.4375, 0.0, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.5625), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0)};

    public BlockSoulGlassPane() {
        super(NetherEx.getResource("soul_glass_pane"), new BlockProperties(Material.field_151592_s, MapColor.field_151660_b).sound(SoundType.field_185853_f).hardness(0.3f));
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing facing) {
        return world.func_180495_p(pos.func_177972_a(facing)).func_177230_c() != this && super.func_176225_a(state, world, pos, facing);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entity, boolean bool) {
        state = this.func_176221_a(state, (IBlockAccess)worldIn, pos);
        BlockSoulGlassPane.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_BY_INDEX[0]);
        if (((Boolean)state.func_177229_b((IProperty)NORTH)).booleanValue()) {
            BlockSoulGlassPane.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_BY_INDEX[BlockSoulGlassPane.getBoundingBoxIndex(EnumFacing.NORTH)]);
        }
        if (((Boolean)state.func_177229_b((IProperty)SOUTH)).booleanValue()) {
            BlockSoulGlassPane.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_BY_INDEX[BlockSoulGlassPane.getBoundingBoxIndex(EnumFacing.SOUTH)]);
        }
        if (((Boolean)state.func_177229_b((IProperty)EAST)).booleanValue()) {
            BlockSoulGlassPane.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_BY_INDEX[BlockSoulGlassPane.getBoundingBoxIndex(EnumFacing.EAST)]);
        }
        if (((Boolean)state.func_177229_b((IProperty)WEST)).booleanValue()) {
            BlockSoulGlassPane.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_BY_INDEX[BlockSoulGlassPane.getBoundingBoxIndex(EnumFacing.WEST)]);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        state = this.func_176221_a(state, source, pos);
        return AABB_BY_INDEX[BlockSoulGlassPane.getBoundingBoxIndex(state)];
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state.func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(this.canPaneConnectTo(worldIn, pos, EnumFacing.NORTH))).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(this.canPaneConnectTo(worldIn, pos, EnumFacing.SOUTH))).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(this.canPaneConnectTo(worldIn, pos, EnumFacing.WEST))).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(this.canPaneConnectTo(worldIn, pos, EnumFacing.EAST)));
    }

    protected boolean func_149700_E() {
        return true;
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{NORTH, EAST, WEST, SOUTH});
    }

    public boolean canBeConnectedTo(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        Block connector = world.func_180495_p(pos.func_177972_a(facing)).func_177230_c();
        return connector instanceof BlockPane;
    }

    private boolean canPaneConnectTo(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        IBlockState state = world.func_180495_p(pos.func_177972_a(facing));
        return state.func_177230_c().canBeConnectedTo(world, pos.func_177972_a(facing), facing.func_176734_d()) || this.canPaneConnectToBlock(state.func_177230_c()) || state.isSideSolid(world, pos.func_177972_a(facing), facing.func_176734_d());
    }

    private boolean canPaneConnectToBlock(Block block) {
        return block.func_176223_P().func_185917_h() || block == this || block == NetherExBlocks.SOUL_GLASS || block == Blocks.field_150359_w || block == Blocks.field_150399_cn || block == Blocks.field_150397_co || block instanceof BlockPane;
    }

    private static int getBoundingBoxIndex(EnumFacing facing) {
        return 1 << facing.func_176736_b();
    }

    private static int getBoundingBoxIndex(IBlockState state) {
        int i = 0;
        if (((Boolean)state.func_177229_b((IProperty)NORTH)).booleanValue()) {
            i |= BlockSoulGlassPane.getBoundingBoxIndex(EnumFacing.NORTH);
        }
        if (((Boolean)state.func_177229_b((IProperty)EAST)).booleanValue()) {
            i |= BlockSoulGlassPane.getBoundingBoxIndex(EnumFacing.EAST);
        }
        if (((Boolean)state.func_177229_b((IProperty)SOUTH)).booleanValue()) {
            i |= BlockSoulGlassPane.getBoundingBoxIndex(EnumFacing.SOUTH);
        }
        if (((Boolean)state.func_177229_b((IProperty)WEST)).booleanValue()) {
            i |= BlockSoulGlassPane.getBoundingBoxIndex(EnumFacing.WEST);
        }
        return i;
    }
}

