/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.netherex.handler;

import java.util.ListIterator;
import logictechcorp.libraryex.utility.NBTHelper;
import logictechcorp.netherex.init.NetherExItems;
import logictechcorp.netherex.init.NetherExMobEffects;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber(modid="netherex")
public class PlayerHandler {
    @SubscribeEvent
    public static void onItemCrafted(PlayerEvent.ItemCraftedEvent event) {
        EntityPlayer player = event.player;
        ItemStack stack = event.crafting;
        if (stack.func_77973_b() == NetherExItems.DULL_MIRROR && stack.func_77952_i() < stack.func_77958_k()) {
            NBTTagCompound compound = NBTHelper.ensureTagExists((ItemStack)stack);
            compound.func_74757_a("RemovedSpawn", false);
            if (compound.func_74764_b("SpawnDimension") && compound.func_74764_b("SpawnPoint")) {
                int spawnDimension = compound.func_74762_e("SpawnDimension");
                BlockPos spawnPoint = NBTUtil.func_186861_c((NBTTagCompound)compound.func_74775_l("SpawnPoint"));
                player.setSpawnDimension(Integer.valueOf(spawnDimension));
                player.setSpawnChunk(spawnPoint, true, spawnDimension);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        TickEvent.Phase phase = event.phase;
        World world = event.player.func_130014_f_();
        EntityPlayer player = event.player;
        if (phase == TickEvent.Phase.END && !world.field_72995_K) {
            InventoryPlayer inventory = player.field_71071_by;
            int mirrorCount = 0;
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                ItemStack stack = inventory.func_70301_a(i);
                if (stack.func_77973_b() != NetherExItems.DULL_MIRROR || ++mirrorCount <= 1) continue;
                EntityItem item = new EntityItem(world, player.field_70165_t, player.field_70163_u + 0.5, player.field_70161_v, stack);
                item.func_174867_a(50);
                world.func_72838_d((Entity)item);
                inventory.func_70299_a(i, ItemStack.field_190927_a);
                break;
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerJump(LivingEvent.LivingJumpEvent event) {
        EntityPlayer player;
        EntityLivingBase entity = event.getEntityLiving();
        if (entity instanceof EntityPlayer && (player = (EntityPlayer)entity).func_70644_a(NetherExMobEffects.FROZEN)) {
            player.field_70181_x = 0.0;
        }
    }

    @SubscribeEvent
    public static void onPlayerDrop(PlayerDropsEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        ListIterator iter = event.getDrops().listIterator();
        while (iter.hasNext()) {
            EntityItem entityItem = (EntityItem)iter.next();
            ItemStack stack = entityItem.func_92059_d();
            if (stack.func_77973_b() != NetherExItems.DULL_MIRROR) continue;
            player.func_184201_a(EntityEquipmentSlot.MAINHAND, stack);
            iter.remove();
            break;
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        EntityPlayer oldPlayer = event.getOriginal();
        EntityPlayer newPlayer = event.getEntityPlayer();
        InventoryPlayer oldInventory = oldPlayer.field_71071_by;
        InventoryPlayer newInventory = newPlayer.field_71071_by;
        if (event.isWasDeath()) {
            NBTTagCompound compound;
            ItemStack mirrorStack = ItemStack.field_190927_a;
            for (int i = 0; i < oldInventory.func_70302_i_(); ++i) {
                ItemStack stack = oldInventory.func_70301_a(i);
                if (stack.func_77973_b() != NetherExItems.DULL_MIRROR) continue;
                NBTHelper.ensureTagExists((ItemStack)stack);
                if (stack.func_77978_p().func_74764_b("SpawnPoint") && stack.func_77952_i() < stack.func_77958_k() - 1) {
                    stack.func_77972_a(1, (EntityLivingBase)newPlayer);
                }
                newInventory.func_70299_a(i, stack);
                mirrorStack = stack;
                break;
            }
            if (!mirrorStack.func_190926_b() && mirrorStack.func_77952_i() < mirrorStack.func_77958_k() - 1 && (compound = NBTHelper.ensureTagExists((ItemStack)mirrorStack)).func_74764_b("SpawnDimension") && compound.func_74764_b("SpawnPoint")) {
                int spawnDimension = compound.func_74762_e("SpawnDimension");
                BlockPos spawnPoint = NBTUtil.func_186861_c((NBTTagCompound)compound.func_74775_l("SpawnPoint"));
                newPlayer.setSpawnDimension(Integer.valueOf(spawnDimension));
                newPlayer.setSpawnChunk(spawnPoint, true, spawnDimension);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        World world = event.player.func_130014_f_();
        EntityPlayer player = event.player;
        InventoryPlayer playerInventory = player.field_71071_by;
        if (!world.field_72995_K) {
            MinecraftServer server;
            int spawnDimension;
            NBTTagCompound compound;
            ItemStack mirrorStack = ItemStack.field_190927_a;
            for (int i = 0; i < playerInventory.func_70302_i_(); ++i) {
                ItemStack stack = playerInventory.func_70301_a(i);
                if (stack.func_77973_b() != NetherExItems.DULL_MIRROR) continue;
                mirrorStack = stack;
                break;
            }
            if (!mirrorStack.func_190926_b() && mirrorStack.func_77952_i() < mirrorStack.func_77958_k() - 1 && (compound = NBTHelper.ensureTagExists((ItemStack)mirrorStack)).func_74764_b("SpawnDimension") && compound.func_74764_b("SpawnPoint") && player.field_71093_bK != (spawnDimension = compound.func_74762_e("SpawnDimension")) && (server = world.func_73046_m()) != null) {
                BlockPos spawnPoint = NBTUtil.func_186861_c((NBTTagCompound)compound.func_74775_l("SpawnPoint"));
                server.func_184103_al().transferPlayerToDimension((EntityPlayerMP)player, spawnDimension, (toWorld, entity, yaw) -> entity.func_70107_b((double)spawnPoint.func_177958_n() + 0.5, (double)spawnPoint.func_177956_o(), (double)spawnPoint.func_177952_p() + 0.5));
            }
        }
    }
}

