/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.netherex.village;

import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.file.FileConfig;
import com.electronwill.nightconfig.json.JsonFormat;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import logictechcorp.libraryex.LibraryEx;
import logictechcorp.libraryex.trade.Trade;
import logictechcorp.libraryex.utility.FileHelper;
import logictechcorp.libraryex.utility.WorldHelper;
import logictechcorp.netherex.NetherEx;
import logictechcorp.netherex.NetherExConfig;
import logictechcorp.netherex.init.NetherExRegistries;
import logictechcorp.netherex.village.PigtificateProfession;
import logictechcorp.netherex.village.PigtificateVillageData;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.apache.commons.io.FileUtils;

public class PigtificateVillageManager {
    private final Map<PigtificateProfession.Career, List<Trade>> defaultTrades = new HashMap<PigtificateProfession.Career, List<Trade>>();
    private final Map<PigtificateProfession.Career, List<Trade>> currentTrades = new HashMap<PigtificateProfession.Career, List<Trade>>();
    private final Map<Integer, PigtificateVillageData> pigtificateVillageData = new HashMap<Integer, PigtificateVillageData>();

    public void setup() {
        NetherExRegistries.PIGTIFICATE_PROFESSIONS.getValuesCollection().forEach(profession -> profession.getCareers().forEach(career -> {
            List trades = career.getTrades();
            this.defaultTrades.put((PigtificateProfession.Career)((Object)((Object)career)), trades);
            trades.forEach(arg_0 -> ((PigtificateProfession.Career)((Object)((Object)career))).removeTrade(arg_0));
        }));
        if (NetherExConfig.entity.pigtificate.useGlobalTradeConfigs) {
            Path globalTradeConfigDirectoryPath = LibraryEx.CONFIG_DIRECTORY.toPath().resolve("netherex").resolve("pigtificate_trades");
            this.createPigtificateTradeConfigs(globalTradeConfigDirectoryPath);
        }
    }

    public void onWorldLoad(WorldEvent.Load event) {
        World world = event.getWorld();
        if (!world.field_72995_K) {
            if (world.field_73011_w.getDimension() == DimensionType.OVERWORLD.func_186068_a()) {
                if (NetherExConfig.entity.pigtificate.useGlobalTradeConfigs) {
                    Path globalTradeConfigDirectoryPath = LibraryEx.CONFIG_DIRECTORY.toPath().resolve("netherex").resolve("pigtificate_trades");
                    this.readPigtificateTradeConfigs(globalTradeConfigDirectoryPath);
                }
                if (NetherExConfig.entity.pigtificate.usePerWorldTradeConfigs) {
                    Path perWorldTradeConfigDirectoryPath = Paths.get(WorldHelper.getSaveDirectory((World)event.getWorld()), "config", "netherex", "pigtificate_trades");
                    this.createPigtificateTradeConfigs(perWorldTradeConfigDirectoryPath);
                    this.readPigtificateTradeConfigs(perWorldTradeConfigDirectoryPath);
                }
                for (Map.Entry<PigtificateProfession.Career, List<Trade>> entry : this.currentTrades.entrySet()) {
                    PigtificateProfession.Career career = entry.getKey();
                    List<Trade> trades = entry.getValue();
                    trades.forEach(arg_0 -> ((PigtificateProfession.Career)career).addTrade(arg_0));
                }
            }
            this.loadVillageData(world);
        }
    }

    public void onWorldTick(TickEvent.WorldTickEvent event) {
        PigtificateVillageData data;
        World world = event.world;
        if (event.phase == TickEvent.Phase.END && !world.field_72995_K && (data = this.getVillageData(world, false)) != null) {
            data.tick(world);
        }
    }

    public void onWorldUnload(WorldEvent.Unload event) {
        World world = event.getWorld();
        if (!world.field_72995_K) {
            int dimension = world.field_73011_w.getDimension();
            this.unloadVillageData(dimension);
            if (dimension == DimensionType.OVERWORLD.func_186068_a()) {
                NetherExRegistries.PIGTIFICATE_PROFESSIONS.getValuesCollection().forEach(profession -> profession.getCareers().forEach(career -> {
                    List trades = career.getTrades();
                    trades.forEach(arg_0 -> ((PigtificateProfession.Career)((Object)((Object)career))).removeTrade(arg_0));
                }));
                this.pigtificateVillageData.clear();
            }
        }
    }

    public void loadVillageData(World world) {
        if (!this.hasData(world)) {
            this.getVillageData(world, false);
        }
    }

    public void unloadVillageData(int dimensionId) {
        this.pigtificateVillageData.remove(dimensionId);
    }

    public void readPigtificateTradeConfigs(Path tradeConfigDirectoryPath) {
        if (Files.exists(tradeConfigDirectoryPath, new LinkOption[0])) {
            NetherEx.LOGGER.info("Reading Pigtificate trade configs.");
            try {
                Iterator pathIter = Files.walk(tradeConfigDirectoryPath, new FileVisitOption[0]).iterator();
                while (pathIter.hasNext()) {
                    Path configPath = (Path)pathIter.next();
                    File configFile = configPath.toFile();
                    if (FileHelper.getFileExtension((File)configFile).equals("json")) {
                        if (Files.isReadable(configPath)) {
                            String fileText = FileUtils.readFileToString((File)configFile, (Charset)Charset.defaultCharset()).trim();
                            if (fileText.startsWith("{") && fileText.endsWith("}")) {
                                List tradeConfigs;
                                PigtificateProfession.Career career;
                                FileConfig config = FileConfig.builder((File)configFile, (ConfigFormat)JsonFormat.fancyInstance()).preserveInsertionOrder().build();
                                config.load();
                                PigtificateProfession profession = (PigtificateProfession)NetherExRegistries.PIGTIFICATE_PROFESSIONS.getValue(new ResourceLocation((String)config.get("profession")));
                                if (profession != null && (career = (PigtificateProfession.Career)profession.getCareer(new ResourceLocation((String)config.get("career")))) != null && (tradeConfigs = (List)config.getOrElse("trades", new ArrayList())).size() > 0) {
                                    for (Config tradeConfig : tradeConfigs) {
                                        if (!this.currentTrades.containsKey((Object)career)) {
                                            this.currentTrades.put(career, new ArrayList());
                                        }
                                        this.currentTrades.get((Object)career).add(new Trade(tradeConfig));
                                    }
                                }
                                config.save();
                                config.close();
                                continue;
                            }
                            NetherEx.LOGGER.warn("Skipping Pigtificate trade config at {}. Its contents are invalid.", (Object)configPath);
                            continue;
                        }
                        NetherEx.LOGGER.warn("Skipping Pigtificate trade config at {}. It is unreadable.", (Object)configPath);
                        continue;
                    }
                    if (configFile.isDirectory()) continue;
                    NetherEx.LOGGER.warn("Skipping Pigtificate trade config at {}. It is not a json file.", (Object)configPath);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void createPigtificateTradeConfigs(Path tradeConfigDirectoryPath) {
        if (Files.notExists(tradeConfigDirectoryPath, new LinkOption[0])) {
            NetherEx.LOGGER.info("Creating Pigtificate trade configs.");
            try {
                for (Map.Entry<PigtificateProfession.Career, List<Trade>> entry : this.defaultTrades.entrySet()) {
                    PigtificateProfession.Career career = entry.getKey();
                    List<Trade> trades = entry.getValue();
                    String careerName = career.getName().toString();
                    File configFile = new File(tradeConfigDirectoryPath.toFile(), careerName.replace(":", "/") + ".json");
                    Files.createDirectories(configFile.getParentFile().toPath(), new FileAttribute[0]);
                    FileConfig tradeConfig = FileConfig.builder((File)configFile, (ConfigFormat)JsonFormat.fancyInstance()).preserveInsertionOrder().build();
                    tradeConfig.set("profession", (Object)((PigtificateProfession)career.getProfession()).getName().toString());
                    tradeConfig.set("career", (Object)careerName);
                    tradeConfig.add("trades", trades.stream().map(Trade::getAsConfig).collect(Collectors.toList()));
                    tradeConfig.save();
                    tradeConfig.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean hasData(World world) {
        return this.pigtificateVillageData.containsKey(world.field_73011_w.getDimension());
    }

    public Map<PigtificateProfession.Career, List<Trade>> getDefaultTrades() {
        return Collections.unmodifiableMap(this.defaultTrades);
    }

    public Map<PigtificateProfession.Career, List<Trade>> getCurrentTrades() {
        return Collections.unmodifiableMap(this.currentTrades);
    }

    public PigtificateVillageData getVillageData(World world, boolean createData) {
        PigtificateVillageData data;
        int dimensionId = world.field_73011_w.getDimension();
        if (this.hasData(world)) {
            data = this.pigtificateVillageData.get(dimensionId);
        } else {
            String worldFile = PigtificateVillageData.getDataId(world);
            data = (PigtificateVillageData)world.getPerWorldStorage().func_75742_a(PigtificateVillageData.class, worldFile);
            if (data == null && createData) {
                data = new PigtificateVillageData(world);
                world.getPerWorldStorage().func_75745_a(worldFile, (WorldSavedData)data);
            }
        }
        if (data != null) {
            this.pigtificateVillageData.put(dimensionId, data);
        }
        return data;
    }
}

