/*
 * Decompiled with CFR 0.152.
 */
package teamrtg.passableleaves.asm;

import com.google.common.collect.Lists;
import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.commons.lang3.ArrayUtils;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import teamrtg.passableleaves.asm.PassableLeavesCore;

public class PassableLeavesTransformer
implements IClassTransformer {
    public PassableLeavesTransformer() {
        PassableLeavesCore.LOGGER.debug("PassableLeavesTransformer Initialized");
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (!transformedName.equals("net.minecraft.block.BlockLeaves")) {
            return basicClass;
        }
        ClassNode node = new ClassNode();
        ClassReader reader = new ClassReader(basicClass);
        reader.accept((ClassVisitor)node, 0);
        for (MethodNode mn : node.methods) {
            if (!Transforms.Methods.contains(mn.name)) continue;
            PassableLeavesCore.LOGGER.error("net.minecraft.block.BlockLeaves was modified by another Class transformer. Not doing changes.");
            return basicClass;
        }
        PassableLeavesCore.LOGGER.debug("Patching net.minecraft.block.BlockLeaves with an override for net.minecraft.block.Block#getCollisionBox");
        LabelNode startLabel = new LabelNode();
        LabelNode endLabel = new LabelNode();
        MethodNode getCollisionBox = new MethodNode(1, Transforms.Methods.getCollisionBoundingBox.getName(), Transforms.Methods.getCollisionBoundingBox.getDesc(), null, new String[0]);
        getCollisionBox.instructions = new InsnList();
        getCollisionBox.instructions.add((AbstractInsnNode)startLabel);
        getCollisionBox.instructions.add((AbstractInsnNode)new LineNumberNode(150, startLabel));
        AnnotationNode nullable = new AnnotationNode("Ljavax/annotation/Nullable;");
        nullable.values = Lists.newArrayList();
        getCollisionBox.visibleAnnotations = Lists.newArrayList((Object[])new AnnotationNode[]{nullable});
        LocalVariableNode lvnThis = new LocalVariableNode("this", "Lnet/minecraft/block/BlockLeaves;", null, startLabel, endLabel, 0);
        LocalVariableNode lvnPState = new LocalVariableNode("inState", "Lnet/minecraft/block/state/IBlockState;", null, startLabel, endLabel, 1);
        LocalVariableNode lvnPWorld = new LocalVariableNode("inWorld", "Lnet/minecraft/world/IBlockAccess;", null, startLabel, endLabel, 2);
        LocalVariableNode lvnPPos = new LocalVariableNode("inPos", "Lnet/minecraft/util/math/BlockPos;", null, startLabel, endLabel, 3);
        getCollisionBox.localVariables = Lists.newArrayList((Object[])new LocalVariableNode[]{lvnThis, lvnPState, lvnPWorld, lvnPPos});
        getCollisionBox.instructions.add((AbstractInsnNode)new FieldInsnNode(178, "net/minecraft/block/BlockLeaves", Transforms.Fields.NULL_AABB.getName(), Transforms.Fields.NULL_AABB.getDesc()));
        getCollisionBox.instructions.add((AbstractInsnNode)new InsnNode(176));
        getCollisionBox.instructions.add((AbstractInsnNode)endLabel);
        node.methods.add(getCollisionBox);
        PassableLeavesCore.LOGGER.debug("Patching net.minecraft.block.BlockLeaves with an override for net.minecraft.block.Block#isPassable");
        startLabel = new LabelNode();
        endLabel = new LabelNode();
        MethodNode isPassable = new MethodNode(1, Transforms.Methods.isPassable.getName(), Transforms.Methods.isPassable.getDesc(), null, new String[0]);
        isPassable.visibleAnnotations = Lists.newArrayList();
        isPassable.instructions = new InsnList();
        isPassable.instructions.add((AbstractInsnNode)startLabel);
        isPassable.instructions.add((AbstractInsnNode)new LineNumberNode(160, startLabel));
        lvnThis = new LocalVariableNode("this", "Lnet/minecraft/block/BlockLeaves;", null, startLabel, endLabel, 0);
        lvnPState = new LocalVariableNode("inWorld", "Lnet/minecraft/world/IBlockAccess;", null, startLabel, endLabel, 1);
        lvnPPos = new LocalVariableNode("inPos", "Lnet/minecraft/util/math/BlockPos;", null, startLabel, endLabel, 2);
        isPassable.localVariables = Lists.newArrayList((Object[])new LocalVariableNode[]{lvnThis, lvnPState, lvnPPos});
        isPassable.instructions.add((AbstractInsnNode)new InsnNode(4));
        isPassable.instructions.add((AbstractInsnNode)new InsnNode(172));
        isPassable.instructions.add((AbstractInsnNode)endLabel);
        node.methods.add(isPassable);
        PassableLeavesCore.LOGGER.debug("Patching net.minecraft.block.BlockLeaves with an override for net.minecraft.block.Block#onEntityCollidedWithBlock");
        startLabel = new LabelNode();
        endLabel = new LabelNode();
        MethodNode onEntityCollidedWithBlock = new MethodNode(1, Transforms.Methods.onEntityCollidedWithBlock.getName(), Transforms.Methods.onEntityCollidedWithBlock.getDesc(), null, new String[0]);
        onEntityCollidedWithBlock.visibleAnnotations = Lists.newArrayList();
        onEntityCollidedWithBlock.instructions = new InsnList();
        onEntityCollidedWithBlock.instructions.add((AbstractInsnNode)startLabel);
        onEntityCollidedWithBlock.instructions.add((AbstractInsnNode)new LineNumberNode(170, startLabel));
        lvnThis = new LocalVariableNode("this", "Lnet/minecraft/block/BlockLeaves;", null, startLabel, endLabel, 0);
        lvnPWorld = new LocalVariableNode("inWorld", "Lnet/minecraft/world/World;", null, startLabel, endLabel, 1);
        lvnPPos = new LocalVariableNode("inPos", "Lnet/minecraft/util/math/BlockPos;", null, startLabel, endLabel, 2);
        lvnPState = new LocalVariableNode("inState", "Lnet/minecraft/block/state/IBlockState;", null, startLabel, endLabel, 3);
        LocalVariableNode lvnPEntity = new LocalVariableNode("inEntity", "Lnet/minecraft/entity/Entity;", null, startLabel, endLabel, 4);
        onEntityCollidedWithBlock.localVariables = Lists.newArrayList((Object[])new LocalVariableNode[]{lvnThis, lvnPWorld, lvnPPos, lvnPState, lvnPEntity});
        onEntityCollidedWithBlock.instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
        onEntityCollidedWithBlock.instructions.add((AbstractInsnNode)new VarInsnNode(25, 2));
        onEntityCollidedWithBlock.instructions.add((AbstractInsnNode)new VarInsnNode(25, 3));
        onEntityCollidedWithBlock.instructions.add((AbstractInsnNode)new VarInsnNode(25, 4));
        onEntityCollidedWithBlock.instructions.add((AbstractInsnNode)new MethodInsnNode(184, "teamrtg/passableleaves/PassableLeaves", "onEntityCollidedWithLeaves", Transforms.Methods.onEntityCollidedWithBlock.getDesc(), false));
        onEntityCollidedWithBlock.instructions.add((AbstractInsnNode)new InsnNode(177));
        onEntityCollidedWithBlock.instructions.add((AbstractInsnNode)endLabel);
        node.methods.add(onEntityCollidedWithBlock);
        ClassWriter writer = new ClassWriter(3);
        node.accept((ClassVisitor)writer);
        basicClass = writer.toByteArray();
        return basicClass;
    }

    static final class Transforms {
        private static final String[] names = new String[0];

        private Transforms() {
        }

        static enum Fields {
            NULL_AABB("field_185506_k", "Lnet/minecraft/util/math/AxisAlignedBB;");

            private final String obfName;
            private final String desc;

            private Fields(String obfName, String desc) {
                this.obfName = obfName;
                this.desc = desc;
            }

            String getName() {
                return PassableLeavesCore.isDeobf() ? this.name() : this.obfName;
            }

            String getDesc() {
                return this.desc;
            }
        }

        static enum Methods {
            getCollisionBoundingBox("func_180646_a", "(Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/util/math/AxisAlignedBB;"),
            isPassable("func_176205_b", "(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;)Z"),
            onEntityCollidedWithBlock("func_180634_a", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/entity/Entity;)V");

            private final String obfName;
            private final String desc;

            private Methods(String obfName, String desc) {
                this.obfName = obfName;
                this.desc = desc;
                ArrayUtils.add((Object[])names, (Object)this.name().toLowerCase());
            }

            String getName() {
                return PassableLeavesCore.isDeobf() ? this.name() : this.obfName;
            }

            String getDesc() {
                return this.desc;
            }

            static boolean contains(String value) {
                return ArrayUtils.contains((Object[])names, (Object)value.toLowerCase());
            }
        }
    }
}

