/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.aquaacrobatics.client.handler;

import com.fuzs.aquaacrobatics.biome.BiomeWaterFogColors;
import com.fuzs.aquaacrobatics.config.ConfigHandler;
import com.fuzs.aquaacrobatics.entity.player.IPlayerResizeable;
import com.fuzs.aquaacrobatics.proxy.CommonProxy;
import com.fuzs.aquaacrobatics.util.math.MathHelperNew;
import java.util.Arrays;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class FogHandler {
    private int targetFogColor = -1;
    private int prevFogColor = -1;
    private long fogAdjustTime = -1L;
    private static HashSet<String> worldProviderClassNames = null;

    public static void recomputeBlacklist() {
        worldProviderClassNames = new HashSet();
        worldProviderClassNames.addAll(Arrays.asList(ConfigHandler.MiscellaneousConfig.providerFogBlacklist));
    }

    private boolean shouldSkipFogOverride(World world) {
        if (!ConfigHandler.BlocksConfig.newWaterFog) {
            return true;
        }
        return worldProviderClassNames.contains(world.field_73011_w.getClass().getName());
    }

    @SubscribeEvent
    public void registerBlockColors(ColorHandlerEvent.Block event) {
        if (ConfigHandler.MiscellaneousConfig.bubbleColumns) {
            event.getBlockColors().func_186722_a(new IBlockColor(){

                public int func_186720_a(IBlockState state, @Nullable IBlockAccess worldIn, @Nullable BlockPos pos, int tintIndex) {
                    return worldIn != null && pos != null ? BiomeColorHelper.func_180288_c((IBlockAccess)worldIn, (BlockPos)pos) : -1;
                }
            }, new Block[]{CommonProxy.BUBBLE_COLUMN});
        }
    }

    @SubscribeEvent
    public void onRenderFogDensity(EntityViewRenderEvent.FogDensity event) {
        Entity eventEntity = event.getEntity();
        if (eventEntity instanceof EntityLivingBase && ((EntityLivingBase)eventEntity).func_70644_a(MobEffects.field_76440_q)) {
            return;
        }
        if (event.getState().func_185904_a() == Material.field_151586_h && !this.shouldSkipFogOverride(eventEntity.func_130014_f_())) {
            GlStateManager.func_187430_a((GlStateManager.FogMode)GlStateManager.FogMode.EXP2);
            float density = 0.05f;
            if (eventEntity instanceof EntityPlayer) {
                EntityPlayer playerEntity = (EntityPlayer)eventEntity;
                float waterVision = ((IPlayerResizeable)playerEntity).getWaterVision();
                density -= waterVision * waterVision * 0.03f;
                Biome biome = playerEntity.field_70170_p.func_180494_b(playerEntity.func_180425_c());
                if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP)) {
                    density += 0.005f;
                }
            }
            event.setDensity(density);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onRenderFogColor(EntityViewRenderEvent.FogColors event) {
        if (!ConfigHandler.BlocksConfig.newWaterColors) {
            return;
        }
        Block blockInside = event.getState().func_177230_c();
        if (event.getState().func_185904_a() == Material.field_151586_h && event.getEntity() instanceof EntityPlayer && !this.shouldSkipFogOverride(event.getEntity().func_130014_f_())) {
            EntityPlayer playerEntity = (EntityPlayer)event.getEntity();
            long i = System.nanoTime() / 1000000L;
            int j = BiomeWaterFogColors.getWaterFogColorForBiome(playerEntity.field_70170_p.func_180494_b(playerEntity.func_180425_c()));
            if (this.fogAdjustTime < 0L) {
                this.targetFogColor = j;
                this.prevFogColor = j;
                this.fogAdjustTime = i;
            }
            int k = this.targetFogColor >> 16 & 0xFF;
            int l = this.targetFogColor >> 8 & 0xFF;
            int i1 = this.targetFogColor & 0xFF;
            int j1 = this.prevFogColor >> 16 & 0xFF;
            int k1 = this.prevFogColor >> 8 & 0xFF;
            int l1 = this.prevFogColor & 0xFF;
            float f = MathHelper.func_76131_a((float)((float)(i - this.fogAdjustTime) / 5000.0f), (float)0.0f, (float)1.0f);
            float f1 = MathHelperNew.lerp(f, j1, k);
            float f2 = MathHelperNew.lerp(f, k1, l);
            float f3 = MathHelperNew.lerp(f, l1, i1);
            float fogRed = f1 / 255.0f;
            float fogGreen = f2 / 255.0f;
            float fogBlue = f3 / 255.0f;
            if (this.targetFogColor != j) {
                this.targetFogColor = j;
                this.prevFogColor = MathHelper.func_76141_d((float)f1) << 16 | MathHelper.func_76141_d((float)f2) << 8 | MathHelper.func_76141_d((float)f3);
                this.fogAdjustTime = i;
            }
            float f6 = ((IPlayerResizeable)playerEntity).getWaterVision();
            float f9 = Math.min(1.0f / fogRed, Math.min(1.0f / fogGreen, 1.0f / fogBlue));
            fogRed = fogRed * (1.0f - f6) + fogRed * f9 * f6;
            fogGreen = fogGreen * (1.0f - f6) + fogGreen * f9 * f6;
            fogBlue = fogBlue * (1.0f - f6) + fogBlue * f9 * f6;
            double blindnessFactor = 1.0;
            if (playerEntity.func_70644_a(MobEffects.field_76440_q)) {
                int potionDuration = playerEntity.func_70660_b(MobEffects.field_76440_q).func_76459_b();
                blindnessFactor = potionDuration < 20 ? (blindnessFactor *= (double)(1.0f - (float)i / 20.0f)) : 0.0;
            }
            if (blindnessFactor < 1.0) {
                if (blindnessFactor < 0.0) {
                    blindnessFactor = 0.0;
                }
                blindnessFactor *= blindnessFactor;
                fogRed = (float)((double)fogRed * blindnessFactor);
                fogGreen = (float)((double)fogGreen * blindnessFactor);
                fogBlue = (float)((double)fogBlue * blindnessFactor);
            }
            event.setRed(fogRed);
            event.setGreen(fogGreen);
            event.setBlue(fogBlue);
        } else if (blockInside == Blocks.field_150353_l || blockInside == Blocks.field_150356_k) {
            event.setRed(0.6f);
            event.setGreen(0.1f);
            event.setBlue(0.0f);
            this.fogAdjustTime = -1L;
        } else {
            this.fogAdjustTime = -1L;
        }
    }
}

