/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.aquaacrobatics.core.mixin.client;

import com.fuzs.aquaacrobatics.integration.IntegrationManager;
import com.fuzs.aquaacrobatics.util.math.MathHelperNew;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.entity.Entity;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EntityRenderer.class})
public abstract class EntityRendererMixin {
    @Shadow
    @Final
    private Minecraft field_78531_r;
    private float eyeHeight;
    private float previousEyeHeight;
    private float entityEyeHeight;
    private float partialTicks;

    @Inject(method={"orientCamera"}, at={@At(value="HEAD")})
    private void orientCamera(float partialTicks, CallbackInfo callbackInfo) {
        this.partialTicks = partialTicks;
    }

    @ModifyVariable(method={"orientCamera"}, at=@At(value="FIELD", target="Lnet/minecraft/entity/Entity;prevPosX:D", ordinal=0), ordinal=1)
    public float getEyeHeight(float eyeHeight) {
        if (IntegrationManager.isRandomPatchesEnabled()) {
            return eyeHeight;
        }
        this.entityEyeHeight = eyeHeight;
        return MathHelperNew.lerp(this.partialTicks, this.previousEyeHeight, this.eyeHeight);
    }

    @Inject(method={"updateRenderer"}, at={@At(value="TAIL")})
    public void updateRenderer(CallbackInfo callbackInfo) {
        this.interpolateHeight();
    }

    private void interpolateHeight() {
        this.previousEyeHeight = this.eyeHeight;
        this.eyeHeight += (this.entityEyeHeight - this.eyeHeight) * 0.5f;
    }

    @Redirect(method={"renderWorldPass"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;isInsideOfMaterial(Lnet/minecraft/block/material/Material;)Z", ordinal=0), require=0, expect=0)
    private boolean ignoreWater(Entity entity, Material material) {
        if (material == Material.field_151586_h) {
            return false;
        }
        return entity.func_70055_a(material);
    }
}

