/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod;

import git.jbredwards.fluidlogged_api.api.capability.IFluidStateCapability;
import git.jbredwards.fluidlogged_api.api.network.FluidloggedAPINetworkHandler;
import git.jbredwards.fluidlogged_api.api.network.message.MessageFluidState;
import git.jbredwards.fluidlogged_api.mod.client.optifine.OptifineCustomWaterColors;
import git.jbredwards.fluidlogged_api.mod.client.optifine.UnsupportedOptifineException;
import git.jbredwards.fluidlogged_api.mod.common.capability.FluidStateCapabilityVanilla;
import git.jbredwards.fluidlogged_api.mod.common.capability.cubicchunks.FluidStateCapabilityIColumn;
import git.jbredwards.fluidlogged_api.mod.common.capability.cubicchunks.FluidStateCapabilityICube;
import git.jbredwards.fluidlogged_api.mod.common.capability.util.FluidStateStorage;
import git.jbredwards.fluidlogged_api.mod.common.command.CommandReloadConfig;
import git.jbredwards.fluidlogged_api.mod.common.command.CommandSetFluidState;
import git.jbredwards.fluidlogged_api.mod.common.config.FluidloggedAPIConfigHandler;
import git.jbredwards.fluidlogged_api.mod.common.legacy.LegacyDataFixer;
import git.jbredwards.fluidlogged_api.mod.common.message.MessageReloadConfig;
import git.jbredwards.fluidlogged_api.mod.common.message.MessageSyncFluidStates;
import git.jbredwards.fluidlogged_api.mod.common.message.MessageVaporizeEffects;
import java.io.IOException;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockDispenser;
import net.minecraft.command.ICommand;
import net.minecraft.init.Items;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IFixType;
import net.minecraft.util.datafix.IFixableData;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.fluids.DispenseFluidContainer;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod(modid="fluidlogged_api", name="Fluidlogged API", version="2.2.7", acceptedMinecraftVersions="[1.12.2]")
public final class FluidloggedAPI {
    @Nonnull
    public static final String MODID = "fluidlogged_api";
    @Nonnull
    public static final String NAME = "Fluidlogged API";
    @Nonnull
    public static final String VERSION = "2.2.7";
    public static final boolean isChiseledMe = Loader.isModLoaded((String)"chiseled_me");
    public static final boolean isCubicChunks = Loader.isModLoaded((String)"cubicchunks");
    public static final boolean isDynamicLights = Loader.isModLoaded((String)"dynamiclights");

    @Mod.EventHandler
    static void preInit(@Nonnull FMLPreInitializationEvent event) {
        CapabilityManager.INSTANCE.register(IFluidStateCapability.class, (Capability.IStorage)FluidStateStorage.INSTANCE, () -> null);
        FluidloggedAPINetworkHandler.INSTANCE = NetworkRegistry.INSTANCE.newSimpleChannel(MODID);
        FluidloggedAPINetworkHandler.INSTANCE.registerMessage((IMessageHandler)MessageFluidState.Handler.INSTANCE, MessageFluidState.class, 1, Side.CLIENT);
        FluidloggedAPINetworkHandler.INSTANCE.registerMessage((IMessageHandler)MessageSyncFluidStates.Handler.INSTANCE, MessageSyncFluidStates.class, 2, Side.CLIENT);
        FluidloggedAPINetworkHandler.INSTANCE.registerMessage((IMessageHandler)MessageReloadConfig.Handler.INSTANCE, MessageReloadConfig.class, 3, Side.CLIENT);
        FluidloggedAPINetworkHandler.INSTANCE.registerMessage((IMessageHandler)MessageVaporizeEffects.Handler.INSTANCE, MessageVaporizeEffects.class, 4, Side.CLIENT);
        if (!isCubicChunks) {
            MinecraftForge.EVENT_BUS.register(FluidStateCapabilityVanilla.class);
        } else {
            MinecraftForge.EVENT_BUS.register(FluidStateCapabilityIColumn.class);
            MinecraftForge.EVENT_BUS.register(FluidStateCapabilityICube.class);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @Mod.EventHandler
    static void preInitClient(@Nonnull FMLPreInitializationEvent event) {
        UnsupportedOptifineException.checkOptifineVersion();
        if (FMLClientHandler.instance().hasOptifine()) {
            OptifineCustomWaterColors.setWaterColorHelper();
        }
    }

    @Mod.EventHandler
    static void init(@Nonnull FMLInitializationEvent event) {
        ForgeModContainer.fixVanillaCascading = true;
        BlockDispenser.field_149943_a.func_82595_a((Object)Items.field_151129_at, (Object)DispenseFluidContainer.getInstance());
        BlockDispenser.field_149943_a.func_82595_a((Object)Items.field_151131_as, (Object)DispenseFluidContainer.getInstance());
        FMLCommonHandler.instance().getDataFixer().init(MODID, 101).registerFix((IFixType)FixTypes.CHUNK, (IFixableData)new LegacyDataFixer());
    }

    @Mod.EventHandler
    static void postInit(@Nonnull FMLPostInitializationEvent event) throws IOException {
        FluidloggedAPIConfigHandler.complete();
    }

    @Mod.EventHandler
    static void start(@Nonnull FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandSetFluidState());
        event.registerServerCommand((ICommand)new CommandReloadConfig());
    }

    @Mod.EventHandler
    static void aboutToStart(@Nonnull FMLServerAboutToStartEvent event) {
        LegacyDataFixer.init();
    }

    @Mod.EventHandler
    static void stopped(@Nonnull FMLServerStoppedEvent event) {
        LegacyDataFixer.reset();
    }
}

