/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.asm.plugins.vanilla.block;

import git.jbredwards.fluidlogged_api.api.asm.IASMPlugin;
import git.jbredwards.fluidlogged_api.api.util.FluidState;
import git.jbredwards.fluidlogged_api.api.util.FluidloggedUtils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLilyPad;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public final class PluginBlock
implements IASMPlugin {
    @Override
    public int getMethodIndex(@Nonnull MethodNode method, boolean obfuscated) {
        if (method.name.equals(obfuscated ? "func_176200_f" : "isReplaceable")) {
            return 1;
        }
        if (this.checkMethod(method, "removedByPlayer", "(Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/entity/player/EntityPlayer;Z)Z")) {
            return 2;
        }
        if (this.checkMethod(method, "getExplosionResistance", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/entity/Entity;Lnet/minecraft/world/Explosion;)F")) {
            return 3;
        }
        if (this.checkMethod(method, "canSustainPlant", "(Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/EnumFacing;Lnet/minecraftforge/common/IPlantable;)Z")) {
            return 4;
        }
        return 0;
    }

    @Override
    public boolean transform(@Nonnull InsnList instructions, @Nonnull MethodNode method, @Nonnull AbstractInsnNode insn, boolean obfuscated, int index) {
        if (index == 1 && this.checkMethod(insn, obfuscated ? "func_185904_a" : "getMaterial")) {
            instructions.insert(insn, (AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/block/Block", obfuscated ? "field_149764_J" : "material", "Lnet/minecraft/block/material/Material;"));
            instructions.insert(insn, (AbstractInsnNode)new VarInsnNode(25, 0));
            this.removeFrom(instructions, insn, -3);
            return true;
        }
        if (index == 2 && this.checkField(insn, obfuscated ? "field_150350_a" : "AIR", "Lnet/minecraft/block/Block;")) {
            instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 2));
            instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 3));
            instructions.insertBefore(insn, (AbstractInsnNode)this.genMethodNode("git/jbredwards/fluidlogged_api/api/util/FluidState", "get", "(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;)Lgit/jbredwards/fluidlogged_api/api/util/FluidState;"));
            instructions.insertBefore(insn, (AbstractInsnNode)new MethodInsnNode(182, "git/jbredwards/fluidlogged_api/api/util/FluidState", "getState", "()Lnet/minecraft/block/state/IBlockState;", false));
            this.removeFrom(instructions, insn, 1);
            return true;
        }
        if (index == 3 && this.checkMethod(insn, obfuscated ? "func_149638_a" : "getExplosionResistance", "(Lnet/minecraft/entity/Entity;)F")) {
            InsnList list = new InsnList();
            list.add((AbstractInsnNode)new VarInsnNode(25, 1));
            list.add((AbstractInsnNode)new VarInsnNode(25, 2));
            list.add((AbstractInsnNode)new VarInsnNode(25, 4));
            list.add((AbstractInsnNode)this.genMethodNode("getExplosionResistance", "(Lnet/minecraft/block/Block;Lnet/minecraft/entity/Entity;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/world/Explosion;)F"));
            instructions.insert(insn, list);
            instructions.remove(insn);
            return true;
        }
        if (index == 4) {
            if (this.checkMethod(insn, obfuscated ? "func_185514_i" : "canSustainBush")) {
                InsnList list = new InsnList();
                list.add((AbstractInsnNode)new VarInsnNode(25, 5));
                list.add((AbstractInsnNode)new VarInsnNode(25, 1));
                list.add((AbstractInsnNode)new VarInsnNode(25, 2));
                list.add((AbstractInsnNode)new VarInsnNode(25, 3));
                list.add((AbstractInsnNode)this.genMethodNode("canSustainLily", "(ZLnet/minecraftforge/common/IPlantable;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;)Z"));
                instructions.insert(insn, list);
            } else if (this.checkMethod(insn, obfuscated ? "func_180495_p" : "getBlockState")) {
                instructions.insert(insn, (AbstractInsnNode)this.genMethodNode("git/jbredwards/fluidlogged_api/api/util/FluidloggedUtils", "getFluidOrReal", "(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/block/state/IBlockState;"));
                instructions.remove(insn);
            }
        }
        return false;
    }

    @Override
    public boolean transformClass(@Nonnull ClassNode classNode, boolean obfuscated) {
        classNode.fields.add(new FieldNode(1, "canFluidFlow", "Lgit/jbredwards/fluidlogged_api/api/asm/impl/ICanFluidFlowHandler;", null, null));
        classNode.interfaces.add("git/jbredwards/fluidlogged_api/api/asm/impl/ICanFluidFlowHandler$Accessor");
        this.addMethod(classNode, "getCanFluidFlowOverride", "()Lgit/jbredwards/fluidlogged_api/api/asm/impl/ICanFluidFlowHandler;", null, null, generator -> {
            generator.visitVarInsn(25, 0);
            generator.visitFieldInsn(180, "net/minecraft/block/Block", "canFluidFlow", "Lgit/jbredwards/fluidlogged_api/api/asm/impl/ICanFluidFlowHandler;");
        });
        this.addMethod(classNode, "setCanFluidFlowOverride", "(Lgit/jbredwards/fluidlogged_api/api/asm/impl/ICanFluidFlowHandler;)V", null, null, generator -> {
            generator.visitVarInsn(25, 0);
            generator.visitVarInsn(25, 1);
            generator.visitFieldInsn(181, "net/minecraft/block/Block", "canFluidFlow", "Lgit/jbredwards/fluidlogged_api/api/asm/impl/ICanFluidFlowHandler;");
        });
        return true;
    }

    public static final class Hooks {
        public static boolean canSustainLily(boolean canSustainBush, @Nonnull IPlantable plantable, @Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
            if (canSustainBush) {
                return true;
            }
            if (!(plantable instanceof BlockLilyPad)) {
                return false;
            }
            return state.func_185900_c((IBlockAccess)world, (BlockPos)pos).field_72337_e < 1.0 && FluidState.get(world, pos).getMaterial() == Material.field_151586_h;
        }

        public static float getExplosionResistance(@Nonnull Block block, @Nullable Entity exploder, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Explosion explosion) {
            if (FluidloggedUtils.isFluid(block)) {
                return block.func_149638_a(exploder);
            }
            FluidState fluidState = FluidState.get((IBlockAccess)world, pos);
            if (fluidState.isEmpty()) {
                return block.func_149638_a(exploder);
            }
            return Math.max(fluidState.getBlock().getExplosionResistance(world, pos, exploder, explosion), block.func_149638_a(exploder));
        }
    }
}

