/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.asm.plugins.vanilla.block;

import git.jbredwards.fluidlogged_api.api.asm.IASMPlugin;
import git.jbredwards.fluidlogged_api.api.util.FluidState;
import git.jbredwards.fluidlogged_api.api.util.FluidloggedUtils;
import git.jbredwards.fluidlogged_api.mod.asm.plugins.forge.PluginBlockFluidClassic;
import git.jbredwards.fluidlogged_api.mod.common.config.FluidloggedAPIConfigHandler;
import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDynamicLiquid;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.IFluidBlock;
import org.apache.commons.lang3.tuple.Pair;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public final class PluginBlockDynamicLiquid
implements IASMPlugin {
    @Override
    public boolean isMethodValid(@Nonnull MethodNode method, boolean obfuscated) {
        return method.name.equals(obfuscated ? "func_176372_g" : "isBlocked");
    }

    @Override
    public boolean transform(@Nonnull InsnList instructions, @Nonnull MethodNode method, @Nonnull AbstractInsnNode insn, boolean obfuscated, int index) {
        if (this.checkField(insn.getPrevious(), obfuscated ? "field_151567_E" : "PORTAL")) {
            InsnList list = new InsnList();
            list.add((AbstractInsnNode)new VarInsnNode(25, 5));
            list.add((AbstractInsnNode)new FieldInsnNode(178, "net/minecraft/block/material/Material", obfuscated ? "field_151594_q" : "CIRCUITS", "Lnet/minecraft/block/material/Material;"));
            list.add((AbstractInsnNode)new JumpInsnNode(165, ((JumpInsnNode)insn).label));
            instructions.insert(insn, list);
            return true;
        }
        return false;
    }

    @Override
    public boolean transformClass(@Nonnull ClassNode classNode, boolean obfuscated) {
        this.overrideMethod(classNode, method -> method.name.equals(obfuscated ? "func_180650_b" : "updateTick"), "updateLiquidTick", "(Lnet/minecraft/block/BlockDynamicLiquid;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;Ljava/util/Random;)V", generator -> {
            generator.visitVarInsn(25, 0);
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
            generator.visitVarInsn(25, 3);
            generator.visitVarInsn(25, 4);
        });
        return true;
    }

    public static final class Hooks {
        public static void updateLiquidTick(@Nonnull BlockDynamicLiquid block, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull Random rand) {
            IBlockState down;
            int slopeDistance = block.func_185698_b(world);
            if (!world.func_175697_a(pos, slopeDistance)) {
                return;
            }
            Fluid fluid = FluidloggedUtils.getFluidFromState(state);
            if (fluid == null) {
                throw new IllegalStateException("A critical error has occurred, please issue a bug report!");
            }
            IBlockState here = world.func_180495_p(pos);
            if (PluginBlockFluidClassic.Hooks.tryVaporizeHere(fluid, state, here, world, pos)) {
                here = state;
            }
            int level = (Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b);
            boolean isWater = state.func_185904_a() == Material.field_151586_h;
            int flowCost = isWater || world.field_73011_w.func_177500_n() ? 1 : 2;
            int tickRate = block.func_149738_a(world);
            if (level > 0) {
                int upLevel;
                int currentMinLevel = -100;
                int adjacentSourceBlocks = 0;
                for (EnumFacing facing : EnumFacing.field_176754_o) {
                    int neighborLevel = Hooks.getDepth(fluid, world, pos.func_177972_a(facing), facing.func_176734_d());
                    if (neighborLevel < 0) continue;
                    if (neighborLevel == 0) {
                        ++adjacentSourceBlocks;
                    }
                    if (neighborLevel >= 8) {
                        neighborLevel = 0;
                    }
                    currentMinLevel = currentMinLevel >= 0 && neighborLevel >= currentMinLevel ? currentMinLevel : neighborLevel;
                }
                int newLevel = currentMinLevel + flowCost;
                if (newLevel >= 8 || currentMinLevel < 0) {
                    newLevel = -1;
                }
                if ((upLevel = Hooks.getDepth(fluid, world, pos.func_177984_a(), EnumFacing.DOWN)) >= 0) {
                    newLevel = upLevel >= 8 ? upLevel : upLevel + 8;
                }
                if (adjacentSourceBlocks >= 2 && ForgeEventFactory.canCreateFluidSource((World)world, (BlockPos)pos, (IBlockState)state, (boolean)isWater)) {
                    IBlockState down2 = world.func_180495_p(pos.func_177977_b());
                    if (down2.func_185904_a().func_76220_a()) {
                        newLevel = 0;
                    } else if (Hooks.getDepth(fluid, world, pos.func_177977_b(), down2, EnumFacing.UP) == 0) {
                        newLevel = 0;
                    }
                }
                if (!isWater && newLevel < 8 && newLevel > level && rand.nextInt(4) != 0) {
                    tickRate *= 4;
                }
                if (newLevel == level) {
                    block.func_180690_f(world, pos, state);
                } else {
                    level = newLevel;
                    if (level < 0) {
                        world.func_175698_g(pos);
                    } else {
                        state = state.func_177226_a((IProperty)BlockLiquid.field_176367_b, (Comparable)Integer.valueOf(level));
                        world.func_180501_a(pos, state, 2);
                        world.func_175684_a(pos, (Block)block, tickRate);
                        world.func_175685_c(pos, (Block)block, false);
                    }
                }
            } else {
                if (here == state) {
                    block.func_180690_f(world, pos, state);
                }
                PluginBlockFluidClassic.Hooks.tryFlowIntoFluidloggable((IFluidBlock)block, world, pos, EnumFacing.DOWN, state, here, 8, isWater, EnumFacing.field_176754_o);
            }
            if (FluidloggedAPIConfigHandler.verticalFluidloggedFluidSpread) {
                PluginBlockFluidClassic.Hooks.tryFlowIntoFluidloggable((IFluidBlock)block, world, pos, EnumFacing.DOWN, state, here, 8, isWater, EnumFacing.DOWN);
            }
            if (Hooks.canFlowInto(fluid, block, world, pos, here, down = world.func_180495_p(pos.func_177977_b()), EnumFacing.DOWN)) {
                if (!isWater && down.func_185904_a() == Material.field_151586_h) {
                    world.func_175656_a(pos.func_177977_b(), ForgeEventFactory.fireFluidPlaceBlockEvent((World)world, (BlockPos)pos.func_177977_b(), (BlockPos)pos, (IBlockState)Blocks.field_150348_b.func_176223_P()));
                    block.func_180688_d(world, pos.func_177977_b());
                    return;
                }
                Hooks.flowInto(block, world, pos.func_177977_b(), state, down, level >= 8 ? level : level + 8);
            } else if (level >= 0 && (level == 0 || block.func_176372_g(world, pos.func_177977_b(), down)) || !FluidloggedUtils.canFluidFlow((IBlockAccess)world, pos, here, EnumFacing.DOWN)) {
                int newLevel;
                int n = newLevel = level >= 8 ? 1 : level + flowCost;
                if (newLevel >= 8) {
                    return;
                }
                int lowestPriority = 1000;
                ArrayList<Pair> positionsToFlow = new ArrayList<Pair>();
                for (EnumFacing facing : EnumFacing.field_176754_o) {
                    int priority;
                    FluidState fluidState;
                    IBlockState neighbor;
                    BlockPos neighborPos;
                    if (!FluidloggedUtils.canFluidFlow((IBlockAccess)world, pos, here, facing) || block.func_176372_g(world, neighborPos = pos.func_177972_a(facing), neighbor = world.func_180495_p(neighborPos)) || FluidloggedUtils.isCompatibleFluid((fluidState = FluidloggedUtils.getFluidState((IBlockAccess)world, neighborPos, neighbor)).getFluid(), fluid) && fluidState.getLevel() <= 0) continue;
                    int n2 = priority = block.func_176372_g(world, neighborPos.func_177977_b(), world.func_180495_p(neighborPos.func_177977_b())) ? Hooks.getSlopeDistance(block, world, neighborPos, 1, facing.func_176734_d(), fluid) : 0;
                    if (priority < lowestPriority) {
                        positionsToFlow.clear();
                    }
                    if (priority > lowestPriority) continue;
                    positionsToFlow.add(Pair.of((Object)facing, (Object)neighbor));
                    lowestPriority = priority;
                }
                for (Pair entry : positionsToFlow) {
                    if (!Hooks.canFlowInto(fluid, block, world, pos, here, (IBlockState)entry.getValue(), (EnumFacing)entry.getKey())) continue;
                    Hooks.flowInto(block, world, pos.func_177972_a((EnumFacing)entry.getKey()), state, (IBlockState)entry.getValue(), newLevel);
                }
            }
        }

        public static int getDepth(@Nonnull Fluid fluid, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing facing) {
            return Hooks.getDepth(fluid, world, pos, world.func_180495_p(pos), facing);
        }

        public static int getDepth(@Nonnull Fluid fluid, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState here, @Nonnull EnumFacing facing) {
            if (!FluidloggedUtils.canFluidFlow((IBlockAccess)world, pos, here, facing)) {
                return -1;
            }
            FluidState fluidState = FluidloggedUtils.getFluidState((IBlockAccess)world, pos, here);
            return FluidloggedUtils.isCompatibleFluid(fluid, fluidState.getFluid()) ? fluidState.getLevel() : -1;
        }

        public static int getSlopeDistance(@Nonnull BlockDynamicLiquid block, @Nonnull World world, @Nonnull BlockPos pos, int distance, @Nonnull EnumFacing sourceFacing, @Nonnull Fluid sourceFluid) {
            int lowestPriority = 1000;
            for (EnumFacing facing : EnumFacing.field_176754_o) {
                int priority;
                FluidState fluidState;
                IBlockState neighbor;
                BlockPos neighborPos;
                if (facing == sourceFacing || block.func_176372_g(world, neighborPos = pos.func_177972_a(facing), neighbor = world.func_180495_p(neighborPos)) || FluidloggedUtils.isCompatibleFluid((fluidState = FluidloggedUtils.getFluidState((IBlockAccess)world, neighborPos, neighbor)).getFluid(), sourceFluid) && fluidState.getLevel() <= 0) continue;
                if (!block.func_176372_g(world, neighborPos.func_177977_b(), world.func_180495_p(neighborPos.func_177977_b()))) {
                    return distance;
                }
                if (distance >= block.func_185698_b(world) || (priority = Hooks.getSlopeDistance(block, world, neighborPos, distance + 1, facing.func_176734_d(), sourceFluid)) >= lowestPriority) continue;
                lowestPriority = priority;
            }
            return lowestPriority;
        }

        public static boolean canFlowInto(@Nonnull Fluid fluid, @Nonnull BlockDynamicLiquid block, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState here, @Nonnull IBlockState neighbor, @Nonnull EnumFacing facing) {
            if (!FluidloggedUtils.canFluidFlow((IBlockAccess)world, pos, here, facing)) {
                return false;
            }
            BlockPos neighborPos = pos.func_177972_a(facing);
            if (block.func_176372_g(world, neighborPos, neighbor)) {
                return false;
            }
            return !FluidloggedUtils.isCompatibleFluid(fluid, FluidloggedUtils.getFluidState((IBlockAccess)world, neighborPos, neighbor).getFluid());
        }

        public static void flowInto(@Nonnull BlockDynamicLiquid block, @Nonnull World world, @Nonnull BlockPos neighborPos, @Nonnull IBlockState state, @Nonnull IBlockState neighbor, int level) {
            if (neighbor.func_185904_a() != Material.field_151579_a) {
                if (state.func_185904_a() == Material.field_151587_i) {
                    block.func_180688_d(world, neighborPos);
                } else if (neighbor.func_185904_a().func_76229_l()) {
                    neighbor.func_177230_c().func_176226_b(world, neighborPos, neighbor, 0);
                }
            }
            world.func_175656_a(neighborPos, block.func_176223_P().func_177226_a((IProperty)BlockLiquid.field_176367_b, (Comparable)Integer.valueOf(level)));
        }
    }
}

