/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.asm.plugins.vanilla.block;

import git.jbredwards.fluidlogged_api.api.asm.IASMPlugin;
import git.jbredwards.fluidlogged_api.api.block.IFluidloggableFluid;
import git.jbredwards.fluidlogged_api.api.util.FluidState;
import git.jbredwards.fluidlogged_api.api.util.FluidloggedUtils;
import git.jbredwards.fluidlogged_api.mod.asm.plugins.forge.PluginBlockFluidBase;
import git.jbredwards.fluidlogged_api.mod.asm.plugins.forge.PluginBlockFluidClassic;
import git.jbredwards.fluidlogged_api.mod.common.config.FluidloggedAPIConfigHandler;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public final class PluginBlockLiquid
implements IASMPlugin {
    @Override
    public int getMethodIndex(@Nonnull MethodNode method, boolean obfuscated) {
        if (method.name.equals(obfuscated ? "func_149645_b" : "getRenderType")) {
            return 1;
        }
        if (method.name.equals(obfuscated ? "func_176365_e" : "checkForMixing")) {
            return 2;
        }
        return method.name.equals("getFogColor") ? 3 : 0;
    }

    @Override
    public boolean transform(@Nonnull InsnList instructions, @Nonnull MethodNode method, @Nonnull AbstractInsnNode insn, boolean obfuscated, int index) {
        if (index == 1 && this.checkField(insn, "LIQUID")) {
            ((FieldInsnNode)insn).name = "MODEL";
        } else if (index == 2) {
            if (insn.getPrevious() == instructions.getFirst()) {
                instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 1));
                instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 2));
                instructions.insertBefore(insn, (AbstractInsnNode)this.genMethodNode("getHereSupplier", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;)Ljava/util/function/Supplier;"));
                instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(58, 9));
            } else if (this.checkField(insn, obfuscated ? "field_151587_i" : "LAVA")) {
                InsnList list = new InsnList();
                list.add((AbstractInsnNode)new VarInsnNode(25, 1));
                list.add((AbstractInsnNode)new VarInsnNode(25, 2));
                list.add((AbstractInsnNode)new VarInsnNode(25, 9));
                list.add((AbstractInsnNode)this.genMethodNode("isReplaceableLava", "(Lnet/minecraft/block/material/Material;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Ljava/util/function/Supplier;)Z"));
                ((JumpInsnNode)insn.getNext()).setOpcode(153);
                instructions.insert(insn, list);
                instructions.remove(insn);
            } else if (this.checkField(insn, obfuscated ? "field_151586_h" : "WATER")) {
                ((JumpInsnNode)insn.getNext()).setOpcode(153);
                instructions.insert(insn, (AbstractInsnNode)this.genMethodNode("isConnectedWater", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/EnumFacing;Ljava/util/function/Supplier;)Z"));
                instructions.insert(insn, (AbstractInsnNode)new VarInsnNode(25, 9));
                this.removeFrom(instructions, insn, -3);
                return true;
            }
        } else if (index == 3) {
            if (this.checkMethod(insn, obfuscated ? "func_76224_d" : "isLiquid")) {
                instructions.insert(insn, (AbstractInsnNode)this.genMethodNode("getLiquidFogColor", "(Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/math/Vec3d;)Z"));
                instructions.insert(insn, (AbstractInsnNode)new VarInsnNode(25, 7));
                instructions.insert(insn, (AbstractInsnNode)new VarInsnNode(25, 2));
                instructions.insert(insn, (AbstractInsnNode)new VarInsnNode(25, 1));
                this.removeFrom(instructions, insn, -1);
            } else if (insn.getOpcode() == 193) {
                instructions.insert(insn, (AbstractInsnNode)new InsnNode(3));
                this.removeFrom(instructions, insn, -2);
            } else if (insn.getOpcode() == 158) {
                this.removeFrom(instructions, insn.getPrevious(), -4);
                instructions.insertBefore(insn, (AbstractInsnNode)new InsnNode(4));
                ((JumpInsnNode)insn).setOpcode(153);
            } else if (this.checkMethod(insn, "getFogColor")) {
                instructions.insert(insn, (AbstractInsnNode)new VarInsnNode(25, 5));
                this.removeFrom(instructions, insn, -20);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean transformClass(@Nonnull ClassNode classNode, boolean obfuscated) {
        classNode.interfaces.add("git/jbredwards/fluidlogged_api/api/block/IFluidloggableFluid");
        this.overrideMethod(classNode, method -> method.name.equals(obfuscated ? "func_180661_e" : "createBlockState"), "createLiquidBlockState", "(Lnet/minecraft/block/Block;)Lnet/minecraft/block/state/BlockStateContainer;", generator -> generator.visitVarInsn(25, 0));
        this.overrideMethod(classNode, method -> method.name.equals(obfuscated ? "func_176225_a" : "shouldSideBeRendered"), "shouldLiquidSideBeRendered", "(Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/EnumFacing;)Z", generator -> {
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
            generator.visitVarInsn(25, 3);
            generator.visitVarInsn(25, 4);
        });
        this.overrideMethod(classNode, method -> method.name.equals(obfuscated ? "func_189543_a" : "getFlow"), "getFlow", "(Lnet/minecraftforge/fluids/IFluidBlock;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;)Lnet/minecraft/util/math/Vec3d;", generator -> {
            generator.visitVarInsn(25, 0);
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
            generator.visitVarInsn(25, 3);
        });
        this.overrideMethod(classNode, method -> this.checkMethod((MethodNode)method, obfuscated ? "func_190973_f" : "getBlockLiquidHeight", "(Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;)F"), "getBlockLiquidHeight", "(Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;)F", generator -> {
            generator.visitVarInsn(25, 0);
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
        });
        this.addMethod(classNode, obfuscated ? "func_149698_L" : "requiresUpdates", "()Z", null, null, generator -> generator.visitInsn(3));
        this.addMethod(classNode, "getExtendedState", "(Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/block/state/IBlockState;", null, null, generator -> {
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
            generator.visitVarInsn(25, 3);
            generator.visitVarInsn(25, 0);
            generator.visitMethodInsn(185, "net/minecraftforge/fluids/IFluidBlock", "getFluid", "()Lnet/minecraftforge/fluids/Fluid;", true);
            generator.visitInsn(2);
            generator.visitLdcInsn((Object)8);
            generator.visitLdcInsn((Object)Float.valueOf(8.0f));
            generator.visitLdcInsn((Object)Float.valueOf(0.8888889f));
            generator.visitVarInsn(25, 0);
            generator.visitVarInsn(25, 2);
            generator.visitVarInsn(25, 3);
            generator.visitMethodInsn(184, this.getHookClass(), "getSlopeAngle", "(Lnet/minecraft/block/BlockLiquid;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;)D", false);
            generator.visitInsn(144);
            generator.visitMethodInsn(184, PluginBlockLiquid.getFluidHookClass(), "getFluidExtendedState", "(Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;Lnet/minecraftforge/fluids/Fluid;IIFFF)Lnet/minecraft/block/state/IBlockState;", false);
        });
        this.addMethod(classNode, "getStateAtViewpoint", "(Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/math/Vec3d;)Lnet/minecraft/block/state/IBlockState;", "getStateAtViewpoint", "(Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/math/Vec3d;)Lnet/minecraft/block/state/IBlockState;", generator -> {
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
            generator.visitVarInsn(25, 3);
            generator.visitVarInsn(25, 4);
        });
        this.addMethod(classNode, "isEntityInsideMaterial", "(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/entity/Entity;DLnet/minecraft/block/material/Material;Z)Ljava/lang/Boolean;", null, null, generator -> {
            generator.visitVarInsn(25, 0);
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
            generator.visitVarInsn(25, 3);
            generator.visitVarInsn(25, 4);
            generator.visitVarInsn(24, 5);
            generator.visitVarInsn(25, 7);
            generator.visitVarInsn(21, 8);
            generator.visitMethodInsn(184, PluginBlockLiquid.getFluidHookClass(), "isEntityInsideFluid", "(Lnet/minecraft/block/Block;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/entity/Entity;DLnet/minecraft/block/material/Material;Z)Ljava/lang/Boolean;", false);
        });
        this.addMethod(classNode, "isAABBInsideMaterial", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/math/AxisAlignedBB;Lnet/minecraft/block/material/Material;)Ljava/lang/Boolean;", null, null, generator -> {
            generator.visitVarInsn(25, 0);
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
            generator.visitVarInsn(25, 3);
            generator.visitVarInsn(25, 4);
            generator.visitMethodInsn(184, PluginBlockLiquid.getFluidHookClass(), "isAABBInsideMaterial", "(Lnet/minecraft/block/Block;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/math/AxisAlignedBB;Lnet/minecraft/block/material/Material;)Ljava/lang/Boolean;", false);
        });
        this.addMethod(classNode, "isAABBInsideLiquid", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/math/AxisAlignedBB;)Ljava/lang/Boolean;", null, null, generator -> {
            generator.visitVarInsn(25, 0);
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
            generator.visitVarInsn(25, 3);
            generator.visitMethodInsn(184, PluginBlockLiquid.getFluidHookClass(), "isWithinFluid", "(Lnet/minecraft/block/Block;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/math/AxisAlignedBB;)Z", false);
            generator.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;", false);
        });
        this.addMethod(classNode, "getFluid", "()Lnet/minecraftforge/fluids/Fluid;", "getLiquid", "(Lnet/minecraft/block/material/Material;)Lnet/minecraftforge/fluids/Fluid;", generator -> {
            generator.visitVarInsn(25, 0);
            generator.visitFieldInsn(180, "net/minecraft/block/Block", obfuscated ? "field_149764_J" : "material", "Lnet/minecraft/block/material/Material;");
        });
        this.addMethod(classNode, "place", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraftforge/fluids/FluidStack;Z)I", "place", "(Lnet/minecraftforge/fluids/IFluidBlock;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraftforge/fluids/FluidStack;ZLnet/minecraft/block/state/IBlockState;)I", generator -> {
            generator.visitVarInsn(25, 0);
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
            generator.visitVarInsn(25, 3);
            generator.visitVarInsn(21, 4);
            generator.visitVarInsn(25, 0);
            generator.visitFieldInsn(180, "net/minecraft/block/Block", obfuscated ? "field_149764_J" : "material", "Lnet/minecraft/block/material/Material;");
            generator.visitMethodInsn(184, "net/minecraft/block/BlockLiquid", obfuscated ? "func_176361_a" : "getFlowingBlock", "(Lnet/minecraft/block/material/Material;)Lnet/minecraft/block/BlockDynamicLiquid;", false);
            generator.visitMethodInsn(182, "net/minecraft/block/Block", obfuscated ? "func_176223_P" : "getDefaultState", "()Lnet/minecraft/block/state/IBlockState;", false);
        });
        this.addMethod(classNode, "drain", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Z)Lnet/minecraftforge/fluids/FluidStack;", "drain", "(Lnet/minecraftforge/fluids/IFluidBlock;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Z)Lnet/minecraftforge/fluids/FluidStack;", generator -> {
            generator.visitVarInsn(25, 0);
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
            generator.visitVarInsn(21, 3);
        });
        this.addMethod(classNode, "canDrain", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;)Z", "canDrain", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;)Z", generator -> {
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
        });
        this.addMethod(classNode, "getFilledPercentage", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;)F", null, null, generator -> {
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
            generator.visitMethodInsn(184, "git/jbredwards/fluidlogged_api/api/util/FluidloggedUtils", "getFluidOrReal", "(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/block/state/IBlockState;", false);
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
            generator.visitMethodInsn(184, this.getHookClass(), "getBlockLiquidHeight", "(Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;)F", false);
        });
        this.addMethod(classNode, "isFluidloggableFluid", "(Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;)Z", "isLiquidFluidloggable", "(Lgit/jbredwards/fluidlogged_api/api/block/IFluidloggableFluid;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;)Z", generator -> {
            generator.visitVarInsn(25, 0);
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
            generator.visitVarInsn(25, 3);
        });
        this.addMethod(classNode, "isFluidloggableFluid", "()Z", "isLiquidFluidloggable", "(Lnet/minecraft/block/Block;)Z", generator -> generator.visitVarInsn(25, 0));
        return true;
    }

    @Nonnull
    static String getFluidHookClass() {
        return "git/jbredwards/fluidlogged_api/mod/asm/plugins/forge/PluginBlockFluidBase$Hooks";
    }

    @Override
    public boolean addLocalVariables(@Nonnull MethodNode method, @Nonnull LabelNode start, @Nonnull LabelNode end, int index) {
        if (index == 2) {
            method.localVariables.add(new LocalVariableNode("here", "Ljava/util/function/Supplier;", null, start, end, 9));
            return true;
        }
        return false;
    }

    @Override
    public boolean recalcFrames(boolean obfuscated) {
        return true;
    }

    public static final class Hooks {
        public static boolean canDrain(@Nonnull World world, @Nonnull BlockPos pos) {
            return FluidloggedUtils.getFluidState((IBlockAccess)world, pos).getLevel() == 0;
        }

        @Nonnull
        public static BlockStateContainer createLiquidBlockState(@Nonnull Block block) {
            return new BlockStateContainer.Builder(block).add((IUnlistedProperty[])BlockFluidBase.FLUID_RENDER_PROPS.toArray((Object[])new IUnlistedProperty[0])).add(new IProperty[]{BlockLiquid.field_176367_b}).build();
        }

        @Nullable
        public static FluidStack drain(@Nonnull IFluidBlock block, @Nonnull World world, @Nonnull BlockPos pos, boolean doDrain) {
            return PluginBlockFluidClassic.Hooks.drain(block, world, pos, doDrain, null);
        }

        public static float getBlockLiquidHeight(@Nonnull IBlockState state, @Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos) {
            IBlockState up = worldIn.func_180495_p(pos.func_177984_a());
            boolean flag = FluidloggedUtils.isCompatibleFluid(FluidloggedUtils.getFluidState(worldIn, pos.func_177984_a(), up).getFluid(), FluidloggedUtils.getFluidFromState(state)) && FluidloggedUtils.canFluidFlow(worldIn, pos.func_177984_a(), up, EnumFacing.DOWN) && FluidloggedUtils.canFluidFlow(worldIn, pos, worldIn.func_180495_p(pos), EnumFacing.UP);
            return flag ? 1.0f : 1.0f - BlockLiquid.func_149801_b((int)((Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b)));
        }

        @Nonnull
        public static Vec3d getFlow(@Nonnull IFluidBlock block, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull IBlockState here) {
            int decay = 8 - Hooks.getEffectiveQuanta(block, world, pos);
            Vec3d vec = Vec3d.field_186680_a;
            for (EnumFacing facing : EnumFacing.field_176754_o) {
                int power;
                BlockPos offset;
                if (!FluidloggedUtils.canFluidFlow(world, pos, here, facing) || !FluidloggedUtils.canFluidFlow(world, offset = pos.func_177972_a(facing), world.func_180495_p(offset), facing.func_176734_d())) continue;
                int otherDecay = 8 - Hooks.getEffectiveQuanta(block, world, offset);
                if (otherDecay >= 8) {
                    otherDecay = 8 - Hooks.getEffectiveQuanta(block, world, offset.func_177977_b());
                    if (otherDecay >= 8) continue;
                    power = otherDecay - (decay - 8);
                    vec = vec.func_72441_c((double)(facing.func_82601_c() * power), 0.0, (double)(facing.func_82599_e() * power));
                    continue;
                }
                power = otherDecay - decay;
                vec = vec.func_72441_c((double)(facing.func_82601_c() * power), 0.0, (double)(facing.func_82599_e() * power));
            }
            return vec.func_72432_b();
        }

        public static int getEffectiveQuanta(@Nonnull IFluidBlock block, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
            IBlockState state = world.func_180495_p(pos);
            int quantaValue = Hooks.getQuantaValue(block, world, pos, state);
            if (quantaValue <= 0 || quantaValue >= 8) {
                return quantaValue;
            }
            FluidState fluidState = FluidloggedUtils.getFluidState(world, pos, state);
            return fluidState.getLevel() >= 8 ? 8 : quantaValue;
        }

        @Nonnull
        public static Supplier<IBlockState> getHereSupplier(final @Nonnull World world, final @Nonnull BlockPos pos) {
            return new Supplier<IBlockState>(){
                IBlockState here;

                @Override
                @Nonnull
                public IBlockState get() {
                    return this.here == null ? (this.here = world.func_180495_p(pos)) : this.here;
                }
            };
        }

        @Nonnull
        public static Fluid getLiquid(@Nonnull Material material) {
            return material == Material.field_151586_h ? FluidRegistry.WATER : FluidRegistry.LAVA;
        }

        public static boolean getLiquidFogColor(@Nonnull IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Vec3d viewport) {
            if (!FluidloggedAPIConfigHandler.fancyFluidEntityCollision) {
                return !PluginBlockFluidBase.Hooks.isWithinFluid(state.func_177230_c(), (IBlockAccess)world, pos, viewport.field_72448_b, state);
            }
            return !PluginBlockFluidBase.Hooks.isWithinFluid(state.func_177230_c(), (IBlockAccess)world, pos, viewport, (IExtendedBlockState)state.func_177230_c().getExtendedState(state, (IBlockAccess)world, pos));
        }

        public static int getQuantaValue(@Nonnull IFluidBlock block, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
            if (state.func_177230_c().isAir(state, world, pos)) {
                return 0;
            }
            FluidState fluidState = FluidloggedUtils.getFluidState(world, pos, state);
            if (!FluidloggedUtils.isCompatibleFluid(fluidState.getFluid(), block.getFluid())) {
                return -1;
            }
            int level = fluidState.getLevel();
            return level >= 8 ? 8 : 8 - level;
        }

        public static double getSlopeAngle(@Nonnull BlockLiquid block, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
            Vec3d vec = block.func_189543_a(world, pos, world.func_180495_p(pos));
            return vec.field_72450_a == 0.0 && vec.field_72449_c == 0.0 ? -1000.0 : MathHelper.func_181159_b((double)vec.field_72449_c, (double)vec.field_72450_a) - 1.5707963267948966;
        }

        @Nonnull
        public static IBlockState getStateAtViewpoint(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull Vec3d viewpoint) {
            if (!FluidloggedAPIConfigHandler.fancyFluidEntityCollision ? PluginBlockFluidBase.Hooks.isWithinFluid(state.func_177230_c(), world, pos, viewpoint.field_72448_b, state) : PluginBlockFluidBase.Hooks.isWithinFluid(state.func_177230_c(), world, pos, viewpoint, (IExtendedBlockState)state.func_177230_c().getExtendedState(state, world, pos))) {
                return state;
            }
            IBlockState here = world.func_180495_p(pos);
            return here == state ? Blocks.field_150350_a.func_176223_P() : here.func_177230_c().getStateAtViewpoint(here, world, pos, viewpoint);
        }

        public static boolean isConnectedWater(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing facing, @Nonnull Supplier<IBlockState> hereIn) {
            IBlockState neighbor;
            BlockPos offset;
            IBlockState here = hereIn.get();
            if (FluidloggedUtils.canFluidFlow((IBlockAccess)world, pos, here, facing) && FluidloggedUtils.canFluidFlow((IBlockAccess)world, offset = pos.func_177972_a(facing), neighbor = world.func_180495_p(offset), facing.func_176734_d())) {
                FluidState neighborFluid = FluidloggedUtils.getFluidState((IBlockAccess)world, offset, neighbor);
                return !neighborFluid.isEmpty() && neighborFluid.getMaterial() == Material.field_151586_h && (facing != EnumFacing.UP || !neighborFluid.getFluid().isLighterThanAir());
            }
            return false;
        }

        public static boolean isLiquidFluidloggable(@Nonnull IFluidloggableFluid block, @Nonnull IBlockState fluid, @Nonnull World world, @Nonnull BlockPos pos) {
            if (!block.isFluidloggableFluid()) {
                return false;
            }
            if ((Integer)fluid.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0) {
                return true;
            }
            if (fluid.func_185904_a() != Material.field_151586_h) {
                return false;
            }
            IBlockState vertical = world.func_180495_p(pos.func_177984_a());
            return FluidloggedUtils.isCompatibleFluid(block.getFluid(), FluidloggedUtils.getFluidState((IBlockAccess)world, pos.func_177984_a(), vertical).getFluid()) && FluidloggedUtils.canFluidFlow((IBlockAccess)world, pos.func_177984_a(), vertical, EnumFacing.DOWN);
        }

        public static boolean isLiquidFluidloggable(@Nonnull Block block) {
            return block == Blocks.field_150355_j || block == Blocks.field_150353_l || block == Blocks.field_150358_i || block == Blocks.field_150356_k;
        }

        public static boolean isReplaceableLava(@Nonnull Material material, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Supplier<IBlockState> here) {
            return material == Material.field_151587_i && here.get().func_177230_c().func_176200_f((IBlockAccess)world, pos);
        }

        public static int place(@Nonnull IFluidBlock block, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull FluidStack fluidStack, boolean doPlace, @Nonnull IBlockState defaultState) {
            return PluginBlockFluidClassic.Hooks.place(block, world, pos, fluidStack, doPlace, defaultState);
        }

        public static boolean shouldLiquidSideBeRendered(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing side) {
            return PluginBlockFluidBase.Hooks.shouldFluidSideBeRendered(state, world, pos, side, -1);
        }
    }
}

