/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.asm.plugins.vanilla.world;

import git.jbredwards.fluidlogged_api.api.asm.IASMPlugin;
import git.jbredwards.fluidlogged_api.api.asm.impl.IFluidStatePrimer;
import git.jbredwards.fluidlogged_api.api.capability.IFluidStateCapability;
import git.jbredwards.fluidlogged_api.api.capability.IFluidStateContainer;
import git.jbredwards.fluidlogged_api.api.util.FluidState;
import git.jbredwards.fluidlogged_api.api.util.FluidloggedUtils;
import git.jbredwards.fluidlogged_api.mod.FluidloggedAPI;
import io.github.opencubicchunks.cubicchunks.api.world.ICubicWorld;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public final class PluginChunk
implements IASMPlugin {
    @Override
    public int getMethodIndex(@Nonnull MethodNode method, boolean obfuscated) {
        if (method.name.equals("<init>")) {
            return 1;
        }
        if (this.checkMethod(method, obfuscated ? "func_150808_b" : "getBlockLightOpacity", "(III)I")) {
            return 2;
        }
        if (method.name.equals(obfuscated ? "func_177436_a" : "setBlockState")) {
            return 3;
        }
        if (method.name.equals(obfuscated ? "func_177440_h" : "getPrecipitationHeight")) {
            return 4;
        }
        if (method.name.equals(obfuscated ? "func_76594_o" : "enqueueRelightChecks")) {
            return 5;
        }
        return this.checkMethod(method, obfuscated ? "func_150811_f" : "checkLight", "(II)Z") ? 6 : 0;
    }

    @Override
    public boolean transform(@Nonnull InsnList instructions, @Nonnull MethodNode method, @Nonnull AbstractInsnNode insn, boolean obfuscated, int index) {
        if (index == 1 && insn.getOpcode() == 182) {
            InsnList list = new InsnList();
            list.add((AbstractInsnNode)new VarInsnNode(25, 0));
            list.add((AbstractInsnNode)new VarInsnNode(25, 2));
            list.add((AbstractInsnNode)this.genMethodNode("generateFluidStates", "(Lnet/minecraft/world/chunk/Chunk;Lgit/jbredwards/fluidlogged_api/api/asm/impl/IFluidStatePrimer;)V"));
            instructions.insert(insn.getNext(), list);
            return true;
        }
        if (index == 2) {
            if (this.checkMethod(insn, obfuscated ? "func_185891_c" : "getLightOpacity", "()I")) {
                instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 0));
                instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(21, 1));
                instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(21, 2));
                instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(21, 3));
                instructions.insertBefore(insn, (AbstractInsnNode)this.genMethodNode("getFluidLightOpacity", "(Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/chunk/Chunk;III)I"));
                instructions.remove(insn);
            } else if (this.checkMethod(insn, "getLightOpacity")) {
                instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 0));
                instructions.insertBefore(insn, (AbstractInsnNode)this.genMethodNode("getFluidLightOpacity", "(Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/world/chunk/Chunk;)I"));
                instructions.remove(insn);
                return true;
            }
        } else if (index == 3 && this.checkMethod(insn, "getLightOpacity")) {
            instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 0));
            instructions.insertBefore(insn, (AbstractInsnNode)this.genMethodNode("getFluidLightOpacity", "(Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/world/chunk/Chunk;)I"));
            instructions.remove(insn);
        } else {
            if (index == 4 && this.checkMethod(insn, obfuscated ? "func_76224_d" : "isLiquid")) {
                InsnList list = new InsnList();
                list.add((AbstractInsnNode)new VarInsnNode(25, 0));
                list.add((AbstractInsnNode)new VarInsnNode(25, 5));
                list.add((AbstractInsnNode)new VarInsnNode(25, 8));
                list.add((AbstractInsnNode)this.genMethodNode("hasFluidAt", "(Lnet/minecraft/world/chunk/Chunk;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;)Z"));
                instructions.insert(insn, list);
                this.removeFrom(instructions, insn, -1);
                return true;
            }
            if (index == 5) {
                if (this.checkMethod(insn, "isAir")) {
                    instructions.insert(insn, (AbstractInsnNode)this.genMethodNode("isFluidOrAir", "(Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;)Z"));
                    this.removeFrom(instructions, this.getPrevious(insn, 4), -8);
                    instructions.remove(insn);
                } else if (this.checkMethod(insn, "getLightValue")) {
                    this.removeFrom(instructions, this.getPrevious(insn, 3), -3);
                    instructions.insert(insn, (AbstractInsnNode)this.genMethodNode("getFluidLightValue", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/world/chunk/Chunk;)I"));
                    instructions.insert(insn, (AbstractInsnNode)new VarInsnNode(25, 0));
                    instructions.remove(insn);
                    return true;
                }
            } else if (index == 6 && this.checkMethod(insn, "getLightValue")) {
                instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 0));
                instructions.insert(insn, (AbstractInsnNode)this.genMethodNode("getFluidLightValue", "(Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/world/chunk/Chunk;)I"));
                instructions.remove(insn);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean transformClass(@Nonnull ClassNode classNode, boolean obfuscated) {
        this.overrideMethod(classNode, method -> this.checkMethod((MethodNode)method, obfuscated ? "func_177437_b" : "getBlockLightOpacity", "(Lnet/minecraft/util/math/BlockPos;)I"), null, null, generator -> {
            generator.visitVarInsn(25, 0);
            generator.visitVarInsn(25, 1);
            generator.visitMethodInsn(182, "net/minecraft/util/math/BlockPos", obfuscated ? "func_177958_n" : "getX", "()I", false);
            generator.visitVarInsn(25, 1);
            generator.visitMethodInsn(182, "net/minecraft/util/math/BlockPos", obfuscated ? "func_177956_o" : "getY", "()I", false);
            generator.visitVarInsn(25, 1);
            generator.visitMethodInsn(182, "net/minecraft/util/math/BlockPos", obfuscated ? "func_177952_p" : "getZ", "()I", false);
            generator.visitMethodInsn(182, "net/minecraft/world/chunk/Chunk", obfuscated ? "func_150808_b" : "getBlockLightOpacity", "(III)I", false);
        });
        return true;
    }

    public static final class CCHooks {
        public static boolean isCubicWorld(@Nonnull World world) {
            return world instanceof ICubicWorld && ((ICubicWorld)world).isCubicWorld();
        }
    }

    public static final class Hooks {
        public static void generateFluidStates(@Nonnull Chunk chunk, @Nonnull IFluidStatePrimer primer) {
            if (FluidloggedAPI.isCubicChunks && CCHooks.isCubicWorld(chunk.func_177412_p())) {
                return;
            }
            IFluidStateCapability cap = IFluidStateCapability.get((ICapabilityProvider)chunk);
            if (cap != null) {
                IFluidStateContainer container = cap.getContainer(chunk.field_76635_g, 0, chunk.field_76647_h);
                for (int y = 0; y < 256; ++y) {
                    if (y != 0 && (y & 0xF) == 0) {
                        container = cap.getContainer(chunk.field_76635_g, y >> 4, chunk.field_76647_h);
                    }
                    for (int x = 0; x < 16; ++x) {
                        for (int z = 0; z < 16; ++z) {
                            FluidState fluidState = primer.getFluidState(x, y, z);
                            if (fluidState.isEmpty()) continue;
                            BlockPos pos = new BlockPos(chunk.field_76635_g << 4 | x, y, chunk.field_76647_h << 4 | z);
                            container.setFluidState(pos, fluidState);
                        }
                    }
                }
            }
        }

        public static int getFluidLightOpacity(@Nonnull IBlockState state, @Nonnull Chunk chunk, int x, int y, int z) {
            return Math.max(state.func_185891_c(), FluidState.getFromProvider((ICapabilityProvider)chunk, new BlockPos(chunk.field_76635_g << 4 | x & 0xF, y, chunk.field_76647_h << 4 | z & 0xF)).getState().func_185891_c());
        }

        public static int getFluidLightOpacity(@Nonnull IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Chunk chunk) {
            return Math.max(state.getLightOpacity((IBlockAccess)world, pos), FluidState.getFromProvider((ICapabilityProvider)chunk, pos).getState().getLightOpacity((IBlockAccess)world, pos));
        }

        public static int getFluidLightValue(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull Chunk chunkIn) {
            Chunk chunk = chunkIn.func_76600_a(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4) ? chunkIn : world.func_175726_f(pos);
            return Hooks.getFluidLightValue(chunk.func_177435_g(pos), world, pos, chunk);
        }

        public static int getFluidLightValue(@Nonnull IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Chunk chunk) {
            return Math.max(state.getLightValue((IBlockAccess)world, pos), FluidState.getFromProvider((ICapabilityProvider)chunk, pos).getState().getLightValue((IBlockAccess)world, pos));
        }

        public static boolean hasFluidAt(@Nonnull Chunk chunk, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
            return FluidloggedUtils.isFluid(state) || !FluidState.getFromProvider((ICapabilityProvider)chunk, pos).isEmpty();
        }

        public static boolean isFluidOrAir(@Nonnull IBlockState state, @Nonnull World world, @Nonnull BlockPos pos) {
            return state.func_177230_c().isAir(state, (IBlockAccess)world, pos) || FluidloggedUtils.isFluid(state);
        }
    }
}

