/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.asm.plugins.vanilla.world;

import git.jbredwards.fluidlogged_api.api.asm.IASMPlugin;
import git.jbredwards.fluidlogged_api.api.util.FluidState;
import git.jbredwards.fluidlogged_api.api.util.FluidloggedUtils;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public final class PluginWorldServer
implements IASMPlugin {
    @Override
    public int getMethodIndex(@Nonnull MethodNode method, boolean obfuscated) {
        if (this.checkMethod(method, obfuscated ? "func_147456_g" : "updateBlocks", null)) {
            return 1;
        }
        if (this.checkMethod(method, obfuscated ? "func_175654_a" : "updateBlockTick", null)) {
            return 2;
        }
        if (this.checkMethod(method, obfuscated ? "func_72955_a" : "tickUpdates", null)) {
            return 3;
        }
        return 0;
    }

    @Override
    public boolean transform(@Nonnull InsnList instructions, @Nonnull MethodNode method, @Nonnull AbstractInsnNode insn, boolean obfuscated, int index) {
        if (index == 1 && this.checkMethod(insn, obfuscated ? "func_76319_b" : "endSection", "()V")) {
            InsnList list = new InsnList();
            list.add((AbstractInsnNode)new VarInsnNode(25, 0));
            list.add((AbstractInsnNode)new TypeInsnNode(187, "net/minecraft/util/math/BlockPos"));
            list.add((AbstractInsnNode)new InsnNode(89));
            list.add((AbstractInsnNode)new VarInsnNode(21, 14));
            list.add((AbstractInsnNode)new VarInsnNode(21, 6));
            list.add((AbstractInsnNode)new InsnNode(96));
            list.add((AbstractInsnNode)new VarInsnNode(21, 16));
            list.add((AbstractInsnNode)new VarInsnNode(25, 11));
            list.add((AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/world/chunk/storage/ExtendedBlockStorage", obfuscated ? "func_76662_d" : "getYLocation", "()I", false));
            list.add((AbstractInsnNode)new InsnNode(96));
            list.add((AbstractInsnNode)new VarInsnNode(21, 15));
            list.add((AbstractInsnNode)new VarInsnNode(21, 7));
            list.add((AbstractInsnNode)new InsnNode(96));
            list.add((AbstractInsnNode)new MethodInsnNode(183, "net/minecraft/util/math/BlockPos", "<init>", "(III)V", false));
            list.add((AbstractInsnNode)new VarInsnNode(25, 5));
            list.add((AbstractInsnNode)this.genMethodNode("tickRandomFluid", "(Lnet/minecraft/world/WorldServer;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/world/chunk/Chunk;)V"));
            instructions.insertBefore(this.getPrevious(insn, 2), list);
            return true;
        }
        if (index == 2 && this.checkMethod(insn, obfuscated ? "func_180495_p" : "getBlockState")) {
            InsnList list = new InsnList();
            list.add((AbstractInsnNode)new VarInsnNode(25, 2));
            list.add((AbstractInsnNode)this.genMethodNode("getHereOrFluidIfMatch", "(Lnet/minecraft/world/WorldServer;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/Block;)Lnet/minecraft/block/state/IBlockState;"));
            instructions.insert(insn, list);
            instructions.remove(insn);
            return true;
        }
        if (index == 3 && this.checkMethod(insn, obfuscated ? "func_180495_p" : "getBlockState")) {
            InsnList list = new InsnList();
            list.add((AbstractInsnNode)new VarInsnNode(25, 4));
            list.add((AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/world/NextTickListEntry", obfuscated ? "func_151351_a" : "getBlock", "()Lnet/minecraft/block/Block;", false));
            list.add((AbstractInsnNode)this.genMethodNode("getHereOrFluidIfMatch", "(Lnet/minecraft/world/WorldServer;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/Block;)Lnet/minecraft/block/state/IBlockState;"));
            instructions.insert(insn, list);
            instructions.remove(insn);
            return true;
        }
        return false;
    }

    public static final class Hooks {
        public static void tickRandomFluid(@Nonnull WorldServer world, @Nonnull BlockPos pos, @Nonnull Chunk chunk) {
            FluidState fluidState = FluidState.getFromProvider((ICapabilityProvider)chunk, pos);
            if (fluidState.getBlock().func_149653_t()) {
                fluidState.getBlock().func_180645_a((World)world, pos, fluidState.getState(), world.field_73012_v);
            }
        }

        @Nonnull
        public static IBlockState getHereOrFluidIfMatch(@Nonnull WorldServer world, @Nonnull BlockPos pos, @Nonnull Block compare) {
            FluidState fluidState;
            if (world.func_189509_E(pos)) {
                return Blocks.field_150350_a.func_176223_P();
            }
            Chunk chunk = world.func_175726_f(pos);
            IBlockState here = chunk.func_177435_g(pos);
            if (Block.func_149680_a((Block)compare, (Block)here.func_177230_c())) {
                return here;
            }
            if (FluidloggedUtils.isFluid(compare) && !(fluidState = FluidState.getFromProvider((ICapabilityProvider)chunk, pos)).isEmpty() && Block.func_149680_a((Block)compare, (Block)fluidState.getBlock())) {
                return fluidState.getState();
            }
            return here;
        }
    }
}

