/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.asm.transformers;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraftforge.fml.relauncher.FMLLaunchHandler;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public final class TransformerLevelProperty
implements IClassTransformer,
Opcodes {
    @Nullable
    public byte[] transform(@Nonnull String name, @Nonnull String transformedName, @Nullable byte[] basicClass) {
        if (basicClass == null) {
            return null;
        }
        ClassNode classNode = new ClassNode();
        new ClassReader(basicClass).accept((ClassVisitor)classNode, 0);
        if ("git/jbredwards/fluidlogged_api/api/util/FluidState".equals(classNode.name)) {
            return basicClass;
        }
        boolean wasClassTransformed = false;
        boolean obfuscated = !FMLLaunchHandler.isDeobfuscatedEnvironment();
        for (MethodNode method : classNode.methods) {
            if (method.name.equals(obfuscated ? "func_176201_c" : "getMetaFromState")) continue;
            for (AbstractInsnNode insn : method.instructions.toArray()) {
                if (!(insn instanceof FieldInsnNode) || !(insn.getNext() instanceof MethodInsnNode) || !((MethodInsnNode)insn.getNext()).name.equals(obfuscated ? "func_177229_b" : "getValue")) continue;
                FieldInsnNode field = (FieldInsnNode)insn;
                if (field.name.equals(obfuscated ? "field_176367_b" : "LEVEL") && field.owner.equals("net/minecraft/block/BlockLiquid")) {
                    TransformerLevelProperty.applyToInstructions(method.instructions, insn);
                    wasClassTransformed = true;
                    continue;
                }
                if (!field.name.equals("LEVEL") || !field.owner.equals("net/minecraftforge/fluids/BlockFluidBase")) continue;
                TransformerLevelProperty.applyToInstructions(method.instructions, insn);
                wasClassTransformed = true;
            }
        }
        if (wasClassTransformed) {
            ClassWriter writer = new ClassWriter(0);
            classNode.accept((ClassVisitor)writer);
            return writer.toByteArray();
        }
        return basicClass;
    }

    static void applyToInstructions(@Nonnull InsnList instructions, @Nonnull AbstractInsnNode insn) {
        instructions.insertBefore(insn, (AbstractInsnNode)new MethodInsnNode(184, "git/jbredwards/fluidlogged_api/api/util/FluidState", "of", "(Lnet/minecraft/block/state/IBlockState;)Lgit/jbredwards/fluidlogged_api/api/util/FluidState;", false));
        instructions.insertBefore(insn, (AbstractInsnNode)new MethodInsnNode(182, "git/jbredwards/fluidlogged_api/api/util/FluidState", "getLevel", "()I", false));
        boolean isJavaInteger = true;
        if (insn.getNext() != null && insn.getNext().getNext() != null && insn.getNext().getNext().getNext() instanceof MethodInsnNode) {
            MethodInsnNode method = (MethodInsnNode)insn.getNext().getNext().getNext();
            if (method.name.equals("intValue") && method.owner.equals("java/lang/Integer")) {
                instructions.remove(insn.getNext());
                instructions.remove(insn.getNext());
                isJavaInteger = false;
            }
        }
        if (isJavaInteger) {
            instructions.insertBefore(insn, (AbstractInsnNode)new MethodInsnNode(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;", false));
        }
        instructions.remove(insn.getNext());
        instructions.remove(insn);
    }
}

