/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.client.model;

import com.google.common.collect.ImmutableMap;
import git.jbredwards.fluidlogged_api.mod.asm.plugins.forge.PluginBlockFluidBase;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.TRSRTransformer;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

@SideOnly(value=Side.CLIENT)
public class BakedModelFluid
implements IBakedModel {
    protected static final int[] WSEN = new int[]{1, 0, 3, 2};
    protected static final int[] x = new int[]{0, 0, 1, 1};
    protected static final int[] z = new int[]{0, 1, 1, 0};
    protected static final float eps = 0.001f;
    @Nonnull
    protected final Optional<TRSRTransformation> transformation;
    @Nonnull
    protected final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms;
    protected final boolean hasTransform;
    @Nonnull
    protected final VertexFormat format;
    @Nonnull
    protected final TextureAtlasSprite still;
    @Nonnull
    protected final TextureAtlasSprite flowing;
    @Nonnull
    protected final Optional<TextureAtlasSprite> overlay;
    protected final float[] argb = new float[4];
    protected final boolean gas;

    public BakedModelFluid(@Nonnull Fluid fluidIn, @Nonnull IModelState stateIn, @Nonnull VertexFormat formatIn, @Nonnull Function<ResourceLocation, TextureAtlasSprite> textureGetterIn) {
        this(fluidIn, fluidIn.getStill(), fluidIn.getFlowing(), stateIn, formatIn, textureGetterIn);
    }

    public BakedModelFluid(@Nonnull Fluid fluidIn, @Nonnull ResourceLocation stillIn, @Nonnull ResourceLocation flowingIn, @Nonnull IModelState stateIn, @Nonnull VertexFormat formatIn, @Nonnull Function<ResourceLocation, TextureAtlasSprite> textureGetterIn) {
        this.transformation = stateIn.apply(Optional.empty());
        this.transforms = PerspectiveMapWrapper.getTransforms((IModelState)stateIn);
        this.hasTransform = this.transformation.isPresent() && !this.transformation.get().isIdentity();
        this.format = formatIn;
        this.still = textureGetterIn.apply(stillIn);
        this.flowing = textureGetterIn.apply(flowingIn);
        this.overlay = Optional.ofNullable(fluidIn.getOverlay()).map(textureGetterIn);
        int color = fluidIn.getColor();
        this.argb[0] = (float)(color >> 24 & 0xFF) / 255.0f;
        this.argb[1] = (float)(color >> 16 & 0xFF) / 255.0f;
        this.argb[2] = (float)(color >> 8 & 0xFF) / 255.0f;
        this.argb[3] = (float)(color & 0xFF) / 255.0f;
        this.gas = fluidIn.isLighterThanAir();
    }

    @Nonnull
    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        if (side != null) {
            if (state instanceof PluginBlockFluidBase.FluidExtendedBlockState) {
                PluginBlockFluidBase.FluidExtendedBlockState extended = (PluginBlockFluidBase.FluidExtendedBlockState)state;
                if (!extended.shouldSideBeRenderedCache[side.ordinal()]) {
                    return Collections.emptyList();
                }
                EnumFacing.Axis axis = side.func_176740_k();
                if (axis == EnumFacing.Axis.Y) {
                    EnumFacing top;
                    EnumFacing enumFacing = top = this.gas ? EnumFacing.DOWN : EnumFacing.UP;
                    if (side == top) {
                        float[] y = new float[4];
                        boolean fullVolume = true;
                        for (int i2 = 0; i2 < 4; ++i2) {
                            float value = extended.levelCorners[i2].floatValue();
                            if (value < 1.0f) {
                                fullVolume = false;
                            }
                            y[i2] = this.gas ? 1.0f - value : value;
                        }
                        boolean isFlowing = extended.flowDirection != null && extended.flowDirection.floatValue() > -1000.0f;
                        float flow = isFlowing ? extended.flowDirection.floatValue() : 0.0f;
                        TextureAtlasSprite topSprite = isFlowing ? this.flowing : this.still;
                        float scale = isFlowing ? 4.0f : 8.0f;
                        float c = MathHelper.func_76134_b((float)flow) * scale;
                        float s = MathHelper.func_76126_a((float)flow) * scale;
                        VertexParameter uv = i -> c * (float)((x[i] << 1) - 1) + s * (float)((z[i] << 1) - 1);
                        VertexParameter topX = i -> x[i];
                        VertexParameter topY = i -> y[i];
                        VertexParameter topZ = i -> z[i];
                        VertexParameter topU = i -> 8.0f + uv.get(i);
                        VertexParameter topV = i -> 8.0f + uv.get(i + 1 & 3);
                        LinkedList<BakedQuad> quads = new LinkedList<BakedQuad>();
                        quads.add(this.buildQuad(top, topSprite, this.gas, false, topX, topY, topZ, topU, topV));
                        if (!fullVolume) {
                            quads.add(this.buildQuad(top, topSprite, !this.gas, true, topX, topY, topZ, topU, topV));
                        }
                        return Collections.unmodifiableList(quads);
                    }
                    return Collections.singletonList(this.buildQuad(top.func_176734_d(), this.still, this.gas, false, i -> z[i], i -> this.gas ? 0.998f : 0.002f, i -> x[i], i -> z[i] << 4, i -> x[i] << 4));
                }
                boolean useOverlay = this.overlay.isPresent() && extended.sideOverlays[side.func_176736_b()] != false;
                int si = WSEN[side.func_176736_b()];
                float[] y = new float[4];
                for (int i3 = 0; i3 < 4; ++i3) {
                    y[i3] = this.gas ? 1.0f - extended.levelCorners[i3].floatValue() : extended.levelCorners[i3].floatValue();
                }
                VertexParameter sideX = j -> BakedModelFluid.fixTextureFightingX(x[si + x[j] & 3], side);
                VertexParameter sideY = j -> z[j] == 0 ? (float)(this.gas ? 1 : 0) : y[si + x[j] & 3];
                VertexParameter sideZ = j -> BakedModelFluid.fixTextureFightingZ(z[si + x[j] & 3], side);
                VertexParameter sideU = j -> x[j] << 3;
                VertexParameter sideV = j -> (this.gas ? sideY.get(j) : 1.0f - sideY.get(j)) * 8.0f;
                LinkedList<BakedQuad> quads = new LinkedList<BakedQuad>();
                if (!useOverlay) {
                    quads.add(this.buildQuad(side, this.flowing, this.gas, true, sideX, sideY, sideZ, sideU, sideV));
                }
                quads.add(this.buildQuad(side, useOverlay ? this.overlay.get() : this.flowing, !this.gas, false, sideX, sideY, sideZ, sideU, sideV));
                return Collections.unmodifiableList(quads);
            }
            if (side == EnumFacing.SOUTH) {
                return Collections.singletonList(this.buildQuad(EnumFacing.UP, this.still, false, false, i -> z[i], i -> x[i], i -> 0.0f, i -> z[i] << 4, i -> x[i] << 4));
            }
        }
        return Collections.emptyList();
    }

    @Nonnull
    protected BakedQuad buildQuad(@Nonnull EnumFacing side, @Nonnull TextureAtlasSprite texture, boolean flip, boolean offset, @Nonnull VertexParameter x, @Nonnull VertexParameter y, @Nonnull VertexParameter z, @Nonnull VertexParameter u, @Nonnull VertexParameter v) {
        UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(this.format);
        UnpackedBakedQuad.Builder consumer = this.hasTransform ? new TRSRTransformer((IVertexConsumer)builder, this.transformation.get()) : builder;
        consumer.setQuadOrientation(side);
        consumer.setTexture(texture);
        consumer.setQuadTint(0);
        for (int i = 0; i < 4; ++i) {
            int vertex = flip ? 3 - i : i;
            this.putVertex((IVertexConsumer)consumer, side, offset, x.get(vertex), y.get(vertex), z.get(vertex), texture.func_94214_a((double)u.get(vertex)), texture.func_94207_b((double)v.get(vertex)));
        }
        return builder.build();
    }

    protected void putVertex(@Nonnull IVertexConsumer consumer, @Nonnull EnumFacing side, boolean offset, float x, float y, float z, float u, float v) {
        block6: for (int element = 0; element < this.format.func_177345_h(); ++element) {
            switch (this.format.func_177348_c(element).func_177375_c()) {
                case POSITION: {
                    Vec3i vec;
                    if (offset) {
                        vec = side.func_176730_m();
                        float dx = (float)vec.func_177958_n() * 0.001f;
                        float dy = (float)vec.func_177956_o() * 0.001f;
                        float dz = (float)vec.func_177952_p() * 0.001f;
                        consumer.put(element, new float[]{x - dx, y - dy, z - dz, 1.0f});
                        continue block6;
                    }
                    consumer.put(element, new float[]{x, y, z, 1.0f});
                    continue block6;
                }
                case COLOR: {
                    consumer.put(element, new float[]{this.argb[1], this.argb[2], this.argb[3], this.argb[0]});
                    continue block6;
                }
                case NORMAL: {
                    Vec3i vec = side.func_176730_m();
                    consumer.put(element, new float[]{vec.func_177958_n(), vec.func_177956_o(), vec.func_177952_p(), 0.0f});
                    continue block6;
                }
                case UV: {
                    if (this.format.func_177348_c(element).func_177369_e() == 0) {
                        consumer.put(element, new float[]{u, v, 0.0f, 1.0f});
                        continue block6;
                    }
                }
                default: {
                    consumer.put(element, new float[0]);
                }
            }
        }
    }

    public boolean func_177555_b() {
        return false;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    @Nonnull
    public TextureAtlasSprite func_177554_e() {
        return this.still;
    }

    @Nonnull
    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }

    @Nonnull
    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(@Nonnull ItemCameraTransforms.TransformType cameraTransformType) {
        return PerspectiveMapWrapper.handlePerspective((IBakedModel)this, this.transforms, (ItemCameraTransforms.TransformType)cameraTransformType);
    }

    public static float fixTextureFightingX(float old, @Nonnull EnumFacing side) {
        return side.func_176740_k() == EnumFacing.Axis.Z ? old : (old == 1.0f ? 0.998f : 0.002f);
    }

    public static float fixTextureFightingZ(float old, @Nonnull EnumFacing side) {
        return side.func_176740_k() == EnumFacing.Axis.X ? old : (old == 1.0f ? 0.998f : 0.002f);
    }

    @FunctionalInterface
    public static interface VertexParameter {
        public float get(int var1);
    }
}

