/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.common.capability.cubicchunks;

import git.jbredwards.fluidlogged_api.api.capability.CapabilityProvider;
import git.jbredwards.fluidlogged_api.api.capability.IFluidStateCapability;
import git.jbredwards.fluidlogged_api.api.capability.IFluidStateContainer;
import git.jbredwards.fluidlogged_api.api.network.FluidloggedAPINetworkHandler;
import git.jbredwards.fluidlogged_api.mod.common.capability.FluidStateCapabilityVanilla;
import git.jbredwards.fluidlogged_api.mod.common.message.MessageSyncFluidStates;
import io.github.opencubicchunks.cubicchunks.api.world.IColumn;
import io.github.opencubicchunks.cubicchunks.api.world.ICubicWorld;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.world.ChunkWatchEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class FluidStateCapabilityIColumn
implements IFluidStateCapability {
    @Nonnull
    protected final IColumn column;

    public FluidStateCapabilityIColumn(@Nonnull IColumn column) {
        this.column = column;
    }

    @SubscribeEvent
    static void attach(@Nonnull AttachCapabilitiesEvent<Chunk> event) {
        if (event.getObject() instanceof IColumn && FluidStateCapabilityIColumn.isCubicWorld(((Chunk)event.getObject()).func_177412_p())) {
            event.addCapability(CAPABILITY_ID, new CapabilityProvider<FluidStateCapabilityIColumn>(CAPABILITY, new FluidStateCapabilityIColumn((IColumn)event.getObject())));
        } else {
            Chunk chunk = (Chunk)event.getObject();
            event.addCapability(CAPABILITY_ID, new CapabilityProvider<FluidStateCapabilityVanilla>(CAPABILITY, new FluidStateCapabilityVanilla(chunk.field_76635_g, chunk.field_76647_h)));
        }
    }

    @SubscribeEvent
    static void sync(@Nonnull ChunkWatchEvent.Watch event) {
        IFluidStateCapability cap;
        Chunk chunk = event.getChunkInstance();
        if (chunk != null && !FluidStateCapabilityIColumn.isCubicWorld(chunk.func_177412_p()) && (cap = IFluidStateCapability.get((ICapabilityProvider)chunk)) != null) {
            FluidloggedAPINetworkHandler.INSTANCE.sendTo((IMessage)new MessageSyncFluidStates(chunk, cap), event.getPlayer());
        }
    }

    static boolean isCubicWorld(@Nonnull World world) {
        return world instanceof ICubicWorld && ((ICubicWorld)world).isCubicWorld();
    }

    @Override
    @Nonnull
    public IFluidStateContainer getContainer(@Nonnull BlockPos pos) {
        return this.getContainer(pos.func_177958_n() >> 4, pos.func_177956_o() >> 4, pos.func_177952_p() >> 4);
    }

    @Override
    @Nonnull
    public IFluidStateContainer getContainer(int chunkX, int chunkY, int chunkZ) {
        return Objects.requireNonNull(IFluidStateCapability.get((ICapabilityProvider)this.column.getCube(chunkY))).getContainer(chunkX, chunkY, chunkZ);
    }

    @Nonnull
    public NBTBase serializeNBT() {
        return new NBTTagCompound();
    }

    public void deserializeNBT(@Nonnull NBTBase nbt) {
    }
}

