/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.common.capability.cubicchunks;

import git.jbredwards.fluidlogged_api.api.capability.CapabilityProvider;
import git.jbredwards.fluidlogged_api.api.capability.IFluidStateCapability;
import git.jbredwards.fluidlogged_api.api.network.FluidloggedAPINetworkHandler;
import git.jbredwards.fluidlogged_api.mod.common.capability.FluidStateCapabilityVanilla;
import git.jbredwards.fluidlogged_api.mod.common.message.MessageSyncFluidStates;
import io.github.opencubicchunks.cubicchunks.api.world.CubeWatchEvent;
import io.github.opencubicchunks.cubicchunks.api.world.ICube;
import javax.annotation.Nonnull;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class FluidStateCapabilityICube
extends FluidStateCapabilityVanilla {
    protected final int chunkY;

    public FluidStateCapabilityICube(int chunkXIn, int chunkYIn, int chunkZIn) {
        super(chunkXIn, chunkZIn);
        this.chunkY = chunkYIn;
    }

    @SubscribeEvent
    static void attachToCube(@Nonnull AttachCapabilitiesEvent<ICube> event) {
        ICube cube = (ICube)event.getObject();
        event.addCapability(CAPABILITY_ID, new CapabilityProvider<FluidStateCapabilityICube>(CAPABILITY, new FluidStateCapabilityICube(cube.getX(), cube.getY(), cube.getZ())));
    }

    @SubscribeEvent
    static void sync(@Nonnull CubeWatchEvent event) {
        ICube cube = event.getCube();
        IFluidStateCapability cap = IFluidStateCapability.get((ICapabilityProvider)cube);
        if (cap != null) {
            FluidloggedAPINetworkHandler.INSTANCE.sendTo((IMessage)new MessageSyncFluidStates(cube.getX(), cube.getY(), cube.getZ(), cap), event.getPlayer());
        }
    }

    @Override
    public char serializePos(@Nonnull BlockPos pos) {
        return (char)((pos.func_177956_o() & 0xF) << 8 | (pos.func_177952_p() & 0xF) << 4 | pos.func_177958_n() & 0xF);
    }

    @Override
    @Nonnull
    public BlockPos deserializePos(char serializedPos) {
        int x = this.chunkX << 4 | serializedPos & 0xF;
        int y = this.chunkY << 4 | serializedPos >> 8 & 0xF;
        int z = this.chunkZ << 4 | serializedPos >> 4 & 0xF;
        return new BlockPos(x, y, z);
    }
}

