/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.common.command;

import com.google.common.collect.ImmutableList;
import git.jbredwards.fluidlogged_api.api.util.FluidState;
import git.jbredwards.fluidlogged_api.api.util.FluidloggedUtils;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandResultStats;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;

public class CommandSetFluidState
extends CommandBase {
    @Nonnull
    protected static final List<ResourceLocation> TAB_COMPLETIONS = ImmutableList.builder().add((Object[])FluidRegistry.getRegisteredFluids().values().stream().filter(fluid -> FluidloggedUtils.isFluidloggableFluid(fluid.getBlock())).map(fluid -> fluid.getBlock().getRegistryName()).filter(Objects::nonNull).toArray(ResourceLocation[]::new)).add((Object)new ResourceLocation("air")).build();

    @Nonnull
    public String func_71517_b() {
        return "setfluid";
    }

    public int func_82362_a() {
        return 2;
    }

    @Nonnull
    public String func_71518_a(@Nonnull ICommandSender sender) {
        return "commands.setfluid.usage";
    }

    public void func_184881_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args) throws CommandException {
        if (args.length < 4) {
            throw new WrongUsageException("commands.setfluid.usage", new Object[0]);
        }
        sender.func_174794_a(CommandResultStats.Type.AFFECTED_BLOCKS, 0);
        BlockPos pos = CommandSetFluidState.func_175757_a((ICommandSender)sender, (String[])args, (int)0, (boolean)false);
        World world = sender.func_130014_f_();
        if (!world.func_175667_e(pos)) {
            throw new CommandException("commands.setfluid.outOfWorld", new Object[0]);
        }
        FluidState fluidState = FluidState.of(CommandSetFluidState.func_147180_g((ICommandSender)sender, (String)args[3]));
        IBlockState here = world.func_180495_p(pos);
        if (FluidloggedUtils.isStateFluidloggable(here, world, pos, fluidState.getFluid()) ? !FluidloggedUtils.setFluidState(world, pos, here, fluidState, false, true, 2) : !world.func_180501_a(pos, fluidState.getState(), 2)) {
            throw new CommandException("commands.setfluid.noChange", new Object[0]);
        }
        CommandSetFluidState.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"commands.setfluid.success", (Object[])new Object[0]);
    }

    @Nonnull
    public List<String> func_184883_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args, @Nullable BlockPos targetPos) {
        if (args.length > 0 && args.length <= 3) {
            return CommandSetFluidState.func_175771_a((String[])args, (int)0, (BlockPos)targetPos);
        }
        return args.length > 4 ? Collections.emptyList() : CommandSetFluidState.func_175762_a((String[])args, TAB_COMPLETIONS);
    }
}

