/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.common.config;

import com.google.common.primitives.Ints;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import git.jbredwards.fluidlogged_api.api.asm.impl.ICanFluidFlowHandler;
import git.jbredwards.fluidlogged_api.api.util.FluidloggedUtils;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class FluidloggedAPIConfigHandler {
    @Nonnull
    static final Gson GSON = new GsonBuilder().registerTypeAdapter(ConfigPredicateBuilder.class, (Object)new ConfigPredicateDeserializer()).create();
    @Nonnull
    static final Logger LOGGER = LogManager.getFormatterLogger((String)"Fluidlogged API Config");
    @Nonnull
    static final Map<String, Set<Fluid>> FLUID_TAGS_CACHE = new HashMap<String, Set<Fluid>>();
    @Nonnull
    public static final Map<Block, ConfigPredicate> WHITELIST = new HashMap<Block, ConfigPredicate>();
    @Nonnull
    public static final Map<Block, ConfigPredicate> BLACKLIST = new HashMap<Block, ConfigPredicate>();
    @Nullable
    static Config config;
    public static boolean applyDefaults;
    public static boolean fluidsBreakTorches;
    public static boolean debugASMPlugins;
    public static int fluidloggedFluidSpread;
    public static boolean verticalFluidloggedFluidSpread;
    public static boolean lavalogVaporizeFlammable;
    public static boolean fancyFluidEntityCollision;

    @Nonnull
    public static Event.Result isStateFluidloggable(@Nonnull IBlockState state, @Nullable Fluid fluid) {
        ConfigPredicate whitelist = WHITELIST.get(state.func_177230_c());
        if (whitelist != null && whitelist.test(state, fluid)) {
            return Event.Result.ALLOW;
        }
        if (!applyDefaults) {
            return Event.Result.DENY;
        }
        ConfigPredicate blacklist = BLACKLIST.get(state.func_177230_c());
        if (blacklist != null && blacklist.test(state, fluid)) {
            return Event.Result.DENY;
        }
        return Event.Result.DEFAULT;
    }

    public static void init() {
        File cfg = new File("config", "fluidlogged_api.cfg");
        try {
            if (cfg.createNewFile()) {
                String contents = "#determines how certain \"infinite\" fluids (ie. water not lava) can spread between fluidloggable blocks\n#case 0: fluids cannot flow into fluidloggable blocks\n#case 1: fluids can flow into fluidloggable blocks, but only from fluidlogged blocks (legacy mod behavior)\n#case 2: fluids can flow into fluidloggable blocks from fluidlogged blocks & normal fluid blocks (1.13 behavior)\nfluidloggedFluidSpread:2,\n\n#flowing fluid blocks break torches (vanilla behavior)\nfluidsBreakTorches:true,\n\n#this mod by default allows certain blocks to be fluidlogged\napplyDefaults:true,\n\n#true if flammable blocks should be destroyed when fluidlogged with a hot or burning liquid (like lava)\nlavalogVaporizeFlammable:false,\n\n#whitelist for adding new fluidloggable blocks (this is in addition to the defaults)\n#info about the format for this can be found on this mod's wiki:\n#https://github.com/jbredwards/Fluidlogged-API/wiki/Config\nwhitelist:[],\n\n#blacklist blocks from the defaults\n#info about the format for this can be found on this mod's wiki:\n#https://github.com/jbredwards/Fluidlogged-API/wiki/Config\nblacklist:[],\n\n#used by the whitelist & blacklist to easily define fluid groups for fluidlogging\n#info about the format for this can be found on this mod's wiki:\n#https://github.com/jbredwards/Fluidlogged-API/wiki/Config\nfluidTags:[],\n\n#otuput to the console for every ASM transformation, useful for debugging\ndebugASMPlugins:false,\n\n#when a flammable fluidloggable block is placed in a lava-like fluid, the block is vaporized\nlavalogVaporizeFlammable:false,\n\n#remove the ability for \"infinite\" fluids to fluidlog blocks below\nremoveVerticalFluidloggedFluidSpread:false,\n\n#fluid-entity collision is exact, taking corner heights into account\n#WARNING: enabling this may result in worse performance\nfancyFluidEntityCollision:false";
                FileWriter writer = new FileWriter(cfg);
                writer.write("#determines how certain \"infinite\" fluids (ie. water not lava) can spread between fluidloggable blocks\n#case 0: fluids cannot flow into fluidloggable blocks\n#case 1: fluids can flow into fluidloggable blocks, but only from fluidlogged blocks (legacy mod behavior)\n#case 2: fluids can flow into fluidloggable blocks from fluidlogged blocks & normal fluid blocks (1.13 behavior)\nfluidloggedFluidSpread:2,\n\n#flowing fluid blocks break torches (vanilla behavior)\nfluidsBreakTorches:true,\n\n#this mod by default allows certain blocks to be fluidlogged\napplyDefaults:true,\n\n#true if flammable blocks should be destroyed when fluidlogged with a hot or burning liquid (like lava)\nlavalogVaporizeFlammable:false,\n\n#whitelist for adding new fluidloggable blocks (this is in addition to the defaults)\n#info about the format for this can be found on this mod's wiki:\n#https://github.com/jbredwards/Fluidlogged-API/wiki/Config\nwhitelist:[],\n\n#blacklist blocks from the defaults\n#info about the format for this can be found on this mod's wiki:\n#https://github.com/jbredwards/Fluidlogged-API/wiki/Config\nblacklist:[],\n\n#used by the whitelist & blacklist to easily define fluid groups for fluidlogging\n#info about the format for this can be found on this mod's wiki:\n#https://github.com/jbredwards/Fluidlogged-API/wiki/Config\nfluidTags:[],\n\n#otuput to the console for every ASM transformation, useful for debugging\ndebugASMPlugins:false,\n\n#when a flammable fluidloggable block is placed in a lava-like fluid, the block is vaporized\nlavalogVaporizeFlammable:false,\n\n#remove the ability for \"infinite\" fluids to fluidlog blocks below\nremoveVerticalFluidloggedFluidSpread:false,\n\n#fluid-entity collision is exact, taking corner heights into account\n#WARNING: enabling this may result in worse performance\nfancyFluidEntityCollision:false");
                writer.close();
                fluidloggedFluidSpread = 2;
                fluidsBreakTorches = true;
                applyDefaults = true;
                debugASMPlugins = true;
                verticalFluidloggedFluidSpread = true;
                lavalogVaporizeFlammable = false;
                fancyFluidEntityCollision = false;
            } else {
                config = (Config)GSON.fromJson('{' + IOUtils.toString((Reader)new FileReader(cfg)) + '}', Config.class);
                fluidloggedFluidSpread = FluidloggedAPIConfigHandler.config.fluidloggedFluidSpread;
                fluidsBreakTorches = FluidloggedAPIConfigHandler.config.fluidsBreakTorches;
                applyDefaults = FluidloggedAPIConfigHandler.config.applyDefaults;
                debugASMPlugins = FluidloggedAPIConfigHandler.config.debugASMPlugins;
                verticalFluidloggedFluidSpread = !FluidloggedAPIConfigHandler.config.removeVerticalFluidloggedFluidSpread;
                lavalogVaporizeFlammable = FluidloggedAPIConfigHandler.config.lavalogVaporizeFlammable;
                fancyFluidEntityCollision = FluidloggedAPIConfigHandler.config.fancyFluidEntityCollision;
                if (ConfigPredicateDeserializer.containsMissingEntries) {
                    ConfigPredicateDeserializer.containsMissingEntries = false;
                    LOGGER.info("If you're unclear on how to format the whitelist or blacklist of the config, check out this mod's config wiki: https://github.com/jbredwards/Fluidlogged-API/wiki/Config");
                }
            }
            WHITELIST.clear();
            BLACKLIST.clear();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void complete() throws IOException {
        for (String modId : Loader.instance().getIndexedModList().keySet()) {
            InputStream blacklist;
            InputStream whitelist;
            InputStream fluidTags = Loader.class.getResourceAsStream(String.format("/assets/%s/fluidlogged_api/fluidTags.json", modId));
            if (fluidTags != null) {
                FluidloggedAPIConfigHandler.readFluidTags((FluidTag[])GSON.fromJson((Reader)new InputStreamReader(fluidTags), FluidTag[].class));
            }
            if ((whitelist = Loader.class.getResourceAsStream(String.format("/assets/%s/fluidlogged_api/whitelist.json", modId))) != null) {
                FluidloggedAPIConfigHandler.readPredicates(WHITELIST, (ConfigPredicateBuilder[])GSON.fromJson((Reader)new InputStreamReader(whitelist), ConfigPredicateBuilder[].class));
            }
            if ((blacklist = Loader.class.getResourceAsStream(String.format("/assets/%s/fluidlogged_api/blacklist.json", modId))) != null) {
                FluidloggedAPIConfigHandler.readPredicates(BLACKLIST, (ConfigPredicateBuilder[])GSON.fromJson((Reader)new InputStreamReader(blacklist), ConfigPredicateBuilder[].class));
            }
            FLUID_TAGS_CACHE.clear();
        }
        if (config != null) {
            FluidloggedAPIConfigHandler.readFluidTags(FluidloggedAPIConfigHandler.config.fluidTags);
            FluidloggedAPIConfigHandler.readPredicates(WHITELIST, FluidloggedAPIConfigHandler.config.whitelist);
            FluidloggedAPIConfigHandler.readPredicates(BLACKLIST, FluidloggedAPIConfigHandler.config.blacklist);
            FLUID_TAGS_CACHE.clear();
            config = null;
        }
    }

    private static void readFluidTags(@Nullable FluidTag[] tags) {
        if (tags == null) {
            return;
        }
        for (FluidTag tag : tags) {
            if (FLUID_TAGS_CACHE.containsKey(tag.id)) {
                throw new JsonParseException("Fluidlogged API Config: two fluidTags found with the same id: " + tag.id + ", please either merge them or remove the duplicate");
            }
            HashSet<Fluid> fluids = new HashSet<Fluid>();
            for (String fluidName : tag.fluids) {
                Block fluidBlock = Block.func_149684_b((String)fluidName);
                Fluid fluid = FluidloggedUtils.getFluidFromBlock(fluidBlock);
                if (fluid == null) {
                    fluid = FluidRegistry.getFluid((String)fluidName);
                }
                if (fluid == null) {
                    throw new JsonParseException("Fluidlogged API Config: Unable to parse fluid: " + fluidName + " from fluidTag: " + tag.id);
                }
                if (!FluidloggedUtils.isFluidloggableFluid(fluidBlock)) {
                    throw new JsonParseException("Fluidlogged API Config: Specified fluid cannot be fluidlogged: " + fluidName + " in fluidTag: " + tag.id);
                }
                fluids.add(fluid);
            }
            FLUID_TAGS_CACHE.put(tag.id, fluids);
        }
    }

    private static void readPredicates(@Nonnull Map<Block, ConfigPredicate> map, @Nonnull ConfigPredicateBuilder[] builders) {
        for (ConfigPredicateBuilder builder : builders) {
            ConfigPredicate predicate;
            if (builder == ConfigPredicateDeserializer.EMPTY || (predicate = builder.build()) == null) continue;
            map.put(predicate.block, predicate);
            ICanFluidFlowHandler.Accessor.setOverride(predicate.block, builder.canFluidFlow == null ? (builder.useDeprecatedSideCheck ? ICanFluidFlowHandler.DEPRECATED_CHECK : null) : (builder.canFluidFlow != false ? ICanFluidFlowHandler.ALWAYS_FLOW : ICanFluidFlowHandler.NEVER_FLOW));
        }
    }

    static {
        applyDefaults = true;
        fluidsBreakTorches = true;
        debugASMPlugins = false;
        fluidloggedFluidSpread = 2;
        verticalFluidloggedFluidSpread = true;
        lavalogVaporizeFlammable = false;
        fancyFluidEntityCollision = false;
    }

    public static class ConfigPredicateDeserializer
    implements JsonDeserializer<ConfigPredicateBuilder> {
        @Nonnull
        protected static final ConfigPredicateBuilder EMPTY = new ConfigPredicateBuilder("", (IntSet)new IntOpenHashSet(), new JsonObject[0], new String[0], new String[0], null, false);
        protected static boolean containsMissingEntries = false;

        @Nonnull
        public ConfigPredicateBuilder deserialize(@Nonnull JsonElement jsonIn, @Nullable Type typeOfT, @Nullable JsonDeserializationContext context) throws JsonParseException {
            if (jsonIn.isJsonObject()) {
                JsonObject json = jsonIn.getAsJsonObject();
                if (!json.has("blockId")) {
                    LOGGER.warn(String.format("required \"blockId\" string argument not found within args: %s, skipping...", json));
                    containsMissingEntries = true;
                    return EMPTY;
                }
                IntOpenHashSet metadata = new IntOpenHashSet();
                if (json.has("metadata")) {
                    JsonElement metadataJson = json.get("metadata");
                    if (!metadataJson.isJsonArray()) {
                        metadata.add(metadataJson.getAsInt());
                    } else {
                        metadataJson.getAsJsonArray().forEach(arg_0 -> ConfigPredicateDeserializer.lambda$deserialize$0((IntSet)metadata, arg_0));
                    }
                }
                HashSet<JsonObject> states = new HashSet<JsonObject>();
                if (json.has("states")) {
                    JsonElement statesJson = json.get("states");
                    if (!statesJson.isJsonArray()) {
                        states.add(statesJson.getAsJsonObject());
                    } else {
                        statesJson.getAsJsonArray().forEach(element -> states.add(element.getAsJsonObject()));
                    }
                }
                HashSet<String> fluids = new HashSet<String>();
                if (json.has("fluids")) {
                    JsonElement fluidsJson = json.get("fluids");
                    if (!fluidsJson.isJsonArray()) {
                        fluids.add(fluidsJson.getAsString());
                    } else {
                        fluidsJson.getAsJsonArray().forEach(element -> fluids.add(element.getAsString()));
                    }
                }
                HashSet<String> fluidTags = new HashSet<String>();
                if (json.has("fluidTags")) {
                    JsonElement fluidTagsJson = json.get("fluidTags");
                    if (!fluidTagsJson.isJsonArray()) {
                        fluidTags.add(fluidTagsJson.getAsString());
                    } else {
                        fluidTagsJson.getAsJsonArray().forEach(element -> fluidTags.add(element.getAsString()));
                    }
                }
                Boolean canFluidFlow = json.has("canFluidFlow") ? Boolean.valueOf(json.get("canFluidFlow").getAsBoolean()) : null;
                boolean useDeprecatedSideCheck = json.has("useDeprecatedSideCheck") && json.get("useDeprecatedSideCheck").getAsBoolean();
                return new ConfigPredicateBuilder(json.get("blockId").getAsString(), (IntSet)metadata, states.toArray(new JsonObject[0]), fluids.toArray(new String[0]), fluidTags.toArray(new String[0]), canFluidFlow, useDeprecatedSideCheck);
            }
            LOGGER.warn(String.format("bad json %s, skipping...", jsonIn));
            containsMissingEntries = true;
            return EMPTY;
        }

        private static /* synthetic */ void lambda$deserialize$0(IntSet metadata, JsonElement element) {
            metadata.add(element.getAsInt());
        }
    }

    public static class ConfigPredicateBuilder {
        @Nonnull
        protected final String blockName;
        @Nonnull
        protected final IntSet metadata;
        @Nonnull
        protected final JsonObject[] states;
        @Nonnull
        protected final String[] fluids;
        @Nonnull
        protected final String[] fluidTags;
        @Nullable
        protected final Boolean canFluidFlow;
        protected final boolean useDeprecatedSideCheck;

        public ConfigPredicateBuilder(@Nonnull String blockName, @Nonnull IntSet metadata, @Nonnull JsonObject[] states, @Nonnull String[] fluids, @Nonnull String[] fluidTags, @Nullable Boolean canFluidFlow, boolean useDeprecatedSideCheck) {
            this.metadata = metadata;
            this.states = states;
            this.fluids = fluids;
            this.fluidTags = fluidTags;
            this.canFluidFlow = canFluidFlow;
            this.blockName = blockName;
            this.useDeprecatedSideCheck = useDeprecatedSideCheck;
        }

        @Nullable
        public ConfigPredicate build() {
            Block block = Block.func_149684_b((String)this.blockName);
            if (block == null) {
                LOGGER.warn(String.format("Unable to parse block from blockId: %s, skipping...", this.blockName));
                return null;
            }
            ConfigPredicateBuilder.gatherStateMetadata(block, this.metadata, this.states);
            HashSet<Fluid> validFluids = new HashSet<Fluid>();
            for (String fluidName : this.fluids) {
                Block fluidBlock = Block.func_149684_b((String)fluidName);
                Fluid fluid = FluidloggedUtils.getFluidFromBlock(fluidBlock);
                if (fluid == null) {
                    fluid = FluidRegistry.getFluid((String)fluidName);
                }
                if (fluid == null) {
                    LOGGER.warn(String.format("Unable to parse fluid from fluids: %s, skipping...", fluidName));
                    continue;
                }
                if (!FluidloggedUtils.isFluidloggableFluid(fluidBlock)) {
                    LOGGER.warn(String.format("Unable to non-fluidloggable fluid: %s, skipping...", fluidName));
                    continue;
                }
                validFluids.add(fluid);
            }
            for (String id : this.fluidTags) {
                Set<Fluid> tag = FLUID_TAGS_CACHE.get(id);
                if (tag != null) {
                    validFluids.addAll(tag);
                    continue;
                }
                LOGGER.warn(String.format("Unable to parse tag from fluidTags: %s, skipping...", id));
            }
            return new ConfigPredicate(block, this.metadata.toIntArray(), validFluids);
        }

        public static void gatherStateMetadata(@Nonnull Block block, @Nonnull IntSet metadata, JsonObject ... serializedStates) {
            for (JsonObject stateJson : serializedStates) {
                ArrayList validProperties = new ArrayList();
                for (Map.Entry entry : stateJson.entrySet()) {
                    IProperty property = block.func_176194_O().func_185920_a((String)entry.getKey());
                    if (property != null) {
                        JsonElement validValuesJson = (JsonElement)entry.getValue();
                        HashSet<String> validValues = new HashSet<String>();
                        if (!validValuesJson.isJsonArray()) {
                            validValues.add(validValuesJson.getAsString());
                        } else {
                            validValuesJson.getAsJsonArray().forEach(element -> validValues.add(element.getAsString()));
                        }
                        validProperties.add((Map.Entry<IProperty<?>, String[]>)Pair.of((Object)property, (Object)validValues.toArray(new String[0])));
                        continue;
                    }
                    System.out.printf("Unable to parse block property for %s: \"%s\", skipping property...", block.getRegistryName(), entry.getKey());
                }
                if (validProperties.isEmpty()) continue;
                for (IBlockState state : block.func_176194_O().func_177619_a()) {
                    ConfigPredicateBuilder.gatherStateMetadataRecursively(validProperties, 0, (IProperty)((Map.Entry)validProperties.get(0)).getKey(), state, metadata);
                }
            }
        }

        static <T extends Comparable<T>> void gatherStateMetadataRecursively(@Nonnull List<Map.Entry<IProperty<?>, String[]>> validProperties, int propertyIndex, @Nonnull IProperty<T> property, @Nonnull IBlockState stateIn, @Nonnull IntSet metadata) {
            for (String valueStr : validProperties.get(propertyIndex).getValue()) {
                property.func_185929_b(valueStr).toJavaUtil().ifPresent(value -> {
                    IBlockState state = stateIn.func_177226_a(property, value);
                    if (propertyIndex + 1 == validProperties.size()) {
                        metadata.add(state.func_177230_c().func_176201_c(state));
                    } else {
                        ConfigPredicateBuilder.gatherStateMetadataRecursively(validProperties, propertyIndex + 1, (IProperty)((Map.Entry)validProperties.get(propertyIndex + 1)).getKey(), state, metadata);
                    }
                });
            }
        }
    }

    public static class ConfigPredicate
    implements BiPredicate<IBlockState, Fluid> {
        @Nonnull
        protected final Block block;
        @Nonnull
        protected final boolean[] metadata;
        @Nonnull
        protected final Set<Fluid> validFluids;

        public ConfigPredicate(@Nonnull Block block, @Nonnull int[] metadata, @Nonnull Set<Fluid> validFluids) {
            this.block = block;
            this.validFluids = validFluids;
            this.metadata = new boolean[metadata.length == 0 ? 0 : Ints.max((int[])metadata) + 1];
            for (int meta : metadata) {
                this.metadata[meta] = true;
            }
        }

        @Override
        public boolean test(@Nonnull IBlockState stateIn, @Nullable Fluid fluidIn) {
            if (fluidIn != null && !this.validFluids.isEmpty() && !this.validFluids.contains(fluidIn)) {
                return false;
            }
            if (this.metadata.length == 0) {
                return true;
            }
            int meta = this.block.func_176201_c(stateIn);
            return this.metadata.length > meta && this.metadata[meta];
        }
    }

    public static class FluidTag {
        @Nonnull
        protected final String id;
        @Nonnull
        protected final String[] fluids;

        public FluidTag(@Nonnull String id, @Nonnull String[] fluids) {
            this.id = id;
            this.fluids = fluids;
        }
    }

    public static class Config {
        public final int fluidloggedFluidSpread;
        public final boolean removeVerticalFluidloggedFluidSpread;
        public final boolean fluidsBreakTorches;
        public final boolean applyDefaults;
        @Nullable
        public final FluidTag[] fluidTags;
        public final ConfigPredicateBuilder[] whitelist;
        public final ConfigPredicateBuilder[] blacklist;
        public final boolean debugASMPlugins;
        public final boolean lavalogVaporizeFlammable;
        public final boolean fancyFluidEntityCollision;

        public Config(int fluidloggedFluidSpread, boolean removeVerticalFluidloggedFluidSpread, boolean fluidsBreakTorches, boolean applyDefaults, @Nullable FluidTag[] fluidTags, ConfigPredicateBuilder[] whitelist, ConfigPredicateBuilder[] blacklist, boolean debugASMPlugins, boolean lavalogVaporizeFlammable, boolean fancyFluidEntityCollision) {
            this.fluidloggedFluidSpread = fluidloggedFluidSpread;
            this.removeVerticalFluidloggedFluidSpread = removeVerticalFluidloggedFluidSpread;
            this.fluidsBreakTorches = fluidsBreakTorches;
            this.applyDefaults = applyDefaults;
            this.fluidTags = fluidTags;
            this.whitelist = whitelist;
            this.blacklist = blacklist;
            this.debugASMPlugins = debugASMPlugins;
            this.lavalogVaporizeFlammable = lavalogVaporizeFlammable;
            this.fancyFluidEntityCollision = fancyFluidEntityCollision;
        }
    }
}

