/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.subaquatic.api.biome;

import git.jbredwards.subaquatic.api.biome.IOceanSurfaceProvider;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import javax.annotation.Nonnull;
import net.minecraft.init.Biomes;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeManager;

public interface IOceanBiome
extends IOceanSurfaceProvider {
    @Nonnull
    public static final IntSet OCEAN_IDS = new IntOpenHashSet();
    @Nonnull
    public static final IntSet SHALLOW_OCEAN_IDS = new IntOpenHashSet(new int[]{0, 10});

    public int getDeepOceanBiomeId();

    @Nonnull
    public Biome getMixOceanBiome();

    public static boolean isOcean(int biome) {
        return OCEAN_IDS.contains(biome);
    }

    public static boolean isOcean(@Nonnull Biome biome) {
        return BiomeManager.oceanBiomes.contains(biome);
    }

    public static boolean isShallowOcean(int biome) {
        return SHALLOW_OCEAN_IDS.contains(biome);
    }

    public static boolean isShallowOcean(@Nonnull Biome biome) {
        return biome == Biomes.field_76771_b || biome instanceof IOceanBiome && ((IOceanBiome)biome).getDeepOceanBiomeId() != -1;
    }
}

