/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.subaquatic.api.event;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import net.minecraft.init.Biomes;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.fml.common.eventhandler.Cancelable;
import net.minecraftforge.fml.common.eventhandler.Event;

@Cancelable
public class GetOceanForGenEvent
extends Event {
    @Nonnull
    protected Biome oceanForGen;
    public final double temperatureNoise;

    public GetOceanForGenEvent(double temperatureNoiseIn) {
        this.temperatureNoise = temperatureNoiseIn;
        this.oceanForGen = Biomes.field_76771_b;
    }

    @Nonnull
    protected static Biome ensureIsOcean(@Nonnull Biome oceanForGenIn) {
        Preconditions.checkNotNull((Object)oceanForGenIn);
        Preconditions.checkArgument((boolean)BiomeManager.oceanBiomes.contains(oceanForGenIn), (String)"Biome for generation \"%s\" is not an ocean biome!", (Object)oceanForGenIn.getRegistryName());
        return oceanForGenIn;
    }

    @Nonnull
    public Biome getOcean() {
        return this.oceanForGen;
    }

    public void setOcean(@Nonnull Biome oceanForGenIn) {
        this.oceanForGen = GetOceanForGenEvent.ensureIsOcean(oceanForGenIn);
        this.setCanceled(true);
    }
}

