/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.subaquatic.api.event;

import git.jbredwards.fluidlogged_api.api.asm.impl.IFluidStatePrimer;
import git.jbredwards.fluidlogged_api.api.util.FluidState;
import git.jbredwards.fluidlogged_api.api.util.FluidloggedUtils;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraftforge.fml.common.eventhandler.Cancelable;
import net.minecraftforge.fml.common.eventhandler.Event;

@Cancelable
public class OnCreateChunkFromPrimerEvent
extends Event {
    @Nonnull
    public final Chunk chunk;
    @Nonnull
    public final ChunkPrimer primer;
    @Nonnull
    public final Random rand;
    @Nullable
    protected Biome[] biomesForGen = null;

    public OnCreateChunkFromPrimerEvent(@Nonnull Chunk chunkIn, @Nonnull ChunkPrimer primerIn) {
        this.chunk = chunkIn;
        this.primer = primerIn;
        long worldSeed = this.getWorld().func_72905_C();
        this.rand = new Random(worldSeed);
        long xSeed = this.rand.nextLong() >> 2 | 1L;
        long zSeed = this.rand.nextLong() >> 2 | 1L;
        this.rand.setSeed(xSeed * (long)this.getChunkX() + zSeed * (long)this.getChunkZ() ^ worldSeed);
    }

    public int getChunkX() {
        return this.chunk.field_76635_g;
    }

    public int getChunkZ() {
        return this.chunk.field_76647_h;
    }

    @Nonnull
    public World getWorld() {
        return this.chunk.func_177412_p();
    }

    @Nonnull
    public Biome getBiome(@Nonnull BlockPos pos) {
        if (this.isOutsideChunk(pos)) {
            return this.getWorld().func_180494_b(pos);
        }
        return this.getBiome(pos.func_177958_n() & 0xF, pos.func_177952_p() & 0xF);
    }

    @Nonnull
    public Biome getBiome(int x, int z) {
        return (this.biomesForGen != null ? this.biomesForGen : (this.biomesForGen = this.getWorld().func_72959_q().func_76933_b(null, this.getChunkX() << 4, this.getChunkZ() << 4, 16, 16)))[x << 4 | z];
    }

    @Nonnull
    public IBlockState getBlockState(@Nonnull BlockPos pos) {
        if (this.isOutsideChunk(pos)) {
            return this.getWorld().func_180495_p(pos);
        }
        return this.getWorld().func_189509_E(pos) ? ChunkPrimer.field_177859_b : this.primer.func_177856_a(pos.func_177958_n() & 0xF, pos.func_177956_o() & 0xFF, pos.func_177952_p() & 0xF);
    }

    public void setBlockState(@Nonnull BlockPos pos, @Nonnull IBlockState state) {
        if (this.isOutsideChunk(pos)) {
            this.getWorld().func_180501_a(pos, state, 16);
        } else if (!this.getWorld().func_189509_E(pos)) {
            this.primer.func_177855_a(pos.func_177958_n() & 0xF, pos.func_177956_o() & 0xFF, pos.func_177952_p() & 0xF, state);
        }
    }

    @Nonnull
    public FluidState getFluidState(@Nonnull BlockPos pos) {
        if (this.getWorld().func_189509_E(pos)) {
            return FluidState.EMPTY;
        }
        if (this.isOutsideChunk(pos)) {
            return FluidloggedUtils.getFluidState((IBlockAccess)this.getWorld(), (BlockPos)pos);
        }
        FluidState fluidState = IFluidStatePrimer.of((Object)this.primer).getFluidState(pos.func_177958_n() & 0xF, pos.func_177956_o() & 0xFF, pos.func_177952_p() & 0xF);
        if (!fluidState.isEmpty()) {
            return fluidState;
        }
        return FluidState.of((IBlockState)this.primer.func_177856_a(pos.func_177958_n() & 0xF, pos.func_177956_o() & 0xFF, pos.func_177952_p() & 0xF));
    }

    public void setFluidState(@Nonnull BlockPos pos, @Nonnull FluidState fluidState) {
        if (this.isOutsideChunk(pos)) {
            FluidloggedUtils.setFluidState((World)this.getWorld(), (BlockPos)pos, null, (FluidState)fluidState, (boolean)false, (boolean)false, (int)16);
        } else if (!this.getWorld().func_189509_E(pos)) {
            IFluidStatePrimer.of((Object)this.primer).setFluidState(pos.func_177958_n() & 0xF, pos.func_177956_o() & 0xFF, pos.func_177952_p() & 0xF, fluidState);
        }
    }

    public int findTopSolidNonLiquidBlock(int x, int z) {
        int groundIndex;
        for (int y = groundIndex = this.primer.func_186138_a(x, z); y >= 0; --y) {
            IBlockState state = this.primer.func_177856_a(x, y, z);
            if (!state.func_185904_a().func_76230_c() || FluidloggedUtils.isFluid((IBlockState)state)) continue;
            BlockPos pos = this.getPos(x, y, z);
            if (state.func_177230_c().isLeaves(state, (IBlockAccess)this.getWorld(), pos) || state.func_177230_c().isFoliage((IBlockAccess)this.getWorld(), pos)) continue;
            return y + 1;
        }
        return groundIndex;
    }

    @Nonnull
    public BlockPos getPos(int x, int y, int z) {
        return new BlockPos(this.getChunkX() << 4 | x, y, this.getChunkZ() << 4 | z);
    }

    public boolean isOutsideChunk(@Nonnull BlockPos pos) {
        return !this.chunk.func_76600_a(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
    }
}

