/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.subaquatic.api.event;

import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.Cancelable;
import net.minecraftforge.fml.common.eventhandler.Event;

@Cancelable
public class OnGetEntityFromFishingEvent
extends Event {
    @Nonnull
    public final ItemStack itemToFish;
    @Nonnull
    public final EntityFishHook hook;
    @Nonnull
    public final EntityPlayer player;
    public int rodDamage;
    public int compactFishingLvl;

    public OnGetEntityFromFishingEvent(@Nonnull ItemStack itemToFishIn, @Nonnull EntityFishHook hookIn, int rodDamageIn, int compactFishingLvlIn) {
        this.itemToFish = itemToFishIn;
        this.hook = hookIn;
        this.player = hookIn.func_190619_l();
        this.rodDamage = rodDamageIn;
        this.compactFishingLvl = compactFishingLvlIn;
    }

    public void spawnEntityOrTryCompact(@Nonnull Entity entity) {
        if (this.compactFishingLvl != 0 && entity instanceof EntityLivingBase) {
            float maxHealth = ((EntityLivingBase)entity).func_110138_aP();
            int maxDamage = (1 << this.compactFishingLvl) + 1;
            this.rodDamage += Math.min(this.compactFishingLvl, MathHelper.func_76143_f((double)Math.log(maxHealth)));
            if (maxHealth > (float)maxDamage) {
                this.spawnEntity(entity, maxDamage);
            }
        } else {
            this.spawnEntity(entity, 1);
        }
    }

    public void spawnEntity(@Nonnull Entity entity, int damageDealt) {
        entity.func_70107_b(this.hook.field_70165_t, this.hook.field_70163_u, this.hook.field_70161_v);
        if (this.getWorld().func_72838_d(entity)) {
            if (damageDealt > 0) {
                entity.func_70097_a(DamageSource.func_188403_a((Entity)this.hook, (EntityLivingBase)this.player), (float)damageDealt);
            }
            this.applyMotion(entity);
            this.setCanceled(true);
            if (entity instanceof EntityLiving) {
                this.player.func_71064_a(StatList.field_188071_E, 1);
            }
        }
    }

    public void applyMotion(@Nonnull Entity entity) {
        double diffX = (this.player.field_70165_t - this.hook.field_70165_t) * 0.125;
        double diffY = (this.player.field_70163_u - this.hook.field_70163_u) * 0.125;
        double diffZ = (this.player.field_70161_v - this.hook.field_70161_v) * 0.125;
        entity.field_70159_w = diffX;
        entity.field_70181_x = diffY + Math.pow(diffX * diffX + diffY * diffY + diffZ * diffZ, 0.25) * 0.5;
        entity.field_70179_y = diffZ;
    }

    @Nonnull
    public World getWorld() {
        return this.hook.func_130014_f_();
    }
}

