/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.subaquatic.mod;

import com.cleanroommc.assetmover.AssetMoverAPI;
import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import git.jbredwards.fluidlogged_api.api.util.FluidloggedUtils;
import git.jbredwards.subaquatic.api.biome.IOceanBiome;
import git.jbredwards.subaquatic.mod.client.entity.renderer.RenderBoatContainer;
import git.jbredwards.subaquatic.mod.client.entity.renderer.RenderCod;
import git.jbredwards.subaquatic.mod.client.entity.renderer.RenderFish;
import git.jbredwards.subaquatic.mod.client.entity.renderer.RenderPufferfish;
import git.jbredwards.subaquatic.mod.client.entity.renderer.RenderSalmon;
import git.jbredwards.subaquatic.mod.client.entity.renderer.RenderTranslucentXPOrb;
import git.jbredwards.subaquatic.mod.client.entity.renderer.RenderTropicalFish;
import git.jbredwards.subaquatic.mod.client.particle.factory.ParticleFactoryColorize;
import git.jbredwards.subaquatic.mod.common.capability.IBoatType;
import git.jbredwards.subaquatic.mod.common.capability.IBubbleColumn;
import git.jbredwards.subaquatic.mod.common.capability.ICompactFishing;
import git.jbredwards.subaquatic.mod.common.capability.IEntityBucket;
import git.jbredwards.subaquatic.mod.common.compat.inspirations.InspirationsHandler;
import git.jbredwards.subaquatic.mod.common.config.SubaquaticBlockSoakRecipesConfig;
import git.jbredwards.subaquatic.mod.common.config.SubaquaticConfigHandler;
import git.jbredwards.subaquatic.mod.common.config.SubaquaticTropicalFishConfig;
import git.jbredwards.subaquatic.mod.common.config.SubaquaticWaterColorConfig;
import git.jbredwards.subaquatic.mod.common.entity.item.AbstractBoatContainer;
import git.jbredwards.subaquatic.mod.common.entity.item.part.MultiPartAbstractInventoryPart;
import git.jbredwards.subaquatic.mod.common.entity.living.EntityCod;
import git.jbredwards.subaquatic.mod.common.entity.living.EntityFish;
import git.jbredwards.subaquatic.mod.common.entity.living.EntityPufferfish;
import git.jbredwards.subaquatic.mod.common.entity.living.EntitySalmon;
import git.jbredwards.subaquatic.mod.common.entity.living.EntityTropicalFish;
import git.jbredwards.subaquatic.mod.common.init.SubaquaticSounds;
import git.jbredwards.subaquatic.mod.common.message.CMessageOpenBoatInventory;
import git.jbredwards.subaquatic.mod.common.message.SMessageAbstractChestPart;
import git.jbredwards.subaquatic.mod.common.message.SMessageBoatType;
import git.jbredwards.subaquatic.mod.common.message.SMessageBottleParticles;
import git.jbredwards.subaquatic.mod.common.message.SMessageFurnacePart;
import git.jbredwards.subaquatic.mod.common.recipe.BlockSoakRecipe;
import git.jbredwards.subaquatic.mod.common.world.biome.BiomeFrozenOcean;
import git.jbredwards.subaquatic.mod.common.world.gen.feature.GeneratorCoral;
import git.jbredwards.subaquatic.mod.common.world.gen.feature.GeneratorGlowLichen;
import git.jbredwards.subaquatic.mod.common.world.gen.feature.GeneratorKelp;
import git.jbredwards.subaquatic.mod.common.world.gen.feature.GeneratorSeaPickle;
import git.jbredwards.subaquatic.mod.common.world.gen.feature.GeneratorSeagrass;
import git.jbredwards.subaquatic.mod.common.world.gen.layer.GenLayerOceanBiomes;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.init.Biomes;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraft.world.gen.structure.StructureOceanMonument;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="subaquatic", name="Subaquatic", version="1.2.1", dependencies="required-after:fluidlogged_api@[2.2.5,);required-client:assetmover@[2.5,);", acceptedMinecraftVersions="[1.12.2]")
public final class Subaquatic {
    @Nonnull
    public static final String MODID = "subaquatic";
    @Nonnull
    public static final String NAME = "Subaquatic";
    @Nonnull
    public static final Logger LOGGER = LogManager.getFormatterLogger((String)"Subaquatic");
    @Nonnull
    public static SimpleNetworkWrapper WRAPPER;
    public static final boolean isInspirationsInstalled;

    @Mod.EventHandler
    @SideOnly(value=Side.CLIENT)
    static void constructClient(@Nonnull FMLConstructionEvent event) {
        String[][] assets;
        LOGGER.info("Reading vanilla assets required by this mod...");
        for (String[] asset : assets = (String[][])new Gson().fromJson((Reader)new InputStreamReader(Objects.requireNonNull(Loader.class.getResourceAsStream(String.format("/assets/%s/assetmover.jsonc", MODID)))), String[][].class)) {
            AssetMoverAPI.fromMinecraft((String)asset[0], Collections.singletonMap(asset[1], asset[2]));
        }
        LOGGER.info("Success!");
    }

    @Mod.EventHandler
    static void preInit(@Nonnull FMLPreInitializationEvent event) throws IOException {
        SubaquaticTropicalFishConfig.buildFishTypes();
        CapabilityManager.INSTANCE.register(IBubbleColumn.class, (Capability.IStorage)IBubbleColumn.Storage.INSTANCE, IBubbleColumn.Impl::new);
        CapabilityManager.INSTANCE.register(IBoatType.class, (Capability.IStorage)IBoatType.Storage.INSTANCE, IBoatType.Impl::new);
        CapabilityManager.INSTANCE.register(ICompactFishing.class, (Capability.IStorage)ICompactFishing.Storage.INSTANCE, ICompactFishing.Impl::new);
        CapabilityManager.INSTANCE.register(IEntityBucket.class, (Capability.IStorage)IEntityBucket.Storage.INSTANCE, IEntityBucket.Impl::new);
        MinecraftForge.EVENT_BUS.register(IBubbleColumn.class);
        MinecraftForge.EVENT_BUS.register(IBoatType.class);
        MinecraftForge.EVENT_BUS.register(ICompactFishing.class);
        MinecraftForge.EVENT_BUS.register(IEntityBucket.class);
        WRAPPER = NetworkRegistry.INSTANCE.newSimpleChannel(MODID);
        WRAPPER.registerMessage((IMessageHandler)SMessageBoatType.Handler.INSTANCE, SMessageBoatType.class, 0, Side.CLIENT);
        WRAPPER.registerMessage((IMessageHandler)SMessageAbstractChestPart.Handler.INSTANCE, SMessageAbstractChestPart.class, 1, Side.CLIENT);
        WRAPPER.registerMessage((IMessageHandler)CMessageOpenBoatInventory.Handler.INSTANCE, CMessageOpenBoatInventory.class, 2, Side.SERVER);
        WRAPPER.registerMessage((IMessageHandler)SMessageFurnacePart.Handler.INSTANCE, SMessageFurnacePart.class, 3, Side.CLIENT);
        WRAPPER.registerMessage((IMessageHandler)SMessageBottleParticles.Handler.INSTANCE, SMessageBottleParticles.class, 4, Side.CLIENT);
        GeneratorCoral.registerDefaults();
        GameRegistry.registerWorldGenerator((IWorldGenerator)GeneratorCoral.INSTANCE, (int)3);
        GameRegistry.registerWorldGenerator((IWorldGenerator)GeneratorKelp.INSTANCE, (int)4);
        GameRegistry.registerWorldGenerator((IWorldGenerator)GeneratorSeagrass.INSTANCE, (int)5);
        GameRegistry.registerWorldGenerator((IWorldGenerator)GeneratorSeaPickle.INSTANCE, (int)6);
        GameRegistry.registerWorldGenerator((IWorldGenerator)GeneratorGlowLichen.INSTANCE, (int)6);
        IItemPropertyGetter waterProperty = new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(@Nonnull ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                return SubaquaticConfigHandler.Client.Item.translucentWaterBottles && PotionUtils.func_185191_c((ItemStack)stack) != PotionTypes.field_185229_a && PotionUtils.func_185189_a((ItemStack)stack).isEmpty() ? 1.0f : 0.0f;
            }
        };
        Items.field_151068_bn.func_185043_a(new ResourceLocation(MODID, "isWater"), waterProperty);
        Items.field_185155_bH.func_185043_a(new ResourceLocation(MODID, "isWater"), waterProperty);
        Items.field_185156_bI.func_185043_a(new ResourceLocation(MODID, "isWater"), waterProperty);
    }

    @Mod.EventHandler
    @SideOnly(value=Side.CLIENT)
    static void preInitClient(@Nonnull FMLPreInitializationEvent event) {
        RenderingRegistry.registerEntityRenderingHandler(AbstractBoatContainer.class, RenderBoatContainer::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityCod.class, RenderCod::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityFish.class, RenderFish::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityPufferfish.class, RenderPufferfish::new);
        RenderingRegistry.registerEntityRenderingHandler(EntitySalmon.class, RenderSalmon::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityTropicalFish.class, RenderTropicalFish::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityXPOrb.class, RenderTranslucentXPOrb::new);
        if (isInspirationsInstalled) {
            MinecraftForge.EVENT_BUS.register(InspirationsHandler.class);
        }
    }

    @Mod.EventHandler
    static void init(@Nonnull FMLInitializationEvent event) {
        MinecraftForge.TERRAIN_GEN_BUS.register(GenLayerOceanBiomes.class);
        AbstractBoatContainer.registerFixer((DataFixer)FMLCommonHandler.instance().getDataFixer());
        MultiPartAbstractInventoryPart.registerFixer((DataFixer)FMLCommonHandler.instance().getDataFixer());
        ForgeRegistries.BIOMES.forEach(biome -> {
            if (biome instanceof IOceanBiome) {
                BiomeManager.oceanBiomes.add(biome);
            }
        });
        BiomeManager.oceanBiomes.forEach(biome -> {
            int biomeId = Biome.func_185362_a((Biome)biome);
            IOceanBiome.OCEAN_IDS.add(biomeId);
            if (biome instanceof IOceanBiome && ((IOceanBiome)biome).getDeepOceanBiomeId() != -1) {
                IOceanBiome.SHALLOW_OCEAN_IDS.add(biomeId);
            }
        });
        StructureOceanMonument.field_186134_b = new ArrayList(ImmutableList.builder().add((Object)Biomes.field_150575_M).addAll((Iterable)BiomeManager.oceanBiomes.stream().filter(biome -> biome instanceof IOceanBiome && ((IOceanBiome)biome).getDeepOceanBiomeId() == -1).collect(Collectors.toList())).build());
        StructureOceanMonument.field_175802_d = new ArrayList(ImmutableList.builder().addAll((Iterable)BiomeManager.oceanBiomes).addAll((Iterable)BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.RIVER)).build());
        StructureOceanMonument.field_186134_b.removeIf(biome -> biome instanceof BiomeFrozenOcean);
        BlockDispenser.field_149943_a.func_82595_a((Object)Items.field_151068_bn, (Object)BlockSoakRecipe.getDispenserHandler());
    }

    @Mod.EventHandler
    @SideOnly(value=Side.SERVER)
    static void initServer(@Nonnull FMLInitializationEvent event) {
        FluidRegistry.WATER.setColor(-12609564);
    }

    @Mod.EventHandler
    static void postInit(@Nonnull FMLPostInitializationEvent event) throws IOException {
        SubaquaticConfigHandler.init();
        SubaquaticWaterColorConfig.buildWaterColors();
        SubaquaticBlockSoakRecipesConfig.buildRecipes();
        Optional.ofNullable(Block.func_149684_b((String)"biomesoplenty:waterlily")).ifPresent(block -> block.func_149672_a(SubaquaticSounds.WET_GRASS));
        Optional.ofNullable(Block.func_149684_b((String)"twilightforest:huge_lilypad")).ifPresent(block -> block.func_149672_a(SubaquaticSounds.WET_GRASS));
        Optional.ofNullable(Block.func_149684_b((String)"twilightforest:huge_waterlily")).ifPresent(block -> block.func_149672_a(SubaquaticSounds.WET_GRASS));
    }

    @Mod.EventHandler
    @SideOnly(value=Side.CLIENT)
    static void postInitClient(@Nonnull FMLPostInitializationEvent event) {
        ParticleManager manager = Minecraft.func_71410_x().field_71452_i;
        manager.func_178929_a(EnumParticleTypes.DRIP_WATER.func_179348_c(), (IParticleFactory)new ParticleFactoryColorize((IParticleFactory)manager.field_178932_g.get(EnumParticleTypes.DRIP_WATER.func_179348_c()), isInspirationsInstalled ? InspirationsHandler::getCauldronColor : BiomeColorHelper::func_180288_c));
        manager.func_178929_a(EnumParticleTypes.SUSPENDED.func_179348_c(), (IParticleFactory)new ParticleFactoryColorize((IParticleFactory)manager.field_178932_g.get(EnumParticleTypes.SUSPENDED.func_179348_c()), isInspirationsInstalled ? InspirationsHandler::getCauldronColor : BiomeColorHelper::func_180288_c));
        manager.func_178929_a(EnumParticleTypes.WATER_BUBBLE.func_179348_c(), (IParticleFactory)new ParticleFactoryColorize((IParticleFactory)manager.field_178932_g.get(EnumParticleTypes.WATER_BUBBLE.func_179348_c()), isInspirationsInstalled ? InspirationsHandler::getParticleColorAt : SubaquaticWaterColorConfig::getParticleColorAt));
        manager.func_178929_a(EnumParticleTypes.WATER_DROP.func_179348_c(), (IParticleFactory)new ParticleFactoryColorize((IParticleFactory)manager.field_178932_g.get(EnumParticleTypes.WATER_DROP.func_179348_c()), isInspirationsInstalled ? InspirationsHandler::getParticleColorAt : SubaquaticWaterColorConfig::getParticleColorAt));
        manager.func_178929_a(EnumParticleTypes.WATER_SPLASH.func_179348_c(), (IParticleFactory)new ParticleFactoryColorize((IParticleFactory)manager.field_178932_g.get(EnumParticleTypes.WATER_SPLASH.func_179348_c()), isInspirationsInstalled ? InspirationsHandler::getParticleColorAt : SubaquaticWaterColorConfig::getParticleColorAt));
        manager.func_178929_a(EnumParticleTypes.WATER_WAKE.func_179348_c(), (IParticleFactory)new ParticleFactoryColorize((IParticleFactory)manager.field_178932_g.get(EnumParticleTypes.WATER_WAKE.func_179348_c()), isInspirationsInstalled ? InspirationsHandler::getParticleColorAt : SubaquaticWaterColorConfig::getParticleColorAt));
        IParticleFactory bubbleFactory = (IParticleFactory)manager.field_178932_g.get(EnumParticleTypes.WATER_BUBBLE.func_179348_c());
        manager.func_178929_a(EnumParticleTypes.WATER_BUBBLE.func_179348_c(), (particleID, world, x, y, z, xSpeed, ySpeed, zSpeed, args) -> {
            Particle particle = bubbleFactory.func_178902_a(particleID, world, x, y, z, xSpeed, ySpeed, zSpeed, args);
            if (particle == null) {
                return null;
            }
            BlockPos pos = new BlockPos(x, y, z);
            AxisAlignedBB box = particle.func_187116_l();
            AxisAlignedBB boxToCheck = new AxisAlignedBB(box.field_72340_a, box.field_72337_e, box.field_72339_c, box.field_72336_d, box.field_72337_e, box.field_72339_c);
            if (!Boolean.TRUE.equals(FluidloggedUtils.getFluidOrReal((IBlockAccess)world, (BlockPos)pos).func_177230_c().isAABBInsideMaterial(world, pos, boxToCheck, Material.field_151586_h))) {
                return null;
            }
            if (SubaquaticConfigHandler.Client.Particle.longerLastingBubbles) {
                particle.func_187114_a(particle.field_70547_e * 5);
            }
            return particle;
        });
    }

    static {
        isInspirationsInstalled = Loader.isModLoaded((String)"inspirations");
    }
}

