/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.subaquatic.mod.asm.plugin.forge;

import git.jbredwards.fluidlogged_api.api.asm.IASMPlugin;
import git.jbredwards.subaquatic.mod.common.capability.IEntityBucket;
import git.jbredwards.subaquatic.mod.common.entity.util.fish_bucket.IBucketableEntity;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public final class PluginFluidUtil
implements IASMPlugin {
    public boolean isMethodValid(@Nonnull MethodNode method, boolean obfuscated) {
        return this.checkMethod(method, "tryPlaceFluid", "(Lnet/minecraft/entity/player/EntityPlayer;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraftforge/fluids/capability/IFluidHandler;Lnet/minecraftforge/fluids/FluidStack;)Z");
    }

    public boolean transform(@Nonnull InsnList instructions, @Nonnull MethodNode method, @Nonnull AbstractInsnNode insn, boolean obfuscated, int index) {
        if (this.checkMethod(insn, obfuscated ? "func_177500_n" : "doesWaterVaporize")) {
            instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 3));
            instructions.insertBefore(insn, (AbstractInsnNode)this.genMethodNode("doesWaterVaporize", "(Lnet/minecraft/world/WorldProvider;Lnet/minecraftforge/fluids/capability/IFluidHandler;)Z"));
            instructions.remove(insn);
        } else if (this.checkMethod(insn, "vaporize")) {
            InsnList list = new InsnList();
            list.add((AbstractInsnNode)new VarInsnNode(25, 1));
            list.add((AbstractInsnNode)new VarInsnNode(25, 2));
            list.add((AbstractInsnNode)this.genMethodNode("placeFish", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;)V"));
            instructions.insert(insn, list);
        } else if (this.checkMethod(insn.getPrevious(), "getEmptySound")) {
            InsnList list = new InsnList();
            list.add((AbstractInsnNode)new VarInsnNode(25, 1));
            list.add((AbstractInsnNode)new VarInsnNode(25, 2));
            list.add((AbstractInsnNode)this.genMethodNode("placeFish", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;)V"));
            instructions.insert(insn, list);
            return true;
        }
        return false;
    }

    public static final class Hooks {
        @Nonnull
        private static ItemStack filledBucket = ItemStack.field_190927_a;

        public static boolean doesWaterVaporize(@Nonnull WorldProvider provider, @Nonnull IFluidHandler handler) {
            if (handler instanceof IFluidHandlerItem) {
                filledBucket = ((IFluidHandlerItem)handler).getContainer();
            }
            return provider.func_177500_n();
        }

        public static void placeFish(@Nonnull World world, @Nonnull BlockPos pos) {
            IEntityBucket cap = IEntityBucket.get((ICapabilityProvider)filledBucket);
            if (cap != null) {
                IBucketableEntity.placeCapturedEntity(world, pos, filledBucket, cap.getHandler());
            }
        }
    }
}

