/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.subaquatic.mod.asm.plugin.forge;

import git.jbredwards.fluidlogged_api.api.asm.IASMPlugin;
import git.jbredwards.subaquatic.api.entity.IConditionalProfession;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public final class PluginVillagerRegistry
implements IASMPlugin {
    public boolean isMethodValid(@Nonnull MethodNode method, boolean obfuscated) {
        return method.name.equals("setRandomProfession");
    }

    public boolean transform(@Nonnull InsnList instructions, @Nonnull MethodNode method, @Nonnull AbstractInsnNode insn, boolean obfuscated, int index) {
        if (this.checkMethod(insn, obfuscated ? "func_186801_a" : "getRandomObject")) {
            instructions.insert(insn, (AbstractInsnNode)this.genMethodNode("checkIsProfessionEnabled", "(Ljava/lang/Object;Lnet/minecraft/entity/Entity;Ljava/util/Random;)Ljava/lang/Object;"));
            instructions.insert(insn, (AbstractInsnNode)new VarInsnNode(25, 1));
            instructions.insert(insn, (AbstractInsnNode)new VarInsnNode(25, 0));
            return true;
        }
        return false;
    }

    public static final class Hooks {
        @Nonnull
        public static Object checkIsProfessionEnabled(@Nonnull Object profession, @Nonnull Entity entity, @Nonnull Random rand) {
            if (profession instanceof IConditionalProfession && !((IConditionalProfession)profession).isProfessionApplicableTo(entity)) {
                VillagerRegistry.VillagerProfession[] professions = (VillagerRegistry.VillagerProfession[])ForgeRegistries.VILLAGER_PROFESSIONS.getValuesCollection().stream().filter(p -> !(p instanceof IConditionalProfession) || ((IConditionalProfession)p).isProfessionApplicableTo(entity)).toArray(VillagerRegistry.VillagerProfession[]::new);
                return professions[rand.nextInt(professions.length)];
            }
            return profession;
        }
    }
}

