/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.subaquatic.mod.asm.plugin.modded;

import git.jbredwards.fluidlogged_api.api.asm.IASMPlugin;
import git.jbredwards.subaquatic.mod.common.capability.IEntityBucket;
import git.jbredwards.subaquatic.mod.common.entity.util.fish_bucket.IBucketableEntity;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public final class PluginFluidloggedAPI
implements IASMPlugin {
    public boolean isMethodValid(@Nonnull MethodNode method, boolean obfuscated) {
        return method.name.equals("tryBucketDrain");
    }

    public boolean transform(@Nonnull InsnList instructions, @Nonnull MethodNode method, @Nonnull AbstractInsnNode insn, boolean obfuscated, int index) {
        if (this.checkMethod(insn, "drain")) {
            instructions.insert(insn, (AbstractInsnNode)this.genMethodNode("drainAndPlaceFish", "(Lnet/minecraftforge/fluids/capability/IFluidHandlerItem;Lnet/minecraftforge/fluids/FluidStack;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;)Lnet/minecraftforge/fluids/FluidStack;"));
            instructions.insert(insn, (AbstractInsnNode)new VarInsnNode(25, 1));
            instructions.insert(insn, (AbstractInsnNode)new VarInsnNode(25, 0));
            this.removeFrom(instructions, insn, -1);
            return true;
        }
        return false;
    }

    public static final class Hooks {
        @Nullable
        public static FluidStack drainAndPlaceFish(@Nonnull IFluidHandlerItem handler, @Nonnull FluidStack stack, @Nonnull World world, @Nonnull BlockPos pos) {
            IEntityBucket cap;
            ItemStack bucket = handler.getContainer();
            FluidStack result = handler.drain(stack, true);
            if (result != null && (cap = IEntityBucket.get((ICapabilityProvider)bucket)) != null) {
                IBucketableEntity.placeCapturedEntity(world, pos, bucket, cap.getHandler());
            }
            return result;
        }
    }
}

