/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.subaquatic.mod.asm.plugin.vanilla.block;

import git.jbredwards.fluidlogged_api.api.asm.IASMPlugin;
import git.jbredwards.fluidlogged_api.api.util.FluidloggedUtils;
import git.jbredwards.subaquatic.mod.common.config.SubaquaticConfigHandler;
import git.jbredwards.subaquatic.mod.common.config.SubaquaticWaterColorConfig;
import git.jbredwards.subaquatic.mod.common.init.SubaquaticBlocks;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public final class PluginBlock
implements IASMPlugin {
    public boolean isMethodValid(@Nonnull MethodNode method, boolean obfuscated) {
        return method.name.equals("getFogColor");
    }

    public boolean transform(@Nonnull InsnList instructions, @Nonnull MethodNode method, @Nonnull AbstractInsnNode insn, boolean obfuscated, int index) {
        if (insn.getOpcode() == 187) {
            instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 1));
            instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 2));
            instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(23, 7));
            instructions.insertBefore(insn, (AbstractInsnNode)this.genMethodNode("betterWaterFogColor", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;F)Lnet/minecraft/util/math/Vec3d;"));
            this.removeFrom(instructions, insn, 14);
            return true;
        }
        return false;
    }

    public boolean transformClass(@Nonnull ClassNode classNode, boolean obfuscated) {
        this.overrideMethod(classNode, method -> method.name.equals("onPlantGrow"), "onPlantGrow", "(Lnet/minecraft/block/Block;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;)V", generator -> {
            generator.visitVarInsn(25, 0);
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
            generator.visitVarInsn(25, 3);
        });
        return true;
    }

    public static final class Hooks {
        @Nonnull
        public static Vec3d betterWaterFogColor(@Nonnull World world, @Nonnull BlockPos origin, float modifier) {
            float[] components = SubaquaticWaterColorConfig.getFogColorAt((IBlockAccess)world, origin);
            return new Vec3d((double)Math.min(1.0f, components[0] + modifier), (double)Math.min(1.0f, components[1] + modifier), (double)Math.min(1.0f, components[2] + modifier));
        }

        public static void onPlantGrow(@Nonnull Block block, @Nonnull IBlockState state, @Nonnull World world, @Nonnull BlockPos pos) {
            if (state.func_185904_a() == Material.field_151578_c || state.func_185904_a() == Material.field_151577_b || state.func_177230_c().isAir(state, (IBlockAccess)world, pos)) {
                if (SubaquaticConfigHandler.Server.World.General.generateRootedDirt) {
                    world.func_180501_a(pos, SubaquaticBlocks.ROOTED_DIRT.func_176223_P(), 2);
                    IBlockState down = world.func_180495_p(pos.func_177977_b());
                    if (down != state && down.func_185904_a() == Material.field_151577_b) {
                        down.func_177230_c().onPlantGrow(down, world, pos.func_177977_b(), pos);
                    } else if (down.func_177230_c().isAir(down, (IBlockAccess)world, pos.func_177977_b()) || FluidloggedUtils.isFluid((IBlockState)down)) {
                        world.func_180501_a(pos.func_177977_b(), SubaquaticBlocks.HANGING_ROOTS.func_176223_P(), 2);
                    }
                } else if (state != Blocks.field_150346_d.func_176223_P()) {
                    world.func_180501_a(pos, Blocks.field_150346_d.func_176223_P(), 2);
                }
            } else if (FluidloggedUtils.isFluid((IBlockState)state)) {
                world.func_180501_a(pos.func_177977_b(), SubaquaticBlocks.HANGING_ROOTS.func_176223_P(), 2);
            }
        }
    }
}

