/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.subaquatic.mod.asm.plugin.vanilla.block;

import git.jbredwards.fluidlogged_api.api.asm.IASMPlugin;
import git.jbredwards.subaquatic.mod.Subaquatic;
import git.jbredwards.subaquatic.mod.common.capability.IEntityBucket;
import git.jbredwards.subaquatic.mod.common.compat.inspirations.InspirationsHandler;
import git.jbredwards.subaquatic.mod.common.config.SubaquaticConfigHandler;
import git.jbredwards.subaquatic.mod.common.entity.util.fish_bucket.IBucketableEntity;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCauldron;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public final class PluginBlockCauldron
implements IASMPlugin {
    public boolean isMethodValid(@Nonnull MethodNode method, boolean obfuscated) {
        return method.name.equals(obfuscated ? "func_180639_a" : "onBlockActivated");
    }

    public boolean transform(@Nonnull InsnList instructions, @Nonnull MethodNode method, @Nonnull AbstractInsnNode insn, boolean obfuscated, int index) {
        if (this.checkMethod(insn, obfuscated ? "func_176590_a" : "setWaterLevel")) {
            InsnList list = new InsnList();
            list.add((AbstractInsnNode)new VarInsnNode(25, 1));
            list.add((AbstractInsnNode)new VarInsnNode(25, 2));
            list.add((AbstractInsnNode)new VarInsnNode(25, 10));
            list.add((AbstractInsnNode)this.genMethodNode("placeCapturedEntity", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/item/ItemStack;)V"));
            instructions.insert(insn, list);
            return true;
        }
        return false;
    }

    public boolean transformClass(@Nonnull ClassNode classNode, boolean obfuscated) {
        this.addMethod(classNode, "canRenderInLayer", "(Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/util/BlockRenderLayer;)Z", "canCauldronRenderInLayer", "(Lnet/minecraft/block/Block;Lnet/minecraft/util/BlockRenderLayer;)Z", generator -> {
            generator.visitVarInsn(25, 0);
            generator.visitVarInsn(25, 2);
        });
        this.addMethod(classNode, "isEntityInsideMaterial", "(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/entity/Entity;DLnet/minecraft/block/material/Material;Z)Ljava/lang/Boolean;", "isEntityInsideCauldronMaterial", "(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/entity/Entity;DLnet/minecraft/block/material/Material;Z)Ljava/lang/Boolean;", generator -> {
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
            generator.visitVarInsn(25, 3);
            generator.visitVarInsn(25, 4);
            generator.visitVarInsn(24, 5);
            generator.visitVarInsn(25, 7);
            generator.visitVarInsn(21, 8);
        });
        this.addMethod(classNode, "isAABBInsideMaterial", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/math/AxisAlignedBB;Lnet/minecraft/block/material/Material;)Ljava/lang/Boolean;", "isAABBInsideCauldronMaterial", "(Lnet/minecraft/block/Block;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/math/AxisAlignedBB;Lnet/minecraft/block/material/Material;)Ljava/lang/Boolean;", generator -> {
            generator.visitVarInsn(25, 0);
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
            generator.visitVarInsn(25, 3);
            generator.visitVarInsn(25, 4);
        });
        this.addMethod(classNode, "isAABBInsideLiquid", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/math/AxisAlignedBB;)Ljava/lang/Boolean;", "isAABBInsideCauldronLiquid", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/math/AxisAlignedBB;)Ljava/lang/Boolean;", generator -> {
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
            generator.visitVarInsn(25, 3);
        });
        return true;
    }

    public boolean recalcFrames(boolean obfuscated) {
        return true;
    }

    public static final class Hooks {
        public static boolean canCauldronRenderInLayer(@Nonnull Block block, @Nonnull BlockRenderLayer layer) {
            return block == Blocks.field_150383_bp && layer == BlockRenderLayer.TRANSLUCENT || block.func_180664_k() == layer;
        }

        @Nullable
        public static Boolean isEntityInsideCauldronMaterial(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull Entity entity, double yToTest, @Nonnull Material materialIn, boolean testingHead) {
            if (!SubaquaticConfigHandler.Common.Block.cauldronFluidPhysics || state.func_177230_c() != Blocks.field_150383_bp || !Hooks.doesCauldronHaveFluid(materialIn, world, pos)) {
                return null;
            }
            int level = (Integer)state.func_177229_b((IProperty)BlockCauldron.field_176591_a);
            if (!testingHead) {
                yToTest = entity.field_70163_u;
            }
            return level > 0 && yToTest < (double)pos.func_177956_o() + Hooks.getFluidHeight(level);
        }

        @Nullable
        public static Boolean isAABBInsideCauldronMaterial(@Nonnull Block block, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull AxisAlignedBB boundingBox, @Nonnull Material materialIn) {
            return !SubaquaticConfigHandler.Common.Block.cauldronFluidPhysics || block != Blocks.field_150383_bp || !Hooks.doesCauldronHaveFluid(materialIn, (IBlockAccess)world, pos) ? null : block.isAABBInsideLiquid(world, pos, boundingBox);
        }

        @Nullable
        public static Boolean isAABBInsideCauldronLiquid(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull AxisAlignedBB boundingBox) {
            if (!SubaquaticConfigHandler.Common.Block.cauldronFluidPhysics) {
                return null;
            }
            int level = (Integer)world.func_180495_p(pos).func_177229_b((IProperty)BlockCauldron.field_176591_a);
            return level > 0 && boundingBox.field_72338_b < (double)pos.func_177956_o() + Hooks.getFluidHeight(level);
        }

        public static void placeCapturedEntity(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull ItemStack stack) {
            IEntityBucket cap = IEntityBucket.get((ICapabilityProvider)stack);
            if (cap != null) {
                IBucketableEntity.placeCapturedEntity(world, pos, stack, cap.getHandler());
            }
        }

        public static boolean doesCauldronHaveFluid(@Nonnull Material material, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
            return Subaquatic.isInspirationsInstalled ? InspirationsHandler.doesCauldronHaveMaterial(material, world, pos) : material == Material.field_151586_h;
        }

        public static double getFluidHeight(int level) {
            return (double)level * 0.1875 + 0.375;
        }
    }
}

