/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.subaquatic.mod.asm.plugin.vanilla.block;

import git.jbredwards.fluidlogged_api.api.asm.IASMPlugin;
import git.jbredwards.fluidlogged_api.api.util.FluidloggedUtils;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.MethodNode;

public final class PluginBlockGrass
implements IASMPlugin {
    public boolean isMethodValid(@Nonnull MethodNode method, boolean obfuscated) {
        return method.name.equals(obfuscated ? "func_180650_b" : "updateTick");
    }

    public boolean transform(@Nonnull InsnList instructions, @Nonnull MethodNode method, @Nonnull AbstractInsnNode insn, boolean obfuscated, int index) {
        if (insn.getOpcode() == 5 && insn.getNext().getOpcode() == 164) {
            ((JumpInsnNode)insn.getNext()).setOpcode(153);
            instructions.insert(insn, (AbstractInsnNode)this.genMethodNode("cannotSurviveAt", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;)Z"));
            this.removeFrom(instructions, insn, -11);
        } else if (insn.getOpcode() == 5 && insn.getNext().getOpcode() == 163) {
            ((JumpInsnNode)insn.getNext()).setOpcode(153);
            instructions.insert(insn, (AbstractInsnNode)this.genMethodNode("canSpreadTo", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;)Z"));
            this.removeFrom(instructions, insn, -8);
            return true;
        }
        return false;
    }

    public static final class Hooks {
        public static boolean cannotSurviveAt(@Nonnull World world, @Nonnull BlockPos pos) {
            IBlockState state = world.func_180495_p(pos);
            if (state.func_177230_c() instanceof BlockSnow && (Integer)state.func_177229_b((IProperty)BlockSnow.field_176315_a) == 1) {
                return false;
            }
            return !FluidloggedUtils.getFluidState((IBlockAccess)world, (BlockPos)pos, (IBlockState)state).isEmpty() || state.getLightOpacity((IBlockAccess)world, pos) > 2 && world.func_175671_l(pos) < 4;
        }

        public static boolean canSpreadTo(@Nonnull World world, @Nonnull BlockPos pos) {
            IBlockState state = world.func_180495_p(pos);
            if (state.func_177230_c() instanceof BlockSnow && (Integer)state.func_177229_b((IProperty)BlockSnow.field_176315_a) == 1) {
                return true;
            }
            return FluidloggedUtils.getFluidState((IBlockAccess)world, (BlockPos)pos, (IBlockState)state).isEmpty() && state.getLightOpacity((IBlockAccess)world, pos) <= 2 && world.func_175671_l(pos) >= 4;
        }
    }
}

