/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.subaquatic.mod.asm.plugin.vanilla.block;

import git.jbredwards.fluidlogged_api.api.asm.IASMPlugin;
import git.jbredwards.subaquatic.mod.common.config.SubaquaticConfigHandler;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockHugeMushroom;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.objectweb.asm.tree.ClassNode;

public final class PluginBlockHugeMushroom
implements IASMPlugin {
    public boolean transformClass(@Nonnull ClassNode classNode, boolean obfuscated) {
        this.overrideMethod(classNode, method -> method.name.equals(obfuscated ? "func_185473_a" : "getItem"), "getSilkTouchDrop", "(Lnet/minecraft/block/state/IBlockState;)Lnet/minecraft/item/ItemStack;", generator -> generator.visitVarInsn(25, 3));
        this.addMethod(classNode, obfuscated ? "func_149700_E" : "canSilkHarvest", "()Z", null, null, generator -> generator.visitFieldInsn(178, "git/jbredwards/subaquatic/mod/common/config/SubaquaticConfigHandler$Server$Block", "mushroomBlockSilkTouch", "Z"));
        this.addMethod(classNode, obfuscated ? "func_180643_i" : "getSilkTouchDrop", "(Lnet/minecraft/block/state/IBlockState;)Lnet/minecraft/item/ItemStack;", "getSilkTouchDrop", "(Lnet/minecraft/block/state/IBlockState;)Lnet/minecraft/item/ItemStack;", generator -> generator.visitVarInsn(25, 1));
        this.overrideMethod(classNode, method -> method.name.equals(obfuscated ? "func_180642_a" : "getStateForPlacement"), "getStateForPlacement", "(Lnet/minecraft/block/BlockHugeMushroom;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;I)Lnet/minecraft/block/state/IBlockState;", generator -> {
            generator.visitVarInsn(25, 0);
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
            generator.visitVarInsn(21, 7);
        });
        this.addMethod(classNode, "quantityDropped", "(Lnet/minecraft/block/state/IBlockState;ILjava/util/Random;)I", "quantityDropped", "(Lnet/minecraft/block/state/IBlockState;ILjava/util/Random;)I", generator -> {
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(21, 2);
            generator.visitVarInsn(25, 3);
        });
        return false;
    }

    public static final class Hooks {
        @Nonnull
        public static ItemStack getSilkTouchDrop(@Nonnull IBlockState state) {
            if (state.func_177230_c() == Blocks.field_150419_aX || state.func_177230_c() == Blocks.field_150420_aW) {
                switch ((BlockHugeMushroom.EnumType)state.func_177229_b((IProperty)BlockHugeMushroom.field_176380_a)) {
                    case STEM: {
                        return new ItemStack(state.func_177230_c(), 1, 1);
                    }
                    case ALL_STEM: {
                        return new ItemStack(state.func_177230_c(), 1, 2);
                    }
                }
            }
            return new ItemStack(state.func_177230_c(), 1, 0);
        }

        @Nonnull
        public static IBlockState getStateForPlacement(@Nonnull BlockHugeMushroom block, @Nonnull World world, @Nonnull BlockPos pos, int meta) {
            switch (meta) {
                case 1: {
                    return block.func_176223_P().func_177226_a((IProperty)BlockHugeMushroom.field_176380_a, (Comparable)BlockHugeMushroom.EnumType.STEM);
                }
                case 2: {
                    return block.func_176223_P().func_177226_a((IProperty)BlockHugeMushroom.field_176380_a, (Comparable)BlockHugeMushroom.EnumType.ALL_STEM);
                }
            }
            return block.func_176223_P();
        }

        public static int quantityDropped(@Nonnull IBlockState state, int fortune, @Nonnull Random rand) {
            if (!SubaquaticConfigHandler.Server.Block.mushroomStemsDropMushrooms) {
                switch ((BlockHugeMushroom.EnumType)state.func_177229_b((IProperty)BlockHugeMushroom.field_176380_a)) {
                    case STEM: 
                    case ALL_STEM: {
                        return 0;
                    }
                }
            }
            int oldQuantityDropped = state.func_177230_c().func_149745_a(rand);
            return SubaquaticConfigHandler.Server.Block.mushroomBlockFortune ? Math.min(4, oldQuantityDropped + rand.nextInt(fortune + 1)) : oldQuantityDropped;
        }
    }
}

