/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.subaquatic.mod.asm.plugin.vanilla.client;

import git.jbredwards.fluidlogged_api.api.asm.IASMPlugin;
import git.jbredwards.fluidlogged_api.api.util.FluidloggedUtils;
import git.jbredwards.subaquatic.mod.common.config.SubaquaticConfigHandler;
import javax.annotation.Nonnull;
import net.minecraft.block.material.Material;
import net.minecraft.client.particle.Particle;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public final class PluginParticleExplosionHuge
implements IASMPlugin {
    public boolean isMethodValid(@Nonnull MethodNode method, boolean obfuscated) {
        return method.name.equals(obfuscated ? "func_189213_a" : "onUpdate");
    }

    public boolean transform(@Nonnull InsnList instructions, @Nonnull MethodNode method, @Nonnull AbstractInsnNode insn, boolean obfuscated, int index) {
        if (this.checkMethod(insn, obfuscated ? "func_175688_a" : "spawnParticle")) {
            instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 0));
            instructions.insertBefore(insn, (AbstractInsnNode)this.genMethodNode("spawnParticle", "(Lnet/minecraft/world/World;Lnet/minecraft/util/EnumParticleTypes;DDDDDD[ILnet/minecraft/client/particle/Particle;)V"));
            instructions.remove(insn);
            return true;
        }
        return false;
    }

    public static final class Hooks {
        @SideOnly(value=Side.CLIENT)
        public static void spawnParticle(@Nonnull World world, @Nonnull EnumParticleTypes particle, double xCoord, double yCoord, double zCoord, double xSpeedIn, double ySpeedIn, double zSpeedIn, int[] parameters, @Nonnull Particle parent) {
            int underwaterExplosionBubbleCount = SubaquaticConfigHandler.Client.Particle.underwaterExplosionBubbleCount;
            if (underwaterExplosionBubbleCount != 0 && FluidloggedUtils.getFluidOrReal((IBlockAccess)world, (BlockPos)new BlockPos(xCoord, yCoord, zCoord)).func_185904_a() == Material.field_151586_h) {
                double xSpeed = xCoord - parent.field_187126_f;
                double ySpeed = yCoord - parent.field_187127_g;
                double zSpeed = zCoord - parent.field_187128_h;
                for (int i = 0; i < underwaterExplosionBubbleCount; ++i) {
                    world.func_175688_a(EnumParticleTypes.WATER_BUBBLE, xCoord, yCoord, zCoord, xSpeed * Math.random() * 2.0, ySpeed * Math.random() * 2.0, zSpeed * Math.random() * 2.0, new int[0]);
                }
            }
            world.func_175688_a(particle, xCoord, yCoord, zCoord, xSpeedIn, ySpeedIn, zSpeedIn, parameters);
        }
    }
}

