/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.subaquatic.mod.asm.plugin.vanilla.entity;

import git.jbredwards.fluidlogged_api.api.asm.IASMPlugin;
import git.jbredwards.fluidlogged_api.api.util.FluidState;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public final class PluginEntity
implements IASMPlugin {
    public boolean isMethodValid(@Nonnull MethodNode method, boolean obfuscated) {
        return method.name.equals(obfuscated ? "func_70091_d" : "move");
    }

    public boolean transform(@Nonnull InsnList instructions, @Nonnull MethodNode method, @Nonnull AbstractInsnNode insn, boolean obfuscated, int index) {
        if (insn.getOpcode() == 18 && ((LdcInsnNode)insn).cst.equals(0.2f)) {
            this.removeFrom(instructions, insn, 1);
        } else if (this.checkField(insn, obfuscated ? "field_151579_a" : "AIR")) {
            ((JumpInsnNode)insn.getNext()).setOpcode(153);
            InsnList list = new InsnList();
            list.add((AbstractInsnNode)new VarInsnNode(25, obfuscated ? 71 : 26));
            list.add((AbstractInsnNode)new VarInsnNode(25, 0));
            list.add((AbstractInsnNode)this.genMethodNode("hasNoCollision", "(Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/entity/Entity;)Z"));
            instructions.insert(insn, list);
            this.removeFrom(instructions, insn, -1);
        } else if (insn.getOpcode() == 193 && ((TypeInsnNode)insn).desc.equals("net/minecraft/block/BlockFenceGate")) {
            instructions.insert(insn, (AbstractInsnNode)new InsnNode(4));
            this.removeFrom(instructions, insn, -7);
            return true;
        }
        return false;
    }

    public boolean transformClass(@Nonnull ClassNode classNode, boolean obfuscated) {
        this.overrideMethod(classNode, method -> method.name.equals(obfuscated ? "func_174808_Z" : "createRunningParticles"), "createRunningParticles", "(Lnet/minecraft/entity/Entity;)V", generator -> generator.visitVarInsn(25, 0));
        return true;
    }

    public static final class Hooks {
        public static void createRunningParticles(@Nonnull Entity entity) {
            BlockPos pos = new BlockPos(entity);
            IBlockState state = entity.field_70170_p.func_180495_p(pos);
            if (!Hooks.canCollideCheck(entity.field_70170_p, pos, state, true)) {
                return;
            }
            if (Hooks.hasNoCollision(state, pos, entity)) {
                pos = pos.func_177977_b();
                state = entity.field_70170_p.func_180495_p(pos);
            }
            if (!state.func_177230_c().addRunningEffects(state, entity.field_70170_p, pos, entity) && state.func_185901_i() != EnumBlockRenderType.INVISIBLE && Hooks.canCollideCheck(entity.field_70170_p, pos, state, false)) {
                Random rand = entity.field_70170_p.field_73012_v;
                entity.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, entity.field_70165_t + ((double)rand.nextFloat() - 0.5) * (double)entity.field_70130_N, entity.func_174813_aQ().field_72338_b + 0.1, entity.field_70161_v + ((double)rand.nextFloat() - 0.5) * (double)entity.field_70130_N, -entity.field_70159_w * 4.0, 1.5, -entity.field_70179_y * 4.0, new int[]{Block.func_176210_f((IBlockState)state)});
            }
        }

        public static boolean hasNoCollision(@Nonnull IBlockState state, @Nonnull BlockPos pos, @Nonnull Entity entity) {
            if (state.func_177230_c().isAir(state, (IBlockAccess)entity.field_70170_p, pos) || !state.func_177230_c().func_176209_a(state, false)) {
                return true;
            }
            double xz = entity.field_70130_N / 2.0f;
            return !state.func_185900_c((IBlockAccess)entity.field_70170_p, pos).func_186670_a(pos).func_186668_a(entity.field_70165_t - xz, entity.field_70163_u - 0.2, entity.field_70161_v - xz, entity.field_70165_t + xz, entity.field_70163_u + 1.0E-4, entity.field_70161_v + xz);
        }

        public static boolean canCollideCheck(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, boolean allowAir) {
            if (allowAir && state.func_177230_c().isAir(state, (IBlockAccess)world, pos)) {
                return true;
            }
            if (!state.func_177230_c().func_176209_a(state, false)) {
                return false;
            }
            FluidState fluidState = FluidState.get((IBlockAccess)world, (BlockPos)pos);
            return fluidState.isEmpty() || fluidState.getBlock().func_176209_a(fluidState.getState(), false);
        }
    }
}

