/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.subaquatic.mod.asm.plugin.vanilla.entity;

import git.jbredwards.fluidlogged_api.api.asm.IASMPlugin;
import git.jbredwards.subaquatic.api.block.IOxygenSupplier;
import git.jbredwards.subaquatic.api.entity.INextAirEntity;
import git.jbredwards.subaquatic.mod.common.config.SubaquaticConfigHandler;
import javax.annotation.Nonnull;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.BlockPos;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodNode;

public final class PluginEntityLivingBase
implements IASMPlugin {
    public boolean isMethodValid(@Nonnull MethodNode method, boolean obfuscated) {
        return method.name.equals(obfuscated ? "func_70030_z" : "onEntityUpdate");
    }

    public boolean transform(@Nonnull InsnList instructions, @Nonnull MethodNode method, @Nonnull AbstractInsnNode insn, boolean obfuscated, int index) {
        if (this.checkMethod(insn, obfuscated ? "func_70055_a" : "isInsideOfMaterial")) {
            instructions.insert(insn, (AbstractInsnNode)this.genMethodNode("hasNoOxygen", "(Lnet/minecraft/entity/EntityLivingBase;)Z"));
            this.removeFrom(instructions, insn, -1);
        } else if (this.checkMethod(insn, obfuscated ? "func_70050_g" : "setAir")) {
            this.removeFrom(instructions, insn, -2);
            return true;
        }
        return false;
    }

    public static final class Hooks {
        public static boolean hasNoOxygen(@Nonnull EntityLivingBase entity) {
            BlockPos eyePos = new BlockPos(entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e(), entity.field_70161_v);
            IBlockState eyeState = entity.field_70170_p.func_180495_p(eyePos);
            if (eyeState.func_177230_c() instanceof IOxygenSupplier) {
                IOxygenSupplier oxygenSupplier = (IOxygenSupplier)eyeState.func_177230_c();
                if (oxygenSupplier.canSupplyOxygenTo(entity.field_70170_p, eyePos, eyeState, entity)) {
                    entity.func_70050_g(Hooks.increaseAirSupply(entity, oxygenSupplier.getOxygenToSupply(entity.field_70170_p, eyePos, eyeState, entity)));
                    return false;
                }
            } else if (!entity.func_70055_a(Material.field_151586_h)) {
                entity.func_70050_g(Hooks.increaseAirSupply(entity, 4));
                return false;
            }
            return true;
        }

        public static int increaseAirSupply(@Nonnull EntityLivingBase entity, int airToGain) {
            return entity instanceof INextAirEntity ? ((INextAirEntity)entity).increaseAirSupply(entity.func_70086_ai(), airToGain, !SubaquaticConfigHandler.Common.Entity.gradualAirReplenish) : (SubaquaticConfigHandler.Common.Entity.gradualAirReplenish ? Math.min(entity.func_70086_ai() + airToGain, 300) : 300);
        }
    }
}

