/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.subaquatic.mod.asm.plugin.vanilla.item;

import git.jbredwards.fluidlogged_api.api.asm.IASMPlugin;
import java.util.Arrays;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.objectweb.asm.tree.ClassNode;

public final class PluginItemDye
implements IASMPlugin {
    public boolean transformClass(@Nonnull ClassNode classNode, boolean obfuscated) {
        this.overrideMethod(classNode, method -> method.name.equals(obfuscated ? "func_180617_a" : "spawnBonemealParticles"), "spawnBonemealParticles", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;I)V", generator -> {
            generator.visitVarInsn(25, 0);
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(21, 2);
        });
        return false;
    }

    public static final class Hooks {
        public static void spawnBonemealParticles(@Nonnull World world, @Nonnull BlockPos pos, int amount) {
            IBlockState state = world.func_180495_p(pos);
            AxisAlignedBB bb = state.func_185900_c((IBlockAccess)world, pos);
            if (amount == 0) {
                amount = Math.max(1, (int)(bb.func_72320_b() * 10.0));
            }
            if (state.func_185914_p()) {
                EnumFacing[] possibleSides = (EnumFacing[])Arrays.stream(EnumFacing.field_82609_l).filter(side -> !world.func_180495_p(pos.func_177972_a(side)).func_185914_p()).toArray(EnumFacing[]::new);
                amount *= possibleSides.length;
                while (amount-- > 0) {
                    EnumFacing side2 = possibleSides[world.field_73012_v.nextInt(possibleSides.length)];
                    double xOffset = Hooks.getOffset(world.field_73012_v, bb.field_72340_a, bb.field_72336_d, side2.func_82601_c());
                    double yOffset = Hooks.getOffset(world.field_73012_v, bb.field_72338_b, bb.field_72337_e, side2.func_96559_d());
                    double zOffset = Hooks.getOffset(world.field_73012_v, bb.field_72339_c, bb.field_72334_f, side2.func_82599_e());
                    double xSpeed = world.field_73012_v.nextGaussian() * 0.002;
                    double ySpeed = world.field_73012_v.nextGaussian() * 0.002;
                    double zSpeed = world.field_73012_v.nextGaussian() * 0.002;
                    world.func_175688_a(EnumParticleTypes.VILLAGER_HAPPY, (double)pos.func_177958_n() + xOffset, (double)pos.func_177956_o() + yOffset, (double)pos.func_177952_p() + zOffset, xSpeed, ySpeed, zSpeed, new int[0]);
                }
            } else {
                while (amount-- > 0) {
                    double xOffset = MathHelper.func_82716_a((Random)world.field_73012_v, (double)bb.field_72340_a, (double)bb.field_72336_d);
                    double yOffset = MathHelper.func_82716_a((Random)world.field_73012_v, (double)bb.field_72338_b, (double)bb.field_72337_e);
                    double zOffset = MathHelper.func_82716_a((Random)world.field_73012_v, (double)bb.field_72339_c, (double)bb.field_72334_f);
                    double xSpeed = world.field_73012_v.nextGaussian() * 0.002;
                    double ySpeed = world.field_73012_v.nextGaussian() * 0.002;
                    double zSpeed = world.field_73012_v.nextGaussian() * 0.002;
                    world.func_175688_a(EnumParticleTypes.VILLAGER_HAPPY, (double)pos.func_177958_n() + xOffset, (double)pos.func_177956_o() + yOffset, (double)pos.func_177952_p() + zOffset, xSpeed, ySpeed, zSpeed, new int[0]);
                }
            }
        }

        public static double getOffset(@Nonnull Random rand, double min, double max, int offset) {
            switch (offset) {
                case -1: {
                    return min - 0.0625;
                }
                case 1: {
                    return max + 0.0625;
                }
            }
            return MathHelper.func_82716_a((Random)rand, (double)min, (double)max);
        }
    }
}

