/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.subaquatic.mod.client;

import git.jbredwards.fluidlogged_api.api.util.FluidloggedUtils;
import git.jbredwards.subaquatic.mod.Subaquatic;
import git.jbredwards.subaquatic.mod.client.item.ICustomModel;
import git.jbredwards.subaquatic.mod.client.item.model.BakedEntityBucketModel;
import git.jbredwards.subaquatic.mod.client.item.model.ModelContainerBoat;
import git.jbredwards.subaquatic.mod.client.particle.ParticleBubblePop;
import git.jbredwards.subaquatic.mod.common.capability.IEntityBucket;
import git.jbredwards.subaquatic.mod.common.compat.inspirations.InspirationsHandler;
import git.jbredwards.subaquatic.mod.common.config.SubaquaticWaterColorConfig;
import git.jbredwards.subaquatic.mod.common.entity.util.fish_bucket.AbstractEntityBucketHandler;
import git.jbredwards.subaquatic.mod.common.init.SubaquaticBlocks;
import git.jbredwards.subaquatic.mod.common.init.SubaquaticItems;
import java.awt.Color;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.resource.ISelectiveResourceReloadListener;
import net.minecraftforge.client.resource.VanillaResourceType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.terraingen.BiomeEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.ProgressManager;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(modid="subaquatic", value={Side.CLIENT})
public final class ClientEventHandler {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void applyWaterSurfaceColor(@Nonnull BiomeEvent.GetWaterColor event) {
        event.setNewColor(SubaquaticWaterColorConfig.getSurfaceColor(event.getBiome(), event.getOriginalColor()));
    }

    @SubscribeEvent(receiveCanceled=true)
    public static void applyWaterFogColor(@Nonnull EntityViewRenderEvent.FogColors event) {
        if (event.getState().func_185904_a() == Material.field_151586_h && FluidloggedUtils.isCompatibleFluid((Fluid)FluidloggedUtils.getFluidFromState((IBlockState)event.getState()), (Fluid)FluidRegistry.WATER)) {
            float[] fogComp = SubaquaticWaterColorConfig.getFogColorAt((IBlockAccess)event.getEntity().field_70170_p, event.getEntity().func_180425_c());
            event.setRed(fogComp[0] * 0.5f + 0.5f * event.getRed());
            event.setGreen(fogComp[1] * 0.5f + 0.5f * event.getGreen());
            event.setBlue(fogComp[2] * 0.5f + 0.5f * event.getBlue());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    static void registerBlockColors(@Nonnull ColorHandlerEvent.Block event) {
        event.getBlockColors().func_186722_a((state, world, pos, tintIndex) -> tintIndex != 1 || world == null || pos == null ? -1 : (Subaquatic.isInspirationsInstalled ? InspirationsHandler.getCauldronColor(world, pos) : BiomeColorHelper.func_180288_c((IBlockAccess)world, (BlockPos)pos)), new Block[]{Blocks.field_150383_bp});
    }

    @SubscribeEvent
    static void registerModels(@Nonnull ModelRegistryEvent event) {
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)ModelContainerBoat.Loader.INSTANCE);
        for (Block block : SubaquaticBlocks.INIT) {
            if (!(block instanceof ICustomModel)) continue;
            ((ICustomModel)block).registerModels();
        }
        for (Item item : SubaquaticItems.INIT) {
            if (item instanceof ICustomModel) {
                ((ICustomModel)item).registerModels();
                continue;
            }
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.delegate.name(), "inventory"));
        }
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a((IResourceManagerReloadListener)((ISelectiveResourceReloadListener)(resourceManager, resourcePredicate) -> {
            if (resourcePredicate.test(VanillaResourceType.MODELS)) {
                BakedEntityBucketModel.clearQuadsCache();
                FluidRegistry.WATER.setColor(-1);
            }
        }));
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)Blocks.field_150420_aW), (int)0, (ModelResourceLocation)new ModelResourceLocation(Blocks.field_150420_aW.delegate.name(), "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)Blocks.field_150420_aW), (int)1, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("subaquatic", "brown_mushroom_block_stem"), "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)Blocks.field_150420_aW), (int)2, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("subaquatic", "brown_mushroom_block_stem_all"), "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)Blocks.field_150419_aX), (int)0, (ModelResourceLocation)new ModelResourceLocation(Blocks.field_150419_aX.delegate.name(), "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)Blocks.field_150419_aX), (int)1, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("subaquatic", "red_mushroom_block_stem"), "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)Blocks.field_150419_aX), (int)2, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("subaquatic", "red_mushroom_block_stem_all"), "inventory"));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    static void handleModelOverrides(@Nonnull ModelBakeEvent event) {
        for (Item bucket : IEntityBucket.getValidBuckets()) {
            for (String variant : event.getModelLoader().func_177596_a(bucket)) {
                ModelResourceLocation modelLocation = ModelLoader.getInventoryVariant((String)variant);
                IBakedModel bucketModel = (IBakedModel)event.getModelRegistry().func_82594_a((Object)modelLocation);
                if (bucketModel == null) continue;
                event.getModelRegistry().func_82595_a((Object)modelLocation, (Object)new BakedEntityBucketModel(bucketModel));
            }
        }
        FluidRegistry.WATER.setColor(-12609564);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    static void applyEntityBucketColorOverrides(@Nonnull ColorHandlerEvent.Item event) {
        Map itemColorMap = (Map)ObfuscationReflectionHelper.getPrivateValue(ItemColors.class, (Object)event.getItemColors(), (String)"itemColorMap");
        for (Item bucket : IEntityBucket.getValidBuckets()) {
            IItemColor oldColorHandler = itemColorMap.getOrDefault(bucket.delegate, (stack, tintIndex) -> -1);
            event.getItemColors().func_186730_a((stack, tintIndex) -> {
                int color;
                IEntityBucket cap = IEntityBucket.get((ICapabilityProvider)stack);
                if (cap != null && cap.getHandler() != null && (color = cap.getHandler().colorMultiplier(stack, tintIndex)) != -1) {
                    return color;
                }
                return oldColorHandler.func_186726_a(stack, tintIndex);
            }, new Item[]{bucket});
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    static void handleAirGuiOverlay(@Nonnull RenderGameOverlayEvent.Pre event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.AIR) {
            Minecraft.func_71410_x().field_71424_I.func_76320_a("air");
            Entity entity = Minecraft.func_71410_x().func_175606_aa();
            int air = entity.func_70086_ai();
            if (air < 300 || entity.func_70055_a(Material.field_151586_h)) {
                GlStateManager.func_179147_l();
                int left = event.getResolution().func_78326_a() / 2 + 91;
                int top = event.getResolution().func_78328_b() - GuiIngameForge.right_height;
                int full = MathHelper.func_76123_f((float)((float)(air - 2) * 10.0f / 300.0f));
                int partial = MathHelper.func_76123_f((float)((float)air * 10.0f / 300.0f)) - full;
                GuiIngame gui = Minecraft.func_71410_x().field_71456_v;
                for (int i = 0; i < full + partial; ++i) {
                    gui.func_73729_b(left - i * 8 - 9, top, i < full ? 16 : 25, 18, 9, 9);
                }
                GuiIngameForge.right_height += 10;
                GlStateManager.func_179084_k();
            }
            Minecraft.func_71410_x().field_71424_I.func_76319_b();
            event.setCanceled(true);
            MinecraftForge.EVENT_BUS.post((Event)new RenderGameOverlayEvent.Post((RenderGameOverlayEvent)event, event.getType()));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    static void handleEntityBucketTooltip(@Nonnull ItemTooltipEvent event) {
        IEntityBucket cap = IEntityBucket.get((ICapabilityProvider)event.getItemStack());
        if (cap != null && cap.getHandler() != null) {
            cap.getHandler().handleTooltip(event.getToolTip(), event.getItemStack(), event.getFlags());
        }
    }

    @SubscribeEvent(receiveCanceled=true)
    static void registerTextures(@Nonnull TextureStitchEvent.Pre event) {
        if (event.getMap() != Minecraft.func_71410_x().func_147117_R()) {
            return;
        }
        event.getMap().func_174942_a(new ResourceLocation("subaquatic", "blocks/water_flow"));
        event.getMap().func_174942_a(new ResourceLocation("subaquatic", "blocks/water_overlay"));
        event.getMap().func_174942_a(new ResourceLocation("subaquatic", "blocks/water_still"));
        event.getMap().func_174942_a(new ResourceLocation("subaquatic", "misc/underwater"));
        for (int i = 0; i < 5; ++i) {
            ParticleBubblePop.TEXTURES[i] = event.getMap().func_174942_a(new ResourceLocation("subaquatic", "particles/bubble_pop_" + i));
        }
        AbstractEntityBucketHandler.BUCKET_HANDLERS.values().forEach(handler -> ((AbstractEntityBucketHandler)handler.get()).registerSprites(event.getMap()));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    static void handleFluidParticleBaseColor(@Nonnull TextureStitchEvent.Post event) {
        if (event.getMap() != Minecraft.func_71410_x().func_147117_R()) {
            return;
        }
        Subaquatic.LOGGER.info("Attempting to gather the average pixel colors of each still fluid texture...");
        SubaquaticWaterColorConfig.FLUID_PIXEL_BASE_COLORS.clear();
        Collection fluids = FluidRegistry.getRegisteredFluids().values();
        ProgressManager.ProgressBar progressBar = ProgressManager.push((String)"Fluid Texture Averages", (int)fluids.size());
        fluids.forEach(fluid -> {
            TextureAtlasSprite texture = event.getMap().func_110572_b(fluid.getStill().toString());
            long pixelRedSum = 0L;
            long pixelGreenSum = 0L;
            long pixelBlueSum = 0L;
            int size = 0;
            progressBar.step(texture.func_94215_i());
            for (int frame = 0; frame < texture.func_110970_k(); ++frame) {
                int[][] nArray = texture.func_147965_a(frame);
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int[] textureData;
                    for (int pixel : textureData = nArray[i]) {
                        pixelRedSum += (long)(pixel >> 16 & 0xFF);
                        pixelGreenSum += (long)(pixel >> 8 & 0xFF);
                        pixelBlueSum += (long)(pixel & 0xFF);
                        ++size;
                    }
                }
            }
            SubaquaticWaterColorConfig.FLUID_PIXEL_BASE_COLORS.put((Fluid)fluid, new Color((float)pixelRedSum / 255.0f / (float)size, (float)pixelGreenSum / 255.0f / (float)size, (float)pixelBlueSum / 255.0f / (float)size));
        });
        ProgressManager.pop((ProgressManager.ProgressBar)progressBar);
        Subaquatic.LOGGER.info("Success!");
    }
}

