/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.subaquatic.mod.client.entity.renderer;

import git.jbredwards.subaquatic.mod.client.entity.model.ModelPufferfish;
import git.jbredwards.subaquatic.mod.common.entity.living.EntityPufferfish;
import javax.annotation.Nonnull;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderPufferfish
extends RenderLiving<EntityPufferfish> {
    @Nonnull
    private static final ResourceLocation TEXTURE = new ResourceLocation("subaquatic", "textures/entity/fish/pufferfish.png");
    @Nonnull
    protected final ModelPufferfish smallModel = new ModelPufferfish.Small();
    @Nonnull
    protected final ModelPufferfish mediumModel = new ModelPufferfish.Medium();
    @Nonnull
    protected final ModelPufferfish largeModel = new ModelPufferfish.Large();

    public RenderPufferfish(@Nonnull RenderManager renderManagerIn) {
        super(renderManagerIn, (ModelBase)new ModelPufferfish.Small(), 0.1f);
    }

    @Nonnull
    protected ResourceLocation getEntityTexture(@Nonnull EntityPufferfish entity) {
        return TEXTURE;
    }

    public void doRender(@Nonnull EntityPufferfish entity, double x, double y, double z, float entityYaw, float partialTicks) {
        int puffState = entity.getPuffState();
        this.field_77045_g = puffState == 0 ? this.smallModel : (puffState == 1 ? this.mediumModel : this.largeModel);
        this.field_76989_e = 0.1f + 0.1f * (float)puffState;
        super.func_76986_a((EntityLiving)entity, x, y, z, entityYaw, partialTicks);
    }

    protected void applyRotations(@Nonnull EntityPufferfish entityLiving, float ageInTicks, float rotationYaw, float partialTicks) {
        GlStateManager.func_179137_b((double)0.0, (double)(Math.cos((double)ageInTicks * 0.05) * 0.08), (double)0.0);
        super.func_77043_a((EntityLivingBase)entityLiving, ageInTicks, rotationYaw, partialTicks);
    }
}

