/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.subaquatic.mod.client.entity.renderer;

import git.jbredwards.subaquatic.mod.client.entity.layer.LayerTropicalFishPattern;
import git.jbredwards.subaquatic.mod.client.entity.model.ModelTropicalFish;
import git.jbredwards.subaquatic.mod.common.entity.living.EntityTropicalFish;
import git.jbredwards.subaquatic.mod.common.entity.util.TropicalFishData;
import javax.annotation.Nonnull;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderTropicalFish
extends RenderLiving<EntityTropicalFish> {
    @Nonnull
    protected final ModelTropicalFish modelA = new ModelTropicalFish.A(0.0f);
    @Nonnull
    protected final ModelTropicalFish modelB = new ModelTropicalFish.B(0.0f);

    public RenderTropicalFish(@Nonnull RenderManager renderManagerIn) {
        super(renderManagerIn, (ModelBase)new ModelTropicalFish.A(0.0f), 0.15f);
        this.func_177094_a(new LayerTropicalFishPattern(this));
    }

    @Nonnull
    protected ResourceLocation getEntityTexture(@Nonnull EntityTropicalFish entity) {
        return new ResourceLocation("subaquatic", "textures/entity/fish/tropical_" + entity.getVariant().primaryShape + ".png");
    }

    public void doRender(@Nonnull EntityTropicalFish entity, double x, double y, double z, float entityYaw, float partialTicks) {
        TropicalFishData variant = entity.getVariant();
        float[] colors = variant.primaryColor.func_193349_f();
        this.field_77045_g = (variant.primaryShape & 1) == 0 ? this.modelA : this.modelB;
        GlStateManager.func_179124_c((float)colors[0], (float)colors[1], (float)colors[2]);
        super.func_76986_a((EntityLiving)entity, x, y, z, entityYaw, partialTicks);
    }

    protected void applyRotations(@Nonnull EntityTropicalFish entityLiving, float ageInTicks, float rotationYaw, float partialTicks) {
        super.func_77043_a((EntityLivingBase)entityLiving, ageInTicks, rotationYaw, partialTicks);
        GlStateManager.func_179114_b((float)(4.3f * MathHelper.func_76126_a((float)(0.6f * ageInTicks))), (float)0.0f, (float)1.0f, (float)0.0f);
        if (!entityLiving.func_70090_H()) {
            GlStateManager.func_179137_b((double)0.2, (double)0.1, (double)0.0);
            GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        }
    }
}

