/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.subaquatic.mod.client.item.model;

import com.google.common.collect.ImmutableList;
import git.jbredwards.subaquatic.mod.common.capability.IEntityBucket;
import git.jbredwards.subaquatic.mod.common.entity.util.fish_bucket.AbstractEntityBucketHandler;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

@SideOnly(value=Side.CLIENT)
public class BakedEntityBucketModel
extends BakedModelWrapper<IBakedModel> {
    @Nonnull
    protected static final Map<ResourceLocation, List<BakedQuad>> OVERLAY_QUADS = new HashMap<ResourceLocation, List<BakedQuad>>();
    @Nullable
    protected final AbstractEntityBucketHandler entityData;

    public static void clearQuadsCache() {
        OVERLAY_QUADS.clear();
    }

    public BakedEntityBucketModel(@Nonnull IBakedModel originalModel) {
        this(originalModel, null);
    }

    public BakedEntityBucketModel(@Nonnull IBakedModel originalModel, @Nullable AbstractEntityBucketHandler entityDataIn) {
        super(originalModel);
        this.entityData = entityDataIn;
    }

    @Nonnull
    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        if (this.entityData == null || side != null) {
            return super.func_188616_a(state, side, rand);
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll((Iterable)super.func_188616_a(state, null, rand));
        builder.addAll(this.entityData.getRenderQuads());
        return builder.build();
    }

    @Nonnull
    public static List<BakedQuad> getQuadsForSprite(@Nonnull ResourceLocation texture, int tintIndex) {
        return OVERLAY_QUADS.computeIfAbsent(texture, entity -> {
            TRSRTransformation identity = TRSRTransformation.identity();
            return ItemLayerModel.getQuadsForSprite((int)tintIndex, (TextureAtlasSprite)((TextureAtlasSprite)ModelLoader.defaultTextureGetter().apply(texture)), (VertexFormat)DefaultVertexFormats.field_176599_b, Optional.of(new TRSRTransformation(new Vector3f(0.0f, -5.0E-5f, -0.005f), identity.getLeftRot(), new Vector3f(1.0f, 1.0001f, 1.01f), identity.getRightRot())));
        });
    }

    @Nonnull
    public ItemOverrideList func_188617_f() {
        return new ItemOverrideList(Collections.emptyList()){

            @Nonnull
            public IBakedModel handleItemState(@Nonnull IBakedModel originalModelIn, @Nonnull ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                IBakedModel bucketOverride = BakedEntityBucketModel.this.originalModel.func_188617_f().handleItemState(BakedEntityBucketModel.this.originalModel, stack, world, entity);
                IEntityBucket cap = IEntityBucket.get((ICapabilityProvider)stack);
                return cap != null ? new BakedEntityBucketModel(bucketOverride, cap.getHandler()) : bucketOverride;
            }
        };
    }

    @Nonnull
    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(@Nonnull ItemCameraTransforms.TransformType cameraTransformType) {
        Pair oldPerspective = super.handlePerspective(cameraTransformType);
        return Pair.of((Object)((Object)new BakedEntityBucketModel((IBakedModel)oldPerspective.getKey(), this.entityData)), (Object)oldPerspective.getValue());
    }
}

